/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.network.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import express.http.RequestMethod;
import express.utils.Status;
import io.socket.client.AckWithTimeout;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import me.lianecx.discordlinker.DiscordLinker;
import me.lianecx.discordlinker.events.TeamChangeEvent;
import me.lianecx.discordlinker.network.ChatType;
import me.lianecx.discordlinker.network.HasRequiredRoleResponse;
import me.lianecx.discordlinker.network.Router;
import me.lianecx.discordlinker.network.StatsUpdateEvent;
import me.lianecx.discordlinker.network.adapters.HttpAdapter;
import me.lianecx.discordlinker.network.adapters.NetworkAdapter;
import me.lianecx.discordlinker.network.adapters.WebSocketAdapter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class AdapterManager {
    public static int BOT_PORT = DiscordLinker.getPluginVersion().contains("SNAPSHOT") ? 81 : DiscordLinker.getPlugin().getConfig().getInt("bot_port", 80);
    private int httpPort;
    private NetworkAdapter adapter;

    public AdapterManager(String token, int httpPort) {
        this.httpPort = httpPort;
        this.adapter = new WebSocketAdapter(Collections.singletonMap("token", token));
    }

    public AdapterManager(int httpPort) {
        this.httpPort = httpPort;
        this.adapter = new HttpAdapter();
    }

    public static void setBotPort(int botPort) {
        BOT_PORT = botPort;
    }

    public static URI getBotURI() {
        return URI.create("http://api.mclinker.com:" + BOT_PORT);
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void start(Consumer<Boolean> callback) {
        if (this.adapter == null) {
            return;
        }
        this.adapter.disconnect();
        this.adapter.connect(this.httpPort, callback);
    }

    public void stop() {
        if (this.adapter != null) {
            this.adapter.disconnect();
        }
    }

    public void startHttp() {
        this.stop();
        this.adapter = new HttpAdapter();
        this.start(bool -> {});
    }

    public void stopHttp() {
        if (this.isHttpConnected()) {
            this.adapter.disconnect();
            this.adapter = null;
        }
    }

    public void connectWebsocket(String code, Consumer<Boolean> callback) {
        this.stop();
        String token = new BigInteger(130, new SecureRandom()).toString(16);
        HashMap<String, String> auth = new HashMap<String, String>();
        auth.put("code", code);
        auth.put("token", token);
        WebSocketAdapter tempAdapter = new WebSocketAdapter(auth, 5);
        tempAdapter.getSocket().once("auth-success", data -> {
            tempAdapter.setReconnectionAttempts(Integer.MAX_VALUE);
            this.adapter = tempAdapter;
            JsonObject dataObject = new JsonParser().parse(data[0].toString()).getAsJsonObject();
            JsonObject connJson = new JsonObject();
            connJson.addProperty("protocol", "websocket");
            connJson.addProperty("id", code.split(":")[0]);
            connJson.addProperty("token", token);
            connJson.add("channels", (JsonElement)new JsonArray());
            connJson.add("synced-roles", (JsonElement)new JsonArray());
            connJson.add("stats-channels", (JsonElement)new JsonArray());
            if (dataObject.has("requiredRoleToJoin") && !dataObject.get("requiredRoleToJoin").isJsonNull()) {
                connJson.add("requiredRoleToJoin", dataObject.get("requiredRoleToJoin"));
            }
            try {
                DiscordLinker.getPlugin().updateConn(connJson);
                callback.accept(true);
            }
            catch (IOException err) {
                DiscordLinker.getPlugin().getLogger().info(ChatColor.RED + "Failed to save connection data.");
                err.printStackTrace();
                this.stop();
                this.startHttp();
                callback.accept(false);
            }
        });
        tempAdapter.connect(this.httpPort, connected -> {
            if (connected.booleanValue()) {
                return;
            }
            tempAdapter.disconnect();
            callback.accept(false);
            if (this.adapter != null) {
                this.adapter.connect(this.httpPort, bool -> {});
            }
        });
    }

    public void disconnectForce() {
        if (this.adapter instanceof WebSocketAdapter && !((WebSocketAdapter)this.adapter).getSocket().connected()) {
            this.adapter.disconnect();
        } else {
            this.send(RequestMethod.GET, "/disconnect-force", "disconnect-force", new JsonObject());
        }
        DiscordLinker.getPlugin().deleteConn();
    }

    public boolean isWebSocketConnected() {
        return this.adapter instanceof WebSocketAdapter && ((WebSocketAdapter)this.adapter).getSocket().connected();
    }

    public boolean isHttpConnected() {
        return this.adapter instanceof HttpAdapter;
    }

    public void send(RequestMethod method, String route, String event, JsonObject body) {
        if (this.isWebSocketConnected()) {
            ((WebSocketAdapter)this.adapter).send(event, (JsonElement)body);
        } else if (this.isHttpConnected()) {
            HttpAdapter.send(method, route, (JsonElement)body);
        }
    }

    public void send(RequestMethod method, String route, String event, JsonObject body, final Consumer<Router.RouterResponse> callback) {
        if (this.isWebSocketConnected()) {
            ((WebSocketAdapter)this.adapter).send(event, (JsonElement)body, new AckWithTimeout(5000L){

                @Override
                public void onSuccess(Object ... args) {
                    try {
                        callback.accept(new Router.RouterResponse(Status._200, args[0].toString()));
                    }
                    catch (Exception e) {
                        callback.accept(null);
                    }
                }

                @Override
                public void onTimeout() {
                    callback.accept(null);
                }
            });
        } else {
            callback.accept(HttpAdapter.send(method, route, (JsonElement)body));
        }
    }

    public void chat(String message, ChatType type, String player) {
        JsonArray channels = DiscordLinker.getPlugin().filterChannels(type);
        if (channels == null || channels.size() == 0) {
            return;
        }
        JsonObject chatJson = new JsonObject();
        chatJson.addProperty("type", type.getKey());
        chatJson.addProperty("player", player);
        chatJson.addProperty("message", ChatColor.stripColor((String)message));
        chatJson.add("channels", (JsonElement)channels);
        this.send(RequestMethod.POST, "/chat", "chat", chatJson);
    }

    public void updateStatsChannel(StatsUpdateEvent event) {
        JsonArray channels = DiscordLinker.getPlugin().filterChannels(event);
        if (channels == null || channels.size() == 0) {
            return;
        }
        JsonObject statsJson = new JsonObject();
        statsJson.addProperty("event", event.getName());
        statsJson.add("channels", (JsonElement)channels);
        if (event == StatsUpdateEvent.MEMBERS) {
            statsJson.addProperty("members", (Number)Bukkit.getOnlinePlayers().size());
        }
        this.send(RequestMethod.POST, "/update-stats-channels", "update-stats-channels", statsJson);
    }

    public void addSyncedRoleMember(String name, boolean isGroup, UUID uuid) {
        this.updateSyncedRoleMember(name, isGroup, uuid, "add");
    }

    public void removeSyncedRoleMember(String name, boolean isGroup, UUID uuid) {
        this.updateSyncedRoleMember(name, isGroup, uuid, "remove");
    }

    private void updateSyncedRoleMember(String name, boolean isGroup, UUID uuid, String addOrRemove) {
        this.getSyncedRole(name, isGroup, role -> {
            if (role == null) {
                return;
            }
            JsonObject payload = new JsonObject();
            payload.add("id", role.get("id"));
            payload.addProperty("uuid", uuid.toString());
            if (addOrRemove.equals("add")) {
                this.send(RequestMethod.POST, "/add-synced-role-member", "add-synced-role-member", payload);
            } else if (addOrRemove.equals("remove")) {
                this.send(RequestMethod.POST, "/remove-synced-role-member", "remove-synced-role-member", payload);
            }
        });
    }

    public void removeSyncedRole(String name, boolean isGroup) {
        boolean hadTeamSyncedRole = DiscordLinker.getPlugin().hasTeamSyncedRole();
        this.getSyncedRole(name, isGroup, role -> {
            if (role == null) {
                return;
            }
            this.send(RequestMethod.POST, "/remove-synced-role", "remove-synced-role", (JsonObject)role);
            Router.handleChangeArray(role, "synced-roles", "remove");
            boolean hasTeamSyncedRole = DiscordLinker.getPlugin().hasTeamSyncedRole();
            if (hadTeamSyncedRole && !hasTeamSyncedRole) {
                TeamChangeEvent.stopTeamCheck();
            }
        });
    }

    public void getSyncedRole(String name, boolean isGroup, Consumer<JsonObject> callback) {
        if (DiscordLinker.getConnJson() == null) {
            callback.accept(null);
            return;
        }
        JsonArray syncedRoles = DiscordLinker.getConnJson().get("synced-roles").getAsJsonArray();
        AtomicReference<JsonObject> role = new AtomicReference<JsonObject>();
        for (JsonElement roleJson : syncedRoles) {
            JsonObject roleObj = roleJson.getAsJsonObject();
            if (!roleObj.get("name").getAsString().equals(name) || roleObj.get("isGroup").getAsBoolean() != isGroup) continue;
            role.set(roleObj);
        }
        if (role.get() == null) {
            callback.accept(null);
            return;
        }
        Router.getPlayers(name, isGroup, uuids -> {
            if (uuids == null) {
                callback.accept(null);
                return;
            }
            JsonArray players = new JsonArray();
            uuids.forEach(arg_0 -> ((JsonArray)players).add(arg_0));
            ((JsonObject)role.get()).add("players", (JsonElement)players);
            Router.handleChangeArray((JsonObject)role.get(), "synced-roles", "add");
            callback.accept((JsonObject)role.get());
        });
    }

    public void sendVerificationResponse(String code, UUID uuid) {
        JsonObject verifyJson = new JsonObject();
        verifyJson.addProperty("code", code);
        verifyJson.addProperty("uuid", uuid.toString());
        this.send(RequestMethod.POST, "/verify/response", "verify-response", verifyJson);
    }

    public void hasRequiredRole(UUID uuid, Consumer<HasRequiredRoleResponse> callback) {
        JsonObject verifyJson = new JsonObject();
        verifyJson.addProperty("uuid", uuid.toString());
        this.send(RequestMethod.POST, "/has-required-role", "has-required-role", verifyJson, body -> {
            if (body == null) {
                callback.accept(HasRequiredRoleResponse.ERROR);
            } else {
                try {
                    HasRequiredRoleResponse response = HasRequiredRoleResponse.valueOf(body.getJson().getAsJsonObject().get("response").getAsString().toUpperCase());
                    callback.accept(response);
                }
                catch (Exception e) {
                    callback.accept(HasRequiredRoleResponse.ERROR);
                }
            }
        });
    }

    public void verifyUser(Player player, int code) {
        JsonObject verifyJson = new JsonObject();
        verifyJson.addProperty("code", String.valueOf(code));
        verifyJson.addProperty("uuid", player.getUniqueId().toString());
        verifyJson.addProperty("username", player.getName());
        this.send(RequestMethod.POST, "/verify-user", "verify-user", verifyJson);
    }

    public void getInviteURL(Consumer<String> callback) {
        this.send(RequestMethod.POST, "/invite-url", "invite-url", new JsonObject(), body -> {
            if (body == null) {
                callback.accept(null);
            } else {
                try {
                    JsonObject bodyObject = body.getJson().getAsJsonObject();
                    if (bodyObject.get("url").isJsonNull()) {
                        callback.accept(null);
                    } else {
                        callback.accept(bodyObject.get("url").getAsString());
                    }
                }
                catch (Exception e) {
                    callback.accept(null);
                }
            }
        });
    }
}

