/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.network.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import express.Express;
import express.http.RequestMethod;
import express.http.request.Request;
import express.http.response.Response;
import express.utils.Status;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.lianecx.discordlinker.DiscordLinker;
import me.lianecx.discordlinker.network.Route;
import me.lianecx.discordlinker.network.Router;
import me.lianecx.discordlinker.network.adapters.AdapterManager;
import me.lianecx.discordlinker.network.adapters.NetworkAdapter;
import org.bukkit.ChatColor;

@Deprecated
public class HttpAdapter
implements NetworkAdapter {
    private final Express app = new Express();

    public HttpAdapter() {
        this.app.all((req, res) -> {
            Route route = Route.getRouteByPath(req.getPath());
            if (route == null) {
                res.sendStatus(Status._404);
                return;
            }
            if (route.doesRequireToken() && !this.checkToken(req) || route.isBotOnly() && !this.checkIp(req.getIp())) {
                res.setStatus(Status._401);
                res.send(Router.INVALID_AUTH.toString());
                return;
            }
            JsonObject data = this.parseRequest(req);
            if (route == Route.PUT_FILE) {
                Router.putFile(data, req.getBody(), routerResponse -> this.respond((Router.RouterResponse)routerResponse, res));
            } else if (route == Route.ROOT) {
                res.redirect("https://mclinker.com");
            } else {
                route.execute(data, routerResponse -> this.respond((Router.RouterResponse)routerResponse, res));
            }
        });
    }

    public static Router.RouterResponse send(RequestMethod method, String route, JsonElement body) {
        try {
            if (body.isJsonObject()) {
                body.getAsJsonObject().add("id", DiscordLinker.getConnJson().get("id"));
                body.getAsJsonObject().add("ip", DiscordLinker.getConnJson().get("ip"));
            }
            HttpURLConnection conn = (HttpURLConnection)new URL(AdapterManager.getBotURI() + route).openConnection();
            byte[] out = body.toString().getBytes(StandardCharsets.UTF_8);
            int length = out.length;
            conn.setRequestMethod(method.getMethod());
            conn.setRequestProperty("Content-type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + DiscordLinker.getConnJson().get("hash").getAsString());
            conn.setFixedLengthStreamingMode(length);
            conn.setDoOutput(true);
            conn.connect();
            try (OutputStream os = conn.getOutputStream();){
                os.write(out);
            }
            int status = conn.getResponseCode();
            if (status == 403) {
                DiscordLinker.getPlugin().deleteConn();
            }
            InputStreamReader streamReader = new InputStreamReader(status > 299 ? conn.getErrorStream() : conn.getInputStream());
            return new Router.RouterResponse(Status.valueOf(status), new BufferedReader(streamReader).lines().collect(Collectors.joining("\n")));
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static void checkVersion() {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(AdapterManager.getBotURI() + "/version").openConnection();
            InputStream inputStream = conn.getInputStream();
            String latestVersion = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
            if (!latestVersion.equals(DiscordLinker.getPluginVersion())) {
                DiscordLinker.getPlugin().getLogger().info(ChatColor.AQUA + "Please update to the latest Discord-Linker version (" + latestVersion + ") for a bug-free and feature-rich experience.");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @Deprecated
    public void connect(int port, Consumer<Boolean> callback) {
    }

    private boolean checkToken(Request req) {
        try {
            if (DiscordLinker.getConnJson().get("hash") == null) {
                return false;
            }
            String token = req.getAuthorization().get(0).getData();
            String correctHash = DiscordLinker.getConnJson().get("hash").getAsString();
            return correctHash.equals(Router.createHash(token));
        }
        catch (NoSuchAlgorithmException err) {
            return false;
        }
    }

    private JsonObject parseRequest(Request req) {
        JsonObject data = new JsonObject();
        if (!req.getMethod().equals("GET") && !req.getMethod().equals("PUT")) {
            data = new JsonParser().parse((Reader)new InputStreamReader(req.getBody())).getAsJsonObject();
        }
        req.getQuerys().forEach((arg_0, arg_1) -> ((JsonObject)data).addProperty(arg_0, arg_1));
        req.getParams().forEach((arg_0, arg_1) -> ((JsonObject)data).addProperty(arg_0, arg_1));
        return data;
    }

    @Override
    public void disconnect() {
        this.app.stop();
    }

    private boolean checkIp(String ip) {
        try {
            String correctIp = InetAddress.getByName(AdapterManager.getBotURI().getHost()).getHostAddress();
            return ip.equals(correctIp);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private void respond(Router.RouterResponse response, Response res) {
        res.setStatus(response.getStatus());
        if (response.isAttachment()) {
            res.sendAttachment(Paths.get(response.getMessage(), new String[0]));
        } else {
            res.send(response.getMessage());
        }
    }
}

