/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.network.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import express.utils.Status;
import io.socket.client.Ack;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.lianecx.discordlinker.DiscordLinker;
import me.lianecx.discordlinker.network.Route;
import me.lianecx.discordlinker.network.Router;
import me.lianecx.discordlinker.network.adapters.AdapterManager;
import me.lianecx.discordlinker.network.adapters.NetworkAdapter;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class WebSocketAdapter
implements NetworkAdapter {
    public static final int DEFAULT_RECONNECTION_ATTEMPTS = Integer.MAX_VALUE;
    private static final DiscordLinker PLUGIN = DiscordLinker.getPlugin();
    private final Socket socket;
    private final Dispatcher dispatcher = new Dispatcher();
    private final ExecutorService pool = this.dispatcher.executorService();

    public WebSocketAdapter(Map<String, String> auth) {
        this(auth, Integer.MAX_VALUE);
    }

    public WebSocketAdapter(Map<String, String> auth, int reconnectionAttempts) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().dispatcher(this.dispatcher).readTimeout(1L, TimeUnit.MINUTES).build();
        Set queries = Router.getConnectResponse().entrySet();
        String queryString = queries.stream().filter(e -> !((JsonElement)e.getValue()).isJsonNull()).map(e -> (String)e.getKey() + "=" + ((JsonElement)e.getValue()).getAsString()).collect(Collectors.joining("&"));
        IO.Options ioOptions = new IO.Options();
        ioOptions.callFactory = okHttpClient;
        ioOptions.webSocketFactory = okHttpClient;
        ioOptions.auth = auth;
        ioOptions.query = queryString;
        ioOptions.reconnectionDelayMax = 30000L;
        ioOptions.reconnectionAttempts = reconnectionAttempts;
        ioOptions.transports = new String[]{"websocket"};
        Socket socket = IO.socket(AdapterManager.getBotURI(), ioOptions);
        socket.on("connect_error", args -> PLUGIN.getLogger().info(ChatColor.RED + "Could not reach the Discord Bot! Reconnecting..."));
        socket.on("connect", args -> {
            PLUGIN.getLogger().info(ChatColor.GREEN + "Connected to the Discord Bot!");
            DiscordLinker.getAdapterManager().stopHttp();
        });
        socket.on("disconnect", args -> {
            if (args[0].equals("io server disconnect")) {
                PLUGIN.getLogger().info(ChatColor.RED + "Disconnected from the Discord Bot!");
                PLUGIN.deleteConn();
                DiscordLinker.getAdapterManager().startHttp();
            } else {
                PLUGIN.getLogger().info(ChatColor.RED + "Disconnected from the Discord Bot! Reconnecting...");
            }
        });
        socket.onAnyIncoming(args -> {
            Route route;
            String eventName = (String)args[0];
            JsonObject data = new JsonParser().parse(args[1].toString()).getAsJsonObject();
            Bukkit.getLogger().fine("[Socket.io] Event: " + eventName + ", Data: " + data.toString());
            AtomicReference<Object> ack = new AtomicReference<Object>(null);
            if (args[args.length - 1] instanceof Ack) {
                ack.set(((Ack)args[args.length - 1]));
            }
            if ((route = Route.getRouteByEventName(eventName)) == null) {
                if (ack.get() != null) {
                    ((Ack)ack.get()).call(this.jsonFromStatus(Status._404));
                }
                return;
            }
            if (route == Route.PUT_FILE) {
                Router.putFile(data, (InputStream)args[2], routerResponse -> {
                    Bukkit.getLogger().fine("[Socket.io] Event: " + eventName + ", Response: [" + (Object)((Object)routerResponse.getStatus()) + "] " + routerResponse.getMessage());
                    this.respond((Router.RouterResponse)routerResponse, (Ack)ack.get());
                });
            } else {
                route.execute(data, routerResponse -> {
                    Bukkit.getLogger().fine("[Socket.io] Event: " + eventName + ", Response: [" + (Object)((Object)routerResponse.getStatus()) + "] " + routerResponse.getMessage());
                    this.respond((Router.RouterResponse)routerResponse, (Ack)ack.get());
                });
            }
        });
        this.socket = socket;
    }

    public void setReconnectionAttempts(int reconnectionAttempts) {
        this.socket.io().reconnectionAttempts(reconnectionAttempts);
    }

    @Override
    public void connect(int httpPort, final Consumer<Boolean> callback) {
        final AtomicReference<1> connectListener = new AtomicReference<1>();
        final AtomicReference<2> errorListener = new AtomicReference<2>();
        connectListener.set(new Emitter.Listener(){

            @Override
            public void call(Object ... args) {
                callback.accept(true);
                WebSocketAdapter.this.socket.off("connect", this);
                WebSocketAdapter.this.socket.off("disconnect", (Emitter.Listener)errorListener.get());
            }
        });
        errorListener.set(new Emitter.Listener(){

            @Override
            public void call(Object ... args) {
                callback.accept(false);
                WebSocketAdapter.this.socket.off("connect", (Emitter.Listener)connectListener.get());
                WebSocketAdapter.this.socket.off("disconnect", this);
            }
        });
        this.socket.on("connect", (Emitter.Listener)connectListener.get());
        this.socket.on("disconnect", (Emitter.Listener)errorListener.get());
        this.socket.connect();
    }

    @Override
    public void disconnect() {
        if (!this.socket.connected()) {
            return;
        }
        this.socket.disconnect();
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    Bukkit.getLogger().severe("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ex) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void send(String event, JsonElement data) {
        this.socket.emit(event, data);
    }

    public void send(String event, JsonElement data, Ack ack) {
        this.socket.emit(event, data, ack);
    }

    private JsonObject jsonFromStatus(Status status) {
        JsonObject json = new JsonObject();
        json.addProperty("status", (Number)status.getCode());
        return json;
    }

    private void respond(Router.RouterResponse response, Ack ack) {
        if (ack == null) {
            return;
        }
        if (response.isAttachment()) {
            String path = response.getMessage();
            try {
                byte[] file = Files.readAllBytes(Paths.get(path, new String[0]));
                ack.call(new Object[]{file});
            }
            catch (IOException err) {
                JsonObject error = this.jsonFromStatus(Status._500);
                error.addProperty("message", err.toString());
                ack.call(error);
            }
            return;
        }
        JsonObject json = this.jsonFromStatus(response.getStatus());
        if (response.getMessage() != null) {
            JsonElement data = new JsonParser().parse(response.getMessage());
            json.add("data", data);
        }
        ack.call(json);
    }
}

