/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class CommandUtil {
    public static Entity[] getTargets(CommandSender sender, String arg) {
        Entity[] ents;
        int C;
        String[] tags;
        Location loc = null;
        if (sender instanceof Player) {
            loc = ((Player)sender).getLocation();
        } else if (sender instanceof BlockCommandSender) {
            loc = ((BlockCommandSender)sender).getBlock().getLocation().add(0.5, 0.0, 0.5);
        } else if (sender instanceof CommandMinecart) {
            loc = ((CommandMinecart)sender).getLocation();
        }
        for (String string : tags = CommandUtil.getTags(arg)) {
            if (CommandUtil.hasTag(SelectorType.X, string)) {
                loc.setX((double)CommandUtil.getInt(string));
                continue;
            }
            if (CommandUtil.hasTag(SelectorType.Y, string)) {
                loc.setY((double)CommandUtil.getInt(string));
                continue;
            }
            if (!CommandUtil.hasTag(SelectorType.Z, string)) continue;
            loc.setZ((double)CommandUtil.getInt(string));
        }
        if (arg.startsWith("@s")) {
            Entity[] ents2 = new Entity[1];
            if (sender instanceof Player) {
                boolean good = true;
                for (int b = 0; b < tags.length; ++b) {
                    if (CommandUtil.canBeAccepted(tags[b], (Entity)sender, loc)) continue;
                    good = false;
                    break;
                }
                if (good) {
                    ents2[0] = (Entity)sender;
                }
            } else {
                return null;
            }
            return ents2;
        }
        if (arg.startsWith("@a")) {
            ArrayList<Entity> listOfValidEntities = new ArrayList<Entity>();
            C = CommandUtil.getLimit(arg);
            boolean usePlayers = true;
            for (String tag : tags) {
                if (!CommandUtil.hasTag(SelectorType.TYPE, tag)) continue;
                usePlayers = false;
                break;
            }
            ArrayList arrayList = new ArrayList(Bukkit.getOnlinePlayers());
            if (!usePlayers) {
                arrayList.clear();
                for (World w : CommandUtil.getAcceptedWorldsFullString(loc, arg)) {
                    arrayList.addAll(w.getEntities());
                }
            }
            for (Entity e : arrayList) {
                if (listOfValidEntities.size() >= C) break;
                boolean isValid = true;
                for (int b = 0; b < tags.length; ++b) {
                    if (CommandUtil.canBeAccepted(tags[b], e, loc)) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) continue;
                listOfValidEntities.add(e);
            }
            ents = listOfValidEntities.toArray(new Entity[listOfValidEntities.size()]);
        } else if (arg.startsWith("@p")) {
            ents = new Entity[1];
            double closestInt = Double.MAX_VALUE;
            Player closest = null;
            for (World w : CommandUtil.getAcceptedWorldsFullString(loc, arg)) {
                for (Player e : w.getPlayers()) {
                    double distance;
                    if (e == sender) continue;
                    Location temp = loc;
                    if (temp == null) {
                        temp = e.getWorld().getSpawnLocation();
                    }
                    if (!(closestInt > (distance = e.getLocation().distanceSquared(temp)))) continue;
                    boolean good = true;
                    for (String tag : tags) {
                        if (CommandUtil.canBeAccepted(tag, (Entity)e, temp)) continue;
                        good = false;
                        break;
                    }
                    if (!good) continue;
                    closestInt = distance;
                    closest = e;
                }
            }
            ents[0] = closest;
        } else if (arg.startsWith("@e")) {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            C = CommandUtil.getLimit(arg);
            block9: for (World world : CommandUtil.getAcceptedWorldsFullString(loc, arg)) {
                for (Entity e : world.getEntities()) {
                    if (entities.size() > C) continue block9;
                    if (e == sender) continue;
                    boolean valid = true;
                    for (String tag : tags) {
                        if (CommandUtil.canBeAccepted(tag, e, loc)) continue;
                        valid = false;
                        break;
                    }
                    if (!valid) continue;
                    entities.add(e);
                }
            }
            ents = entities.toArray(new Entity[entities.size()]);
        } else if (arg.startsWith("@r")) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            ents = new Entity[1];
            ArrayList<Entity> validEntities = new ArrayList<Entity>();
            for (World world : CommandUtil.getAcceptedWorldsFullString(loc, arg)) {
                boolean good;
                if (CommandUtil.hasTag(SelectorType.TYPE, arg)) {
                    for (Entity e : world.getEntities()) {
                        good = true;
                        for (String tag : tags) {
                            if (CommandUtil.canBeAccepted(tag, e, loc)) continue;
                            good = false;
                            break;
                        }
                        if (!good) continue;
                        validEntities.add(e);
                    }
                    continue;
                }
                for (Entity e : Bukkit.getOnlinePlayers()) {
                    good = true;
                    for (String tag : tags) {
                        if (CommandUtil.canBeAccepted(tag, e, loc)) continue;
                        good = false;
                        break;
                    }
                    if (!good) continue;
                    validEntities.add(e);
                }
            }
            ents[0] = (Entity)validEntities.get(((Random)r).nextInt(validEntities.size()));
        } else {
            ents = new Entity[]{Bukkit.getPlayer((String)arg)};
        }
        return ents;
    }

    public static Entity getTarget(CommandSender sender, String arg) {
        Entity[] e = CommandUtil.getTargets(sender, arg);
        if (e.length == 0) {
            return null;
        }
        return e[0];
    }

    public static int getIntRelative(String arg, String rel, Entity e) {
        int relInt = 0;
        if (arg.startsWith("~")) {
            switch (rel.toLowerCase()) {
                case "x": {
                    relInt = e.getLocation().getBlockX();
                    break;
                }
                case "y": {
                    relInt = e.getLocation().getBlockY();
                    break;
                }
                case "z": {
                    relInt = e.getLocation().getBlockZ();
                }
            }
            return CommandUtil.mathIt(arg, relInt);
        }
        if (arg.startsWith("^")) {
            switch (rel.toLowerCase()) {
                case "x": {
                    relInt = e.getLocation().getBlockX();
                    break;
                }
                case "y": {
                    relInt = e.getLocation().getBlockY();
                    break;
                }
                case "z": {
                    relInt = e.getLocation().getBlockZ();
                }
            }
            return CommandUtil.mathIt(arg, relInt);
        }
        return 0;
    }

    private static boolean canBeAccepted(String arg, Entity e, Location loc) {
        if (CommandUtil.hasTag(SelectorType.X_ROTATION, arg) && CommandUtil.isWithinYaw(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.Y_ROTATION, arg) && CommandUtil.isWithinPitch(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.TYPE, arg) && CommandUtil.isType(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.NAME, arg) && CommandUtil.isName(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.TEAM, arg) && CommandUtil.isTeam(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.SCORE_FULL, arg) && CommandUtil.isScore(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.SCORE_MIN, arg) && CommandUtil.isScoreMin(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.SCORE_13, arg) && CommandUtil.isScoreWithin(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.DISTANCE, arg) && CommandUtil.isWithinDistance(arg, loc, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.LEVEL, arg) && CommandUtil.isWithinLevel(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.TAG, arg) && CommandUtil.isHasTags(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.RYM, arg) && CommandUtil.isRYM(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.RXM, arg) && CommandUtil.isRXM(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.HM, arg) && CommandUtil.isHM(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.RY, arg) && CommandUtil.isRY(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.RX, arg) && CommandUtil.isRX(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.RM, arg) && CommandUtil.isRM(arg, loc, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.LMax, arg) && CommandUtil.isLM(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.L, arg) && CommandUtil.isL(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.m, arg) && CommandUtil.isM(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.H, arg) && CommandUtil.isH(arg, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.World, arg) && CommandUtil.isW(arg, loc, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.R, arg) && CommandUtil.isR(arg, loc, e)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.X, arg)) {
            return true;
        }
        if (CommandUtil.hasTag(SelectorType.Y, arg)) {
            return true;
        }
        return CommandUtil.hasTag(SelectorType.Z, arg);
    }

    private static String[] getTags(String arg) {
        if (!arg.contains("[")) {
            return new String[0];
        }
        String tags = arg.split("\\[")[1].split("\\]")[0];
        return tags.split(",");
    }

    private static int mathIt(String args, int relInt) {
        int total = 0;
        int mode = 0;
        String arg = args.replace("~", String.valueOf(relInt));
        String intString = "";
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == '+' || arg.charAt(i) == '-' || arg.charAt(i) == '*' || arg.charAt(i) == '/') {
                try {
                    switch (mode) {
                        case 0: {
                            total += Integer.parseInt(intString);
                            break;
                        }
                        case 1: {
                            total -= Integer.parseInt(intString);
                            break;
                        }
                        case 2: {
                            total *= Integer.parseInt(intString);
                            break;
                        }
                        case 3: {
                            total /= Integer.parseInt(intString);
                        }
                    }
                    mode = (short)(arg.charAt(i) == '+' ? 0 : (arg.charAt(i) == '-' ? 1 : (arg.charAt(i) == '*' ? 2 : (arg.charAt(i) == '/' ? 3 : -1))));
                }
                catch (Exception e) {
                    Bukkit.getLogger().severe("There has been an issue with a plugin using the CommandUtil class!");
                }
                continue;
            }
            if (args.length() == i || arg.charAt(i) == ' ' || arg.charAt(i) == ',' || arg.charAt(i) == ']') {
                try {
                    switch (mode) {
                        case 0: {
                            total += Integer.parseInt(intString);
                            break;
                        }
                        case 1: {
                            total -= Integer.parseInt(intString);
                            break;
                        }
                        case 2: {
                            total *= Integer.parseInt(intString);
                            break;
                        }
                        case 3: {
                            total /= Integer.parseInt(intString);
                        }
                    }
                }
                catch (Exception e) {
                    Bukkit.getLogger().severe("There has been an issue with a plugin using the CommandUtil class!");
                }
                break;
            }
            intString = intString + arg.charAt(i);
        }
        return total;
    }

    private static int getLimit(String arg) {
        if (CommandUtil.hasTag(SelectorType.LIMIT, arg)) {
            for (String s : CommandUtil.getTags(arg)) {
                if (!CommandUtil.hasTag(SelectorType.LIMIT, s)) continue;
                return CommandUtil.getInt(s);
            }
        }
        if (CommandUtil.hasTag(SelectorType.C, arg)) {
            for (String s : CommandUtil.getTags(arg)) {
                if (!CommandUtil.hasTag(SelectorType.C, s)) continue;
                return CommandUtil.getInt(s);
            }
        }
        return Integer.MAX_VALUE;
    }

    private static String getType(String arg) {
        if (CommandUtil.hasTag(SelectorType.TYPE, arg)) {
            return arg.toLowerCase().split("=")[1].replace("!", "");
        }
        return "Player";
    }

    private static String getName(String arg) {
        String reparg = arg.replace(" ", "_");
        return reparg.replace("!", "").split("=")[1];
    }

    private static World getW(String arg) {
        return Bukkit.getWorld((String)CommandUtil.getString(arg));
    }

    private static String getScoreMinName(String arg) {
        return arg.split("=")[0].substring(0, arg.split("=")[0].length() - 1 - 4).replace("score_", "");
    }

    private static String getScoreName(String arg) {
        return arg.split("=")[0].replace("score_", "");
    }

    private static String getTeam(String arg) {
        return arg.toLowerCase().replace("!", "").split("=")[1];
    }

    private static float getValueAsFloat(String arg) {
        return Float.parseFloat(arg.replace("!", "").split("=")[1]);
    }

    private static int getValueAsInteger(String arg) {
        return Integer.parseInt(arg.replace("!", "").split("=")[1]);
    }

    private static GameMode getM(String arg) {
        String[] split = arg.replace("!", "").toLowerCase().split("=");
        String returnType = split[1];
        if (returnType.equalsIgnoreCase("0") || returnType.equalsIgnoreCase("s") || returnType.equalsIgnoreCase("survival")) {
            return GameMode.SURVIVAL;
        }
        if (returnType.equalsIgnoreCase("1") || returnType.equalsIgnoreCase("c") || returnType.equalsIgnoreCase("creative")) {
            return GameMode.CREATIVE;
        }
        if (returnType.equalsIgnoreCase("2") || returnType.equalsIgnoreCase("a") || returnType.equalsIgnoreCase("adventure")) {
            return GameMode.ADVENTURE;
        }
        if (returnType.equalsIgnoreCase("3") || returnType.equalsIgnoreCase("sp") || returnType.equalsIgnoreCase("spectator")) {
            return GameMode.SPECTATOR;
        }
        return null;
    }

    private static List<World> getAcceptedWorldsFullString(Location loc, String fullString) {
        String string = null;
        for (String tag : CommandUtil.getTags(fullString)) {
            if (!CommandUtil.hasTag(SelectorType.World, tag)) continue;
            string = tag;
            break;
        }
        if (string == null) {
            ArrayList<World> worlds = new ArrayList<World>();
            if (loc == null || loc.getWorld() == null) {
                worlds.addAll(Bukkit.getWorlds());
            } else {
                worlds.add(loc.getWorld());
            }
            return worlds;
        }
        return CommandUtil.getAcceptedWorlds(string);
    }

    private static List<World> getAcceptedWorlds(String string) {
        ArrayList<World> worlds = new ArrayList<World>(Bukkit.getWorlds());
        if (CommandUtil.isInverted(string)) {
            worlds.remove(CommandUtil.getW(string));
        } else {
            worlds.clear();
            worlds.add(CommandUtil.getW(string));
        }
        return worlds;
    }

    private static boolean isTeam(String arg, Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        for (Team t : Bukkit.getScoreboardManager().getMainScoreboard().getTeams()) {
            if (t.getName().equalsIgnoreCase(CommandUtil.getTeam(arg)) == CommandUtil.isInverted(arg) || t.getEntries().contains(((Player)e).getName()) == CommandUtil.isInverted(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWithinPitch(String arg, Entity e) {
        float pitch = CommandUtil.getValueAsFloat(arg);
        return CommandUtil.isWithinDoubleValue(CommandUtil.isInverted(arg), arg, e.getLocation().getPitch());
    }

    private static boolean isWithinYaw(String arg, Entity e) {
        float pitch = CommandUtil.getValueAsFloat(arg);
        return CommandUtil.isWithinDoubleValue(CommandUtil.isInverted(arg), arg, e.getLocation().getYaw());
    }

    private static boolean isWithinDistance(String arg, Location start, Entity e) {
        double distanceMin = 0.0;
        double distanceMax = Double.MAX_VALUE;
        String distance = arg.split("=")[1];
        if (e.getLocation().getWorld() != start.getWorld()) {
            return false;
        }
        if (distance.contains("..")) {
            double actDis;
            String[] temp = distance.split("\\.\\.");
            if (!temp[0].isEmpty()) {
                distanceMin = Integer.parseInt(temp[0]);
            }
            if (temp.length > 1 && !temp[1].isEmpty()) {
                distanceMax = Double.parseDouble(temp[1]);
            }
            return (actDis = start.distanceSquared(e.getLocation())) <= distanceMax * distanceMax && distanceMin * distanceMin <= actDis;
        }
        int mult = Integer.parseInt(distance);
        mult *= mult;
        return (int)start.distanceSquared(e.getLocation()) == mult;
    }

    private static boolean isWithinLevel(String arg, Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        double distanceMin = 0.0;
        double distanceMax = Double.MAX_VALUE;
        String distance = arg.split("=")[1];
        if (distance.contains("..")) {
            double actDis;
            String[] temp = distance.split("..");
            if (!temp[0].isEmpty()) {
                distanceMin = Integer.parseInt(temp[0]);
            }
            if (temp[1] != null && !temp[1].isEmpty()) {
                distanceMax = Double.parseDouble(temp[1]);
            }
            return (actDis = (double)((Player)e).getExpToLevel()) <= distanceMax * distanceMax && distanceMin * distanceMin <= actDis;
        }
        return ((Player)e).getExpToLevel() == Integer.parseInt(distance);
    }

    private static boolean isScore(String arg, Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        for (Objective o : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
            if (!o.getName().equalsIgnoreCase(CommandUtil.getScoreName(arg)) || o.getScore(((Player)e).getName()).getScore() <= CommandUtil.getValueAsInteger(arg) == CommandUtil.isInverted(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isScoreWithin(String arg, Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        String[] scores = arg.split("\\{")[1].split("\\}")[0].split(",");
        for (int i = 0; i < scores.length; ++i) {
            String[] s = scores[i].split("=");
            String name = s[0];
            for (Objective o : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
                if (!o.getName().equalsIgnoreCase(name) || CommandUtil.isWithinDoubleValue(CommandUtil.isInverted(arg), s[1], o.getScore(e.getName()).getScore())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isHasTags(String arg, Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        return CommandUtil.isInverted(arg) != e.getScoreboardTags().contains(CommandUtil.getString(arg));
    }

    private static boolean isScoreMin(String arg, Entity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        for (Objective o : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
            if (!o.getName().equalsIgnoreCase(CommandUtil.getScoreMinName(arg)) || o.getScore(((Player)e).getName()).getScore() >= CommandUtil.getValueAsInteger(arg) == CommandUtil.isInverted(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRM(String arg, Location loc, Entity e) {
        if (loc.getWorld() != e.getWorld()) {
            return false;
        }
        return CommandUtil.isGreaterThan(arg, loc.distance(e.getLocation()));
    }

    private static boolean isR(String arg, Location loc, Entity e) {
        if (loc.getWorld() != e.getWorld()) {
            return false;
        }
        return CommandUtil.isLessThan(arg, loc.distance(e.getLocation()));
    }

    private static boolean isRXM(String arg, Entity e) {
        return CommandUtil.isLessThan(arg, e.getLocation().getYaw());
    }

    private static boolean isRX(String arg, Entity e) {
        return CommandUtil.isGreaterThan(arg, e.getLocation().getYaw());
    }

    private static boolean isRYM(String arg, Entity e) {
        return CommandUtil.isLessThan(arg, e.getLocation().getPitch());
    }

    private static boolean isRY(String arg, Entity e) {
        return CommandUtil.isGreaterThan(arg, e.getLocation().getPitch());
    }

    private static boolean isL(String arg, Entity e) {
        if (e instanceof Player) {
            CommandUtil.isLessThan(arg, ((Player)e).getTotalExperience());
        }
        return false;
    }

    private static boolean isLM(String arg, Entity e) {
        if (e instanceof Player) {
            return CommandUtil.isGreaterThan(arg, ((Player)e).getTotalExperience());
        }
        return false;
    }

    private static boolean isH(String arg, Entity e) {
        if (e instanceof Damageable) {
            return CommandUtil.isGreaterThan(arg, ((Damageable)e).getHealth());
        }
        return false;
    }

    private static boolean isHM(String arg, Entity e) {
        if (e instanceof Damageable) {
            return CommandUtil.isLessThan(arg, ((Damageable)e).getHealth());
        }
        return false;
    }

    private static boolean isM(String arg, Entity e) {
        if (CommandUtil.getM(arg) == null) {
            return true;
        }
        return e instanceof HumanEntity && CommandUtil.isInverted(arg) != (CommandUtil.getM(arg) == ((HumanEntity)e).getGameMode());
    }

    private static boolean isW(String arg, Location loc, Entity e) {
        if (CommandUtil.getW(arg) == null) {
            return true;
        }
        return CommandUtil.isInverted(arg) != CommandUtil.getAcceptedWorlds(arg).contains(CommandUtil.getW(arg));
    }

    private static boolean isName(String arg, Entity e) {
        if (CommandUtil.getName(arg) == null) {
            return true;
        }
        return CommandUtil.isInverted(arg) != (e.getCustomName() != null) && CommandUtil.isInverted(arg) != (CommandUtil.getName(arg).equals(e.getCustomName().replace(" ", "_")) || e instanceof Player && ((Player)e).getName().replace(" ", "_").equalsIgnoreCase(CommandUtil.getName(arg)));
    }

    private static boolean isType(String arg, Entity e) {
        boolean invert = CommandUtil.isInverted(arg);
        String type = CommandUtil.getType(arg);
        return invert != e.getType().name().equalsIgnoreCase(type);
    }

    private static boolean isInverted(String arg) {
        return arg.toLowerCase().split("!").length != 1;
    }

    private static int getInt(String arg) {
        int mult = Integer.parseInt(arg.split("=")[1]);
        return mult;
    }

    public static String getString(String arg) {
        return arg.split("=")[1].replaceAll("!", "");
    }

    private static boolean isLessThan(String arg, double value) {
        boolean inverted = CommandUtil.isInverted(arg);
        double mult = Double.parseDouble(arg.split("=")[1]);
        return value < mult != inverted;
    }

    private static boolean isGreaterThan(String arg, double value) {
        boolean inverted = CommandUtil.isInverted(arg);
        double mult = Double.parseDouble(arg.split("=")[1]);
        return value > mult != inverted;
    }

    private static boolean isWithinDoubleValue(boolean inverted, String arg, double value) {
        double min = -1.7976931348623157E308;
        double max = Double.MAX_VALUE;
        if (arg.contains("..")) {
            String[] temp = arg.split("\\.\\.");
            if (!temp[0].isEmpty()) {
                min = Integer.parseInt(temp[0]);
            }
            if (temp.length > 1 && !temp[1].isEmpty()) {
                max = Double.parseDouble(temp[1]);
            }
            return (value <= max * max && min * min <= value) != inverted;
        }
        double mult = Double.parseDouble(arg);
        return value == mult != inverted;
    }

    private static boolean hasTag(SelectorType type, String arg) {
        return arg.toLowerCase().startsWith(type.getName());
    }

    static enum SelectorType {
        LEVEL("level="),
        DISTANCE("distance="),
        TYPE("type="),
        NAME("name="),
        TEAM("team="),
        LMax("lm="),
        L("l="),
        World("w="),
        m("m="),
        C("c="),
        HM("hm="),
        H("h="),
        RM("rm="),
        RYM("rym="),
        RX("rx="),
        SCORE_FULL("score="),
        SCORE_MIN("score_min"),
        SCORE_13("scores="),
        R("r="),
        RXM("rxm="),
        RY("ry="),
        TAG("tag="),
        X("x="),
        Y("y="),
        Z("z="),
        LIMIT("limit="),
        Y_ROTATION("y_rotation"),
        X_ROTATION("x_rotation");

        String name;

        private SelectorType(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }
    }
}

