/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.utilities;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Log4JAppender", category="Core", elementType="appender", printObject=true)
public class ConsoleLogger
extends AbstractAppender {
    private final List<String> loggedData = new ArrayList<String>();
    private boolean isLogging = false;

    public ConsoleLogger() {
        super("Discord-Linker", null, PatternLayout.newBuilder().withPattern("[%d{HH:mm:ss} %level]: %msg").build(), true, null);
    }

    public void startLogging() {
        this.isLogging = true;
    }

    public void stopLogging() {
        this.isLogging = false;
    }

    public void clearData() {
        this.loggedData.clear();
    }

    public List<String> getData() {
        return new ArrayList<String>(this.loggedData);
    }

    public void log(String message) {
        if (this.isLogging) {
            this.loggedData.add(message);
        }
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public void append(LogEvent event) {
        this.log(event.getMessage().getFormattedMessage());
    }
}

