/*
 * Decompiled with CFR 0.152.
 */
package me.lianecx.discordlinker.utilities;

import express.utils.Status;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.lianecx.discordlinker.DiscordLinker;
import me.lianecx.discordlinker.events.luckperms.DeleteGroupEvent;
import me.lianecx.discordlinker.events.luckperms.GroupMemberChangeEvent;
import me.lianecx.discordlinker.network.Router;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.event.group.GroupDeleteEvent;
import net.luckperms.api.event.node.NodeMutateEvent;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.matcher.NodeMatcher;
import net.luckperms.api.node.types.InheritanceNode;

public class LuckPermsUtil {
    public static final LuckPerms LUCK_PERMS = LuckPermsProvider.get();

    public static void init() {
        LUCK_PERMS.getEventBus().subscribe(NodeMutateEvent.class, GroupMemberChangeEvent::onNodeMutate);
        LUCK_PERMS.getEventBus().subscribe(GroupDeleteEvent.class, DeleteGroupEvent::onGroupDelete);
    }

    public static List<String> getGroupNames() {
        return LUCK_PERMS.getGroupManager().getLoadedGroups().stream().map(Group::getName).collect(Collectors.toList());
    }

    public static void updateGroupMembers(String name, List<String> uuids, boolean onlyAddMembers, Consumer<Router.RouterResponse> callback) {
        try {
            Group group = LUCK_PERMS.getGroupManager().getGroup(name);
            if (group == null) {
                callback.accept(new Router.RouterResponse(Status._404, Router.INVALID_GROUP.toString()));
                return;
            }
            NodeMatcher matcher = NodeMatcher.key((Node)InheritanceNode.builder((Group)group).build());
            LUCK_PERMS.getUserManager().searchAll(matcher).thenAccept(map -> {
                ArrayList playersToAdd = new ArrayList();
                if (!onlyAddMembers) {
                    map.keySet().forEach(uuid -> {
                        if (uuids.contains(uuid.toString())) {
                            return;
                        }
                        LUCK_PERMS.getUserManager().loadUser(uuid).thenAcceptAsync(user -> {
                            if (user == null) {
                                return;
                            }
                            user.data().remove((Node)InheritanceNode.builder((Group)group).build());
                            LUCK_PERMS.getUserManager().saveUser(user);
                        });
                    });
                }
                uuids.forEach(uuid -> {
                    UUID uuidObj = UUID.fromString(uuid);
                    if (map.containsKey(uuidObj)) {
                        return;
                    }
                    playersToAdd.add(uuid);
                });
                HashSet allPlayers = new HashSet(playersToAdd);
                if (onlyAddMembers) {
                    LuckPermsUtil.getGroupMembers(name, players -> {
                        allPlayers.addAll(players);
                        callback.accept(new Router.RouterResponse(Status._200, DiscordLinker.getGson().toJson((Object)allPlayers)));
                    });
                } else {
                    callback.accept(new Router.RouterResponse(Status._200, DiscordLinker.getGson().toJson((Object)uuids)));
                }
                playersToAdd.forEach(uuid -> LUCK_PERMS.getUserManager().loadUser(UUID.fromString(uuid)).thenAcceptAsync(user -> {
                    if (user == null) {
                        return;
                    }
                    user.data().add((Node)InheritanceNode.builder((Group)group).build());
                    LUCK_PERMS.getUserManager().saveUser(user);
                }));
            });
        }
        catch (Exception err) {
            callback.accept(new Router.RouterResponse(Status._501, Router.LUCKPERMS_NOT_LOADED.toString()));
        }
    }

    public static void getGroupMembers(String name, Consumer<List<String>> callback) {
        Group group = LUCK_PERMS.getGroupManager().getGroup(name);
        if (group == null) {
            callback.accept(null);
            return;
        }
        ArrayList players = new ArrayList();
        NodeMatcher matcher = NodeMatcher.key((Node)InheritanceNode.builder((Group)group).build());
        LUCK_PERMS.getUserManager().searchAll(matcher).thenAcceptAsync(users -> {
            players.addAll(users.keySet());
            callback.accept(players.stream().map(UUID::toString).collect(Collectors.toList()));
        });
    }

    public static void removeGroupFromUser(UUID uuid, String name) {
        LUCK_PERMS.getUserManager().loadUser(uuid).thenAcceptAsync(user -> {
            if (user == null) {
                return;
            }
            user.data().remove((Node)InheritanceNode.builder((String)name).build());
            LUCK_PERMS.getUserManager().saveUser(user);
        });
    }

    public static void addGroupToUser(UUID uuid, String name) {
        LUCK_PERMS.getUserManager().loadUser(uuid).thenAcceptAsync(user -> {
            if (user == null) {
                return;
            }
            user.data().add((Node)InheritanceNode.builder((String)name).build());
            LUCK_PERMS.getUserManager().saveUser(user);
        });
    }

    public static void updateUserGroup(String name, UUID uuid, String addOrRemove, Consumer<Router.RouterResponse> callback) {
        Group group = LUCK_PERMS.getGroupManager().getGroup(name);
        if (group == null) {
            callback.accept(new Router.RouterResponse(Status._404, Router.INVALID_GROUP.toString()));
            return;
        }
        LUCK_PERMS.getUserManager().loadUser(uuid).thenAcceptAsync(user -> {
            if (user == null) {
                callback.accept(new Router.RouterResponse(Status._404, Router.INVALID_PLAYER.toString()));
                return;
            }
            if (addOrRemove.equals("add")) {
                user.data().add((Node)InheritanceNode.builder((Group)group).build());
            } else if (addOrRemove.equals("remove")) {
                user.data().remove((Node)InheritanceNode.builder((Group)group).build());
            }
            LUCK_PERMS.getUserManager().saveUser(user);
            callback.accept(new Router.RouterResponse(Status._200, Router.SUCCESS.toString()));
        });
    }
}

