/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements PehkuiEntityExtensions {
    @Shadow
    boolean onGround;
    @Shadow
    boolean firstTick;
    private boolean pehkui_shouldSyncScales = false;
    private boolean pehkui_shouldIgnoreScaleNbt = false;
    private ScaleData[] pehkui_scaleCache = null;

    @Override
    public ScaleData pehkui_constructScaleData(ScaleType type) {
        return ScaleData.Builder.create().type(type).entity((Entity)this).build();
    }

    @Override
    public ScaleData[] pehkui_getScaleCache() {
        return this.pehkui_scaleCache;
    }

    @Override
    public void pehkui_setScaleCache(ScaleData[] scaleCache) {
        this.pehkui_scaleCache = scaleCache;
    }

    @Override
    public void pehkui_setShouldSyncScales(boolean sync) {
        this.pehkui_shouldSyncScales = sync;
    }

    @Override
    public boolean pehkui_shouldSyncScales() {
        return this.pehkui_shouldSyncScales;
    }

    @Override
    public boolean pehkui_shouldIgnoreScaleNbt() {
        return this.pehkui_shouldIgnoreScaleNbt;
    }

    @Override
    public void pehkui_setShouldIgnoreScaleNbt(boolean ignore) {
        this.pehkui_shouldIgnoreScaleNbt = ignore;
    }

    @Inject(at={@At(value="HEAD")}, method={"load(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void pehkui$readNbt(CompoundTag tag, CallbackInfo info) {
        this.pehkui_readScaleNbt(tag);
    }

    @Override
    public void pehkui_readScaleNbt(CompoundTag nbt) {
        if (this.pehkui_shouldIgnoreScaleNbt()) {
            return;
        }
        if (nbt.contains("pehkui:scale_data_types", 10) && !DebugCommand.unmarkEntityForScaleReset((Entity)this, nbt)) {
            CompoundTag typeData = nbt.getCompound("pehkui:scale_data_types");
            for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
                String key = ((ResourceLocation)entry.getKey()).toString();
                if (!typeData.contains(key, 10)) continue;
                ScaleData scaleData = this.pehkui_getScaleData((ScaleType)entry.getValue());
                scaleData.readNbt(typeData.getCompound(key));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"saveWithoutId(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"})
    private void pehkui$writeNbt(CompoundTag tag, CallbackInfoReturnable<CompoundTag> info) {
        this.pehkui_writeScaleNbt(tag);
    }

    @Override
    public CompoundTag pehkui_writeScaleNbt(CompoundTag nbt) {
        if (this.pehkui_shouldIgnoreScaleNbt()) {
            return nbt;
        }
        CompoundTag typeData = new CompoundTag();
        for (ScaleData scaleData : this.pehkui_getScales().values()) {
            CompoundTag compound;
            if (scaleData == null || (compound = scaleData.writeNbt(new CompoundTag())).size() == 0) continue;
            typeData.put(ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, scaleData.getScaleType()).toString(), (Tag)compound);
        }
        if (typeData.size() > 0) {
            nbt.put("pehkui:scale_data_types", (Tag)typeData);
        }
        return nbt;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void pehkui$tick(CallbackInfo info) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleUtils.tickScale(this.pehkui_getScaleData(type));
        }
    }

    @ModifyReturnValue(method={"getDimensions(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/entity/EntityDimensions;"}, at={@At(value="RETURN")})
    private EntityDimensions pehkui$getDimensions(EntityDimensions original) {
        float widthScale = ScaleUtils.getBoundingBoxWidthScale((Entity)this);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale((Entity)this);
        if (widthScale != 1.0f || heightScale != 1.0f) {
            return original.scale(widthScale, heightScale);
        }
        return original;
    }

    @Inject(at={@At(value="HEAD")}, method={"startSeenByPlayer(Lnet/minecraft/server/level/ServerPlayer;)V"})
    private void pehkui$onStartedTrackingBy(ServerPlayer player, CallbackInfo info) {
        ScaleUtils.syncScalesOnTrackingStart((Entity)this, player.connection);
    }

    @ModifyVariable(method={"spawnAtLocation(Lnet/minecraft/world/item/ItemStack;F)Lnet/minecraft/world/entity/item/ItemEntity;"}, at=@At(value="STORE"))
    private ItemEntity pehkui$dropStack(ItemEntity entity) {
        ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
        return entity;
    }

    @ModifyExpressionValue(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="CONSTANT", args={"doubleValue=1.0E-7D"})})
    private double pehkui$move$minVelocity(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale < 1.0f ? (double)(scale * scale) * value : value;
    }

    @ModifyArg(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;maybeBackOffFromEdge(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/MoverType;)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 pehkui$move$adjustMovementForSneaking(Vec3 movement, MoverType type) {
        if (type == MoverType.SELF || type == MoverType.PLAYER) {
            return movement.scale((double)ScaleUtils.getMotionScale((Entity)this));
        }
        return movement;
    }

    @WrapOperation(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/entity/Entity;push(DDD)V")})
    private void pehkui$pushSelfAwayFrom$other(Entity obj, double x, double y, double z, Operation<Void> original, @Local(argsOnly=true) Entity other) {
        float otherScale = ScaleUtils.getMotionScale(other);
        if (otherScale != 1.0f) {
            x *= (double)otherScale;
            z *= (double)otherScale;
        }
        original.call(new Object[]{obj, x, y, z});
    }

    @WrapOperation(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/entity/Entity;push(DDD)V")})
    private void pehkui$pushSelfAwayFrom$self(Entity obj, double x, double y, double z, Operation<Void> original) {
        float ownScale = ScaleUtils.getMotionScale((Entity)this);
        if (ownScale != 1.0f) {
            x *= (double)ownScale;
            z *= (double)ownScale;
        }
        original.call(new Object[]{obj, x, y, z});
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnSprintParticle()V"}, cancellable=true)
    private void pehkui$spawnSprintingParticles(CallbackInfo info) {
        if (ScaleUtils.getMotionScale((Entity)this) < 1.0f) {
            info.cancel();
        }
    }

    @Override
    public boolean pehkui_isFirstUpdate() {
        return this.firstTick;
    }

    @Override
    public boolean pehkui_getOnGround() {
        return this.onGround;
    }

    @Override
    public void pehkui_setOnGround(boolean onGround) {
        this.onGround = onGround;
    }
}

