/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.pehkui.util.MulticonnectCompatibility;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"aiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(DDD)V", shift=At.Shift.AFTER)})
    private void pehkui$tickMovement$minVelocity(CallbackInfo info, @Local Vec3 velocity) {
        LivingEntity self = (LivingEntity)this;
        float scale = ScaleUtils.getMotionScale((Entity)self);
        if (scale < 1.0f) {
            double min = (double)scale * MulticonnectCompatibility.INSTANCE.getProtocolDependentValue(ver -> ver <= 47, 0.005, 0.003);
            double vX = velocity.x;
            double vY = velocity.y;
            double vZ = velocity.z;
            if (Math.abs(vX) < min) {
                vX = 0.0;
            }
            if (Math.abs(vY) < min) {
                vY = 0.0;
            }
            if (Math.abs(vZ) < min) {
                vZ = 0.0;
            }
            self.setDeltaMovement(vX, vY, vZ);
        }
    }

    @ModifyVariable(method={"getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at=@At(value="HEAD"), argsOnly=true)
    private float pehkui$applyArmorToDamage(float value, DamageSource source, float amount) {
        Entity attacker = source.getEntity();
        float attackScale = attacker == null ? 1.0f : ScaleUtils.getAttackScale(attacker);
        float defenseScale = ScaleUtils.getDefenseScale((Entity)this);
        if (attackScale != 1.0f || defenseScale != 1.0f) {
            value = attackScale * value / defenseScale;
        }
        return value;
    }

    @ModifyReturnValue(method={"getMaxHealth()F"}, at={@At(value="RETURN")})
    private float pehkui$getMaxHealth(float original) {
        float scale = ScaleUtils.getHealthScale((Entity)this);
        return scale != 1.0f ? original * scale : original;
    }

    @ModifyReturnValue(method={"getVisibilityPercent(Lnet/minecraft/world/entity/Entity;)D"}, at={@At(value="RETURN")})
    private double pehkui$getAttackDistanceScalingFactor(double original) {
        float scale = ScaleUtils.getVisibilityScale((Entity)this);
        return scale != 1.0f ? original * (double)scale : original;
    }

    @ModifyReturnValue(method={"handleOnClimbable(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")})
    private Vec3 pehkui$applyClimbingSpeed(Vec3 original) {
        LivingEntity self = (LivingEntity)this;
        if (!self.onClimbable()) {
            return original;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f) {
            AABB bounds = self.getBoundingBox();
            double halfUnscaledXLength = bounds.getXsize() / (double)width / 2.0;
            int minX = Mth.floor((double)(bounds.minX + halfUnscaledXLength));
            int maxX = Mth.floor((double)(bounds.maxX - halfUnscaledXLength));
            int minY = Mth.floor((double)bounds.minY);
            double halfUnscaledZLength = bounds.getZsize() / (double)width / 2.0;
            int minZ = Mth.floor((double)(bounds.minZ + halfUnscaledZLength));
            int maxZ = Mth.floor((double)(bounds.maxZ - halfUnscaledZLength));
            Level world = self.getCommandSenderWorld();
            for (BlockPos pos : BlockPos.betweenClosed((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!world.getBlockState(pos).isScaffolding(self)) continue;
                return new Vec3(original.x, Math.max(self.getDeltaMovement().y, -0.15), original.z);
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"onClimbable()Z"}, at={@At(value="RETURN")})
    private boolean pehkui$isClimbing(boolean original) {
        LivingEntity self = (LivingEntity)this;
        if (original || self.isSpectator()) {
            return original;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f) {
            AABB bounds = self.getBoundingBox();
            double halfUnscaledXLength = bounds.getXsize() / (double)width / 2.0;
            int minX = Mth.floor((double)(bounds.minX + halfUnscaledXLength));
            int maxX = Mth.floor((double)(bounds.maxX - halfUnscaledXLength));
            int minY = Mth.floor((double)bounds.minY);
            double halfUnscaledZLength = bounds.getZsize() / (double)width / 2.0;
            int minZ = Mth.floor((double)(bounds.minZ + halfUnscaledZLength));
            int maxZ = Mth.floor((double)(bounds.maxZ - halfUnscaledZLength));
            Level world = self.getCommandSenderWorld();
            for (BlockPos pos : BlockPos.betweenClosed((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!world.getBlockState(pos).isLadder((LevelReader)world, pos, self)) continue;
                return true;
            }
        }
        return original;
    }

    @WrapOperation(method={"pushEntities()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getBoundingBox()Lnet/minecraft/world/phys/AABB;")})
    private AABB pehkui$tickCramming$getBoundingBox(LivingEntity obj, Operation<AABB> original) {
        AABB bounds = (AABB)original.call(new Object[]{obj});
        float interactionWidth = ScaleUtils.getInteractionBoxWidthScale((Entity)obj);
        float interactionHeight = ScaleUtils.getInteractionBoxHeightScale((Entity)obj);
        if (interactionWidth != 1.0f || interactionHeight != 1.0f) {
            double scaledXLength = bounds.getXsize() * 0.5 * (double)(interactionWidth - 1.0f);
            double scaledYLength = bounds.getYsize() * 0.5 * (double)(interactionHeight - 1.0f);
            double scaledZLength = bounds.getZsize() * 0.5 * (double)(interactionWidth - 1.0f);
            return bounds.inflate(scaledXLength, scaledYLength, scaledZLength);
        }
        return bounds;
    }
}

