/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin.reach.compat.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import virtuoel.pehkui.util.ReachEntityAttributesCompatibility;
import virtuoel.pehkui.util.ScaleRenderUtils;

@Mixin(value={GameRenderer.class}, priority=990)
public class GameRendererMixin {
    @Shadow
    @Final
    @Mutable
    Minecraft minecraft;

    @ModifyVariable(method={"pick(F)V"}, ordinal=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"))
    private double pehkui$updateCrosshairTarget$setDistance(double value, float tickDelta) {
        Entity entity = this.minecraft.getCameraEntity();
        if (entity != null && !ScaleRenderUtils.hasExtendedReach(this.minecraft.gameMode)) {
            double baseEntityReach = this.minecraft.gameMode.getPlayerMode().isCreative() ? 5.0 : 4.5;
            return ReachEntityAttributesCompatibility.INSTANCE.getAttackRange((LivingEntity)this.minecraft.player, baseEntityReach);
        }
        return value;
    }

    @ModifyVariable(method={"pick(F)V"}, ordinal=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;"))
    private double pehkui$updateCrosshairTarget$fixDistance(double value, float tickDelta) {
        Entity entity = this.minecraft.getCameraEntity();
        if (entity != null && ScaleRenderUtils.hasExtendedReach(this.minecraft.gameMode)) {
            return ReachEntityAttributesCompatibility.INSTANCE.getAttackRange((LivingEntity)this.minecraft.player, 6.0);
        }
        return value;
    }

    @ModifyVariable(method={"pick(F)V"}, ordinal=1, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;"))
    private double pehkui$updateCrosshairTarget$fixSquaredDistance(double value, float tickDelta) {
        Entity entity = this.minecraft.getCameraEntity();
        if (entity != null && (this.minecraft.hitResult == null || this.minecraft.hitResult.getType() == HitResult.Type.MISS)) {
            double baseEntityReach = ScaleRenderUtils.hasExtendedReach(this.minecraft.gameMode) ? 6.0 : (this.minecraft.gameMode.getPlayerMode().isCreative() ? 5.0 : 4.5);
            double entityReach = ReachEntityAttributesCompatibility.INSTANCE.getAttackRange((LivingEntity)this.minecraft.player, baseEntityReach);
            double entityReachSquared = entityReach * entityReach;
            return entityReachSquared;
        }
        return value;
    }
}

