/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.network.ScalePacket;

public class ScalePayload
extends ScalePacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ScalePayload> ID = new CustomPacketPayload.Type(Pehkui.SCALE_PACKET);
    public static final StreamCodec<FriendlyByteBuf, ScalePayload> CODEC = ScalePayload.codec(ID);

    public ScalePayload(Entity entity, Collection<ScaleData> scales) {
        super(entity, scales);
    }

    public ScalePayload(FriendlyByteBuf buf) {
        super(buf);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private static StreamCodec<FriendlyByteBuf, ScalePayload> codec(CustomPacketPayload.Type<ScalePayload> id) {
        return CustomPacketPayload.codec(ScalePacket::write, ScalePayload::new);
    }

    public static void handle(ScalePayload msg, IPayloadContext ctx) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Minecraft client = Minecraft.getInstance();
            Entity entity = client.level.getEntity(msg.entityId);
            if (entity != null) {
                msg.syncedScales.forEach((typeId, scaleData) -> {
                    if (ScaleRegistries.SCALE_TYPES.containsKey(typeId)) {
                        ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, typeId).getScaleData(entity).readNbt((CompoundTag)scaleData);
                    }
                });
            }
        }
    }
}

