/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLLoader;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.network.DebugPayload;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.NbtCompoundExtensions;

public class DebugCommand {
    private static final Collection<UUID> MARKED_UUIDS = new HashSet<UUID>();
    private static final Collection<String> MARKED_USERNAMES = new HashSet<String>();
    private static final List<EntityType<? extends Entity>> TYPES = Arrays.asList(EntityType.ZOMBIE, EntityType.CREEPER, EntityType.END_CRYSTAL, EntityType.BLAZE);

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"scale").requires(source -> source.hasPermission(2));
        if (!FMLLoader.isProduction() || ((Boolean)PehkuiConfig.COMMON.enableCommands.get()).booleanValue()) {
            builder.then(((LiteralArgumentBuilder)Commands.literal((String)"debug").then(((LiteralArgumentBuilder)Commands.literal((String)"delete_scale_data").then(Commands.literal((String)"uuid").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String uuidString = StringArgumentType.getString((CommandContext)context, (String)"uuid");
                try {
                    MARKED_UUIDS.add(UUID.fromString(uuidString));
                }
                catch (IllegalArgumentException e) {
                    ((CommandSourceStack)context.getSource()).sendFailure(I18nUtils.translate("commands.pehkui.debug.delete.uuid.invalid", "Invalid UUID \"%s\".", uuidString));
                    return 0;
                }
                return 1;
            })))).then(Commands.literal((String)"username").then(Commands.argument((String)"username", (ArgumentType)StringArgumentType.string()).executes(context -> {
                MARKED_USERNAMES.add(StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase(Locale.ROOT));
                return 1;
            }))))).then(Commands.literal((String)"garbage_collect").executes(context -> {
                ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket((CustomPacketPayload)new DebugPayload(PacketType.GARBAGE_COLLECT));
                ((CommandSourceStack)context.getSource()).getPlayer().connection.send((Packet)packet);
                System.gc();
                return 1;
            })));
        }
        if (!FMLLoader.isProduction() || ((Boolean)PehkuiConfig.COMMON.enableDebugCommands.get()).booleanValue()) {
            builder.then(((LiteralArgumentBuilder)Commands.literal((String)"debug").then(Commands.literal((String)"run_mixin_tests").executes(DebugCommand::runMixinTests))).then(Commands.literal((String)"run_tests").executes(DebugCommand::runTests)));
        }
        commandDispatcher.register(builder);
    }

    public static boolean unmarkEntityForScaleReset(Entity entity, CompoundTag nbt) {
        if (entity instanceof Player && MARKED_USERNAMES.remove(((Player)entity).getGameProfile().getName().toLowerCase(Locale.ROOT))) {
            return true;
        }
        NbtCompoundExtensions compound = (NbtCompoundExtensions)nbt;
        return compound.pehkui_containsUuid("UUID") && MARKED_UUIDS.remove(compound.pehkui_getUuid("UUID"));
    }

    private static int runTests(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntityOrException();
        Direction dir = entity.getDirection();
        Direction opposite = dir.getOpposite();
        Direction left = dir.getCounterClockWise();
        Direction right = dir.getClockWise();
        int distance = 4;
        int spacing = 2;
        int width = (TYPES.size() - 1) * (spacing + 1) + 1;
        Vec3 pos = entity.position();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos(pos.x, pos.y, pos.z).move(dir, distance).move(left, width / 2);
        Level w = entity.getCommandSenderWorld();
        for (EntityType<? extends Entity> t : TYPES) {
            w.setBlockAndUpdate((BlockPos)mut, Blocks.POLISHED_ANDESITE.defaultBlockState());
            Entity e = t.create(w);
            e.absMoveTo((double)mut.getX() + 0.5, (double)(mut.getY() + 1), (double)mut.getZ() + 0.5, opposite.toYRot(), 0.0f);
            e.moveTo((double)mut.getX() + 0.5, (double)(mut.getY() + 1), (double)mut.getZ() + 0.5, opposite.toYRot(), 0.0f);
            e.setYHeadRot(opposite.toYRot());
            e.addTag("pehkui");
            w.addFreshEntity(e);
            mut.move(right, spacing + 1);
        }
        int successes = -1;
        int total = -1;
        CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.test.success", "Tests succeeded: %d/%d", successes, total), false);
        return 1;
    }

    private static int runMixinTests(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity executor = ((CommandSourceStack)context.getSource()).getEntity();
        if (executor instanceof ServerPlayer) {
            ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket((CustomPacketPayload)new DebugPayload(PacketType.MIXIN_AUDIT));
            ((ServerPlayer)executor).connection.send((Packet)packet);
        }
        CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.audit.start", "Starting Mixin environment audit..."), false);
        MixinEnvironment.getCurrentEnvironment().audit();
        CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.audit.end", "Mixin environment audit complete!"), false);
        return 1;
    }

    public static enum PacketType {
        MIXIN_AUDIT,
        GARBAGE_COLLECT;

    }
}

