/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.KTurretsClient;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static boolean noDronesNearby;

    @SubscribeEvent
    public static void renderIndicators(RenderLivingEvent.Post<?, ?> event) {
        KTurretsClient.renderHealthAndAmmoIndicators(event.getPoseStack(), event.getEntity(), event.getMultiBufferSource(), event.getRenderer().getFont());
    }

    @SubscribeEvent
    public static void addInfo(ItemTooltipEvent event) {
        KTurretsClient.addInfo(event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent
    public static void showWarning(RenderGuiEvent.Post event) {
        if (noDronesNearby) {
            KTurretsClient.noDrones(event.getGuiGraphics());
        }
    }

    @SubscribeEvent
    public static void renderDroneLocations(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            noDronesNearby = KTurretsClient.renderDroneLocations(event.getPoseStack());
        }
    }
}

