/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.UnitLimits;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.registries.KTDataComponents;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;

public class ContainerItem
extends SpawnEggItem {
    public static final String UNIT_LIMITS = "k-turrets-unit-limits";
    private final Unit unit;

    public ContainerItem(EntityType<?> type, int backgroundColor, int highlightColor, Item.Properties props, Unit kind) {
        super(type, backgroundColor, highlightColor, props);
        this.unit = kind;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        UUID playerUUID = player.getUUID();
        if (dev.buildtool.satako.platform.Services.PLATFORM.isServer()) {
            ServerLevel serverLevel = (ServerLevel)level;
            UnitLimits unitLimits = (UnitLimits)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(UnitLimits::new, UnitLimits::load, null), UNIT_LIMITS);
            if (this.unit == Unit.TURRET) {
                if (unitLimits.getTurretCount(playerUUID) >= Services.PLATFORM.getTurretLimit()) {
                    player.displayClientMessage((Component)Component.translatable((String)"k_turrets.reached.turret.limit", (Object[])new Object[]{Services.PLATFORM.getTurretLimit()}), false);
                    return InteractionResult.CONSUME;
                }
                unitLimits.setTurretCount(playerUUID, unitLimits.getTurretCount(playerUUID) + 1);
                player.displayClientMessage((Component)Component.translatable((String)"k_turrets.turrets.remain", (Object[])new Object[]{Services.PLATFORM.getTurretLimit() - unitLimits.getTurretCount(playerUUID)}), false);
            } else if (this.unit == Unit.DRONE) {
                if (unitLimits.getDroneCount(playerUUID) >= Services.PLATFORM.getDroneLimit()) {
                    player.displayClientMessage((Component)Component.translatable((String)"k_turrets.reached.drone.limit", (Object[])new Object[]{Services.PLATFORM.getDroneLimit()}), false);
                    return InteractionResult.CONSUME;
                }
                unitLimits.setDroneCount(playerUUID, unitLimits.getDroneCount(playerUUID) + 1);
                player.displayClientMessage((Component)Component.translatable((String)"k_turrets.drones.remain", (Object[])new Object[]{Services.PLATFORM.getDroneLimit() - unitLimits.getDroneCount(playerUUID)}), false);
            }
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos blockpos1 = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        EntityType entitytype = this.getType(itemstack);
        Entity entity = entitytype.spawn((ServerLevel)level, itemstack, context.getPlayer(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (entity != null) {
            if (itemstack.has(KTDataComponents.ATTACHED_NBT)) {
                entity.load(((KTDataComponents.AttachedNBT)itemstack.get(KTDataComponents.ATTACHED_NBT)).compoundTag());
                entity.absMoveTo((double)blockpos1.getX() + 0.5, (double)(blockpos.getY() + 1), (double)blockpos.getZ() + 0.5);
            } else if (Services.PLATFORM.setOwnerAutomatically()) {
                Turret turret = (Turret)entity;
                turret.setOwner(playerUUID);
            }
            itemstack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        if (itemStack.has(KTDataComponents.ATTACHED_NBT)) {
            list.add((Component)Component.translatable((String)"k_turrets.deployed"));
        }
    }

    public static enum Unit {
        TURRET,
        DRONE;

    }
}

