/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.DroneMovementControl;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.registries.KTBlocks;
import dev.buildtool.kturrets.registries.KTItems;
import dev.buildtool.kturrets.tasks.AvoidAggressors;
import dev.buildtool.kturrets.tasks.FollowOwnerGoal;
import dev.buildtool.kturrets.tasks.GuardArea;
import dev.buildtool.kturrets.tasks.MoveOutOfLava;
import dev.buildtool.kturrets.tasks.StrafeAroundTarget;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public abstract class Drone
extends Turret {
    private static final EntityDataAccessor<BlockPos> GUARD_POSITION = SynchedEntityData.defineId(Drone.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final StreamCodec<ByteBuf, Behavior> STREAM_CODEC = ByteBufCodecs.idMapper(value -> Behavior.values()[value], Enum::ordinal);
    private static final EntityDataAccessor<Byte> BEHAVIOR = SynchedEntityData.defineId(Drone.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public BlockPos previousPosition = BlockPos.ZERO;
    public ItemContainer upgrades = Services.PLATFORM.createDroneUpgrades(this);

    public Drone(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new DroneMovementControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.entityData.set(MOVEABLE, (Object)true);
        this.entityData.set(REFILL_INVENTORY, (Object)false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public boolean causeFallDamage(float p_147105_, float p_147106_, DamageSource p_147107_) {
        return false;
    }

    protected void checkFallDamage(double p_20809_, boolean p_20810_, BlockState p_20811_, BlockPos p_20812_) {
    }

    public void travel(Vec3 vector) {
        float flyingSpeed = this.getSpeed();
        if (this.isInWater()) {
            this.moveRelative(flyingSpeed / 2.0f, vector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
        } else if (this.isInLava()) {
            this.moveRelative(flyingSpeed / 2.0f, vector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        } else {
            BlockPos ground = new BlockPos((int)this.getX(), (int)this.getY() - 1, (int)this.getZ());
            float f = 0.91f;
            if (this.onGround()) {
                f = this.level().getBlockState(ground).getBlock().getFriction() * 0.91f;
            }
            float f1 = (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) / (double)(f * f * f));
            f = 0.91f;
            if (this.onGround()) {
                f = this.level().getBlockState(ground).getBlock().getFriction() * 0.91f;
            }
            this.moveRelative(this.onGround() ? 0.1f * f1 : flyingSpeed, vector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)f));
        }
        this.calculateEntityAnimation(false);
    }

    public boolean onClimbable() {
        return false;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GUARD_POSITION, (Object)BlockPos.ZERO);
        builder.define(BEHAVIOR, (Object)0);
    }

    public void setBehavior(Behavior behavior) {
        this.entityData.set(BEHAVIOR, (Object)((byte)behavior.ordinal()));
    }

    public Behavior getBehavior() {
        return Behavior.values()[(Byte)this.entityData.get(BEHAVIOR)];
    }

    public BlockPos getGuardPosition() {
        return (BlockPos)this.entityData.get(GUARD_POSITION);
    }

    public void setGuardPosition(BlockPos pos) {
        this.entityData.set(GUARD_POSITION, (Object)pos);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.putLong("Guard position", this.getGuardPosition().asLong());
        compoundNBT.putByte("Behavior", (byte)this.getBehavior().ordinal());
        compoundNBT.put("Upgrades", (Tag)this.upgrades.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compoundNBT.putLong("Previous light position", this.previousPosition.asLong());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.setGuardPosition(BlockPos.of((long)compoundNBT.getLong("Guard position")));
        this.setBehavior(Behavior.values()[compoundNBT.getByte("Behavior")]);
        this.upgrades.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compoundNBT.getCompound("Upgrades"));
        this.upgrades.setSize(5);
        this.previousPosition = BlockPos.of((long)compoundNBT.getLong("Previous light position"));
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal(this));
        this.goalSelector.addGoal(5, (Goal)new MoveOutOfLava(this));
        this.goalSelector.addGoal(6, (Goal)new AvoidAggressors(this));
        this.goalSelector.addGoal(7, (Goal)new StrafeAroundTarget(this));
        this.goalSelector.addGoal(8, (Goal)new GuardArea(this));
    }

    protected PathNavigation createNavigation(Level p_21480_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_21480_);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    protected void playStepSound(BlockPos p_20135_, BlockState p_20136_) {
    }

    @Override
    protected float getHealthRecovered() {
        return this.getMaxHealth() / 4.0f;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.level().getGameTime() % 40L == 0L && !Functions.findItem((Item)((Item)KTItems.RECALL_UPGRADE.get()), (ItemContainer)this.upgrades).isEmpty()) {
                this.getOwner().ifPresent(uuid1 -> {
                    Player player = this.level().getPlayerByUUID(uuid1);
                    if (player != null && (this.getBehavior() == Behavior.FOLLOW_AND_ATTACK || this.getBehavior() == Behavior.FOLLOW_ONLY) && this.distanceTo((Entity)player) > 128.0f) {
                        this.teleportTo(player.getX(), player.getY() + 2.0, player.getZ());
                    }
                });
            }
            if (!Functions.findItem((Item)((Item)KTItems.LIGHT_UPGRADE.get()), (ItemContainer)this.upgrades).isEmpty()) {
                BlockPos currentPos = this.getOnPos();
                if (this.level().isEmptyBlock(currentPos)) {
                    if (this.level().getBlockState(this.previousPosition).is((Block)KTBlocks.LIGHT_BLOCK.get())) {
                        this.level().removeBlock(this.previousPosition, false);
                    }
                    this.level().setBlock(currentPos, ((Block)KTBlocks.LIGHT_BLOCK.get()).defaultBlockState(), 2);
                    this.previousPosition = currentPos;
                }
            } else if (this.level().getBlockState(this.previousPosition).is((Block)KTBlocks.LIGHT_BLOCK.get())) {
                this.level().removeBlock(this.previousPosition, false);
            }
        }
    }

    @Override
    public boolean fireImmune() {
        return Functions.contains((Item)((Item)KTItems.FIRE_SHIELD.get()), (ItemContainer)this.upgrades);
    }

    public static enum Behavior {
        FOLLOW_AND_ATTACK,
        FOLLOW_ONLY,
        GUARD,
        STAY;

    }
}

