/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.MultimapAdapter;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.registries.KTItems;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.ItemContainer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KTurrets {
    public static final String ID = "k_turrets";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"K-Turrets");
    public static final IntegerColor upgradeSlotColor = new IntegerColor(-668091);
    public static ArrayListMultimap<String, String> serverUnitDeaths = ArrayListMultimap.create();
    public static final Type TYPE = new TypeToken<ArrayListMultimap<UUID, String>>(){}.getType();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(TYPE, (Object)new MultimapAdapter()).create();
    public static HashMap<ResourceLocation, Pair<Item, NumberProvider>> playerDependentLoot = new HashMap();
    public static final TagKey<Item> TITANIUM_INGOT = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"satako", (String)"ingots/titanium"));
    public static final int turretSlotCount = 29;
    public static final int turretUpgradeCount = 3;
    public static final int droneSlotCount = 23;
    public static final int droneUpgradeCount = 5;
    public static final DustParticleOptions PARTICLE = new DustParticleOptions(Vec3.fromRGB24((int)-12071696).toVector3f(), 1.0f);
    public static TagKey<Item> COBBLE_UNIT_AMMO_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"cobble_unit_ammo"));
    public static TagKey<Item> ARROW_UNIT_AMMO_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"arrow_unit_ammo"));
    public static TagKey<Item> BRICK_UNIT_AMMO_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"brick_unit_ammo"));
    public static TagKey<Item> BULLET_UNIT_AMMO_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"bullet_unit_ammo"));
    public static TagKey<Item> FIREBALL_UNIT_AMMO = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"fireball_unit_ammo"));
    public static TagKey<Item> GAUSS_UNIT_AMMO_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"gauss_unit_ammo"));
    public static CreativeModeTab TAB = CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).title((Component)Component.literal((String)"K-Turrets")).icon(() -> new ItemStack((ItemLike)KTItems.GAUSS_TURRET.get())).displayItems((parameters, output) -> {
        output.accept((ItemLike)KTItems.TITANIUM_ORE.get());
        output.accept((ItemLike)KTItems.DEEPSLATE_TITANIUM_ORE.get());
        output.accept((ItemLike)KTItems.RAW_TITANIUM.get());
        output.accept((ItemLike)KTItems.TITANIUM_INGOT.get());
        output.accept((ItemLike)KTItems.COPPER_PLATE.get());
        output.accept((ItemLike)KTItems.COBBLE_TURRET.get());
        output.accept((ItemLike)KTItems.FIREBALL_TURRET.get());
        output.accept((ItemLike)KTItems.ARROW_TURRET.get());
        output.accept((ItemLike)KTItems.BULLET_TURRET.get());
        output.accept((ItemLike)KTItems.BRICK_TURRET.get());
        output.accept((ItemLike)KTItems.GAUSS_TURRET.get());
        output.accept((ItemLike)KTItems.COBBLE_DRONE.get());
        output.accept((ItemLike)KTItems.FIREBALL_DRONE.get());
        output.accept((ItemLike)KTItems.ARROW_DRONE.get());
        output.accept((ItemLike)KTItems.BULLET_DRONE.get());
        output.accept((ItemLike)KTItems.BRICK_DRONE.get());
        output.accept((ItemLike)KTItems.GAUSS_DRONE.get());
        output.accept((ItemLike)KTItems.STORAGE_DRONE.get());
        output.accept((ItemLike)KTItems.EXPLOSIVE_POWDER.get());
        output.accept((ItemLike)KTItems.BULLET.get());
        output.accept((ItemLike)KTItems.GAUSS_BULLET.get());
        output.accept((ItemLike)KTItems.MAGNET_UPGRADE.get());
        output.accept((ItemLike)KTItems.EXP_LINK.get());
        output.accept((ItemLike)KTItems.LIGHT_UPGRADE.get());
        output.accept((ItemLike)KTItems.FIRE_SHIELD.get());
        output.accept((ItemLike)KTItems.RECALL_UPGRADE.get());
        output.accept((ItemLike)KTItems.LOOTING_LINK.get());
        output.accept((ItemLike)KTItems.RELOADER.get());
        output.accept((ItemLike)KTItems.TARGET_COPIER.get());
    }).build();
    public static HashMap<Supplier<EntityType<Entity>>, Supplier<AttributeSupplier.Builder>> attributes = new HashMap();
    public static int arrowUnitDelay;
    public static int fireballUnitDelay;
    public static int bulletUnitDelay;
    public static int brickUnitDelay;
    public static int cobbleUnitDelay;
    public static int gaussUnitDelay;
    public static int arrowUnitDamage;
    public static int fireballUnitDamage;
    public static int bulletUnitDamage;
    public static int brickUnitDamage;
    public static int cobbleUnitDamage;
    public static int gaussUnitDamage;
    public static int turretLimit;
    public static int droneLimit;
    public static int ownerFollowDistance;
    public static boolean setOwnerAuto;
    public static List<String> defaultExceptions;
    public static float projectileSpeed;
    public static final TagKey<Item> REPAIR_ITEMS;

    public static void run() {
        LOGGER.info("Platform hooks - {}", (Object)Services.PLATFORM.getClass().getSimpleName());
        Services.PLATFORM.initializeProperties();
    }

    public static void setTargets(LivingEntity livingEntity, DamageSource damageSource) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Level level = serverPlayer.level();
            List turrets = level.getEntitiesOfClass(Turret.class, serverPlayer.getBoundingBox().inflate(128.0));
            turrets.forEach(turret -> {
                Entity directSource = damageSource.getEntity();
                if (turret.isProtectingOwner() && turret.getTarget() == null && directSource instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)directSource;
                    if (turret.isArmed()) {
                        turret.setTarget(living);
                    }
                }
            });
        }
    }

    static void dropExperienceAndItems(ServerLevel serverLevel, Entity deathCauser, LivingEntity entity) {
        block15: {
            ResourceKey lootTableName;
            Pair<Item, NumberProvider> numberProviderPair;
            block14: {
                Turret turret;
                block13: {
                    Drone drone;
                    if (deathCauser instanceof Drone) {
                        drone = (Drone)deathCauser;
                        if (Functions.contains((Item)((Item)KTItems.EXP_LINK.get()), (ItemContainer)drone.upgrades)) {
                            ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)entity.getPosition(1.0f), (int)entity.getExperienceReward(serverLevel, deathCauser));
                        }
                    } else if (deathCauser instanceof Turret) {
                        turret = (Turret)deathCauser;
                        if (Functions.contains((Item)((Item)KTItems.EXP_LINK.get()), (ItemContainer)turret.upgrades)) {
                            ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)entity.getPosition(1.0f), (int)entity.getExperienceReward(serverLevel, deathCauser));
                        }
                    }
                    if (!(deathCauser instanceof Drone)) break block13;
                    drone = (Drone)deathCauser;
                    if (Functions.contains((Item)((Item)KTItems.LOOTING_LINK.get()), (ItemContainer)drone.upgrades)) break block14;
                }
                if (!(deathCauser instanceof Turret)) break block15;
                turret = (Turret)deathCauser;
                if (!Functions.contains((Item)((Item)KTItems.LOOTING_LINK.get()), (ItemContainer)turret.upgrades)) break block15;
            }
            if ((numberProviderPair = playerDependentLoot.get((lootTableName = entity.getLootTable()).location())) != null) {
                NumberProvider numberProvider = (NumberProvider)numberProviderPair.getRight();
                if (numberProvider instanceof UniformGenerator) {
                    UniformGenerator uniformGenerator = (UniformGenerator)numberProvider;
                    if (Mth.nextFloat((RandomSource)serverLevel.random, (float)uniformGenerator.min().getFloat(null), (float)1.0f) < uniformGenerator.max().getFloat(null)) {
                        serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)numberProviderPair.getKey())));
                    }
                } else {
                    ConstantValue c = (ConstantValue)numberProvider;
                    if (Mth.nextFloat((RandomSource)serverLevel.random, (float)0.0f, (float)1.0f) < c.getFloat(null)) {
                        serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)numberProviderPair.getKey())));
                    }
                }
            }
        }
    }

    static void analyzeTables(ResourceLocation lootTableName, LootTable lootTable) {
        if (lootTableName.getPath().contains("entit") && !lootTable.pools.isEmpty()) {
            LOGGER.info("Checking {} loot table", (Object)lootTableName);
            lootTable.pools.forEach(lootPool -> {
                boolean killedByPlayer = false;
                LootItemRandomChanceWithEnchantedBonusCondition randomChanceWithLootingCondition = null;
                for (LootItemCondition condition : lootPool.conditions) {
                    if (condition instanceof LootItemKilledByPlayerCondition) {
                        killedByPlayer = true;
                    }
                    if (!(condition instanceof LootItemRandomChanceWithEnchantedBonusCondition)) continue;
                    randomChanceWithLootingCondition = (LootItemRandomChanceWithEnchantedBonusCondition)condition;
                }
                if (killedByPlayer) {
                    for (LootPoolEntryContainer entry : lootPool.entries) {
                        if (!(entry instanceof LootItem)) continue;
                        LootItem lootItem = (LootItem)entry;
                        Item loot = (Item)lootItem.item.value();
                        for (LootItemFunction function : lootItem.functions) {
                            if (!(function instanceof SetItemCountFunction)) continue;
                            SetItemCountFunction s = (SetItemCountFunction)function;
                            NumberProvider numberProvider = s.value;
                            if (numberProvider instanceof ConstantValue) {
                                ConstantValue constantValue = (ConstantValue)numberProvider;
                                float value = constantValue.getFloat(null);
                                LOGGER.info("   Including {} with constant set item function {}", (Object)loot, (Object)Float.valueOf(value));
                                playerDependentLoot.put(lootTableName, (Pair<Item, NumberProvider>)Pair.of((Object)loot, (Object)numberProvider));
                                continue;
                            }
                            if (!(numberProvider instanceof UniformGenerator)) continue;
                            UniformGenerator ug = (UniformGenerator)numberProvider;
                            ConstantValue minP = (ConstantValue)ug.min();
                            ConstantValue maxP = (ConstantValue)ug.max();
                            LOGGER.info("   Including {} with uniform set item function {}-{}", new Object[]{loot, Float.valueOf(minP.value()), Float.valueOf(maxP.value())});
                            playerDependentLoot.put(lootTableName, (Pair<Item, NumberProvider>)Pair.of((Object)loot, (Object)ug));
                        }
                        if (randomChanceWithLootingCondition == null) continue;
                        float chanceForItem = randomChanceWithLootingCondition.unenchantedChance() / (float)lootPool.entries.size();
                        LOGGER.info("   Including {} with random looting chance {}", (Object)loot, (Object)Float.valueOf(chanceForItem));
                        playerDependentLoot.put(lootTableName, (Pair<Item, NumberProvider>)Pair.of((Object)loot, (Object)UniformGenerator.between((float)0.0f, (float)chanceForItem)));
                    }
                }
            });
        }
    }

    static {
        REPAIR_ITEMS = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"unit_repair"));
    }
}

