/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.TurretRenderer;
import dev.buildtool.kturrets.drones.StorageDrone;
import dev.buildtool.kturrets.models.ArrowDroneModel;
import dev.buildtool.kturrets.models.ArrowTurretModelNew;
import dev.buildtool.kturrets.models.ArrowTurretModelv3;
import dev.buildtool.kturrets.models.BrickDroneModel;
import dev.buildtool.kturrets.models.BrickModel;
import dev.buildtool.kturrets.models.BrickTurretModelNew;
import dev.buildtool.kturrets.models.BrickTurretModelv2;
import dev.buildtool.kturrets.models.BulletDroneModel;
import dev.buildtool.kturrets.models.BulletModel;
import dev.buildtool.kturrets.models.BulletTurretModelNew;
import dev.buildtool.kturrets.models.BulletTurretModelv4;
import dev.buildtool.kturrets.models.CobbleDroneModelv2;
import dev.buildtool.kturrets.models.CobbleTurretModelNew;
import dev.buildtool.kturrets.models.CobbleTurretModelv4;
import dev.buildtool.kturrets.models.CobblestoneModel;
import dev.buildtool.kturrets.models.FireballDroneModel;
import dev.buildtool.kturrets.models.FireballTurretModelNew;
import dev.buildtool.kturrets.models.FireballTurretModelv4;
import dev.buildtool.kturrets.models.GaussBulletModel;
import dev.buildtool.kturrets.models.GaussDroneModel;
import dev.buildtool.kturrets.models.GaussTurretModelv2;
import dev.buildtool.kturrets.models.StorageDroneModel;
import dev.buildtool.kturrets.registries.KTEntities;
import dev.buildtool.kturrets.renderers.BrickRenderer;
import dev.buildtool.kturrets.renderers.BulletRenderer;
import dev.buildtool.kturrets.renderers.CobblestoneRenderer;
import dev.buildtool.kturrets.renderers.GaussBulletRenderer;
import dev.buildtool.satako.Configuration;
import dev.buildtool.satako.Constants;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.client.ClientMethods;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class KTurretsClient {
    public static final HashMap<com.google.common.base.Supplier<EntityType<Entity>>, EntityRendererProvider<Entity>> RENDERERS = new HashMap();
    public static final HashMap<ModelLayerLocation, Supplier<LayerDefinition>> LAYER_DEFINITIONS = new HashMap();
    public static final KeyMapping highlightDronePositions = new KeyMapping("Highlight drone locations", InputConstants.Type.KEYSYM, 75, "K-Turrets");

    public static void run() {
        Configuration c;
        try {
            c = new Configuration("k_turrets-models");
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't create configuration file");
        }
        boolean useNewArrowTurretModel = c.getBoolean("Use new arrow turret model", true);
        if (useNewArrowTurretModel) {
            RENDERERS.put(KTEntities.ARROW_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new ArrowTurretModelNew<LivingEntity>(context.bakeLayer(ArrowTurretModelNew.LAYER_LOCATION)), "arrow_turret_new", 0.4f)))));
        } else {
            RENDERERS.put(KTEntities.ARROW_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new ArrowTurretModelv3<LivingEntity>(context.bakeLayer(ArrowTurretModelv3.LAYER_LOCATION)), "arrow_turret", 0.4f)))));
        }
        RENDERERS.put(KTEntities.STORAGE_DRONE, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new StorageDroneModel<LivingEntity>(context.bakeLayer(StorageDroneModel.LAYER_LOCATION)), "storage_drone", 0.4f)))));
        boolean useNewBrickTurretModel = c.getBoolean("Use new brick turret model", true);
        if (useNewBrickTurretModel) {
            RENDERERS.put(KTEntities.BRICK_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new BrickTurretModelNew<LivingEntity>(context.bakeLayer(BrickTurretModelNew.LAYER_LOCATION)), "brick_turret_new", 0.4f)))));
        } else {
            RENDERERS.put(KTEntities.BRICK_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new BrickTurretModelv2<LivingEntity>(context.bakeLayer(BrickTurretModelv2.LAYER_LOCATION)), "brick_turret", 0.4f)))));
        }
        RENDERERS.put(KTEntities.BRICK, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new BrickRenderer(context)))));
        RENDERERS.put(KTEntities.BULLET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new BulletRenderer(context)))));
        boolean useNewBulletTurretModel = c.getBoolean("Use new bullet turret model", true);
        if (useNewBulletTurretModel) {
            RENDERERS.put(KTEntities.BULLET_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new BulletTurretModelNew<LivingEntity>(context.bakeLayer(BulletTurretModelNew.LAYER_LOCATION)), "bullet_turret_new", 0.4f)))));
        } else {
            RENDERERS.put(KTEntities.BULLET_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new BulletTurretModelv4<LivingEntity>(context.bakeLayer(BulletTurretModelv4.LAYER_LOCATION)), "bullet_turret", 0.4f)))));
        }
        boolean useNewCobbleTurretModel = c.getBoolean("Use new cobble turret model", true);
        if (useNewCobbleTurretModel) {
            RENDERERS.put(KTEntities.COBBLE_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new CobbleTurretModelNew<LivingEntity>(context.bakeLayer(CobbleTurretModelNew.LAYER_LOCATION)), "cobble_turret_new", 0.4f)))));
        } else {
            RENDERERS.put(KTEntities.COBBLE_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new CobbleTurretModelv4<LivingEntity>(context.bakeLayer(CobbleTurretModelv4.LAYER_LOCATION)), "cobble_turret", 0.4f)))));
        }
        RENDERERS.put(KTEntities.COBBLESTONE, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new CobblestoneRenderer(context)))));
        boolean useNewFireballTurretModel = c.getBoolean("Use new fireball turret model", true);
        if (useNewFireballTurretModel) {
            RENDERERS.put(KTEntities.FIRE_BALL_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new FireballTurretModelNew<LivingEntity>(context.bakeLayer(FireballTurretModelNew.LAYER_LOCATION)), "fireball_turret_new", 0.4f)))));
        } else {
            RENDERERS.put(KTEntities.FIRE_BALL_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new FireballTurretModelv4<LivingEntity>(context.bakeLayer(FireballTurretModelv4.LAYER_LOCATION)), "fireball_turret", 0.4f)))));
        }
        RENDERERS.put(KTEntities.GAUSS_TURRET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new GaussTurretModelv2<LivingEntity>(context.bakeLayer(GaussTurretModelv2.LAYER_LOCATION)), "gauss_turret", 0.4f)))));
        RENDERERS.put(KTEntities.GAUSS_BULLET, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new GaussBulletRenderer(context)))));
        RENDERERS.put(KTEntities.ARROW_DRONE, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new ArrowDroneModel<LivingEntity>(context.bakeLayer(ArrowDroneModel.LAYER_LOCATION)), "arrow_drone", 0.2f)))));
        RENDERERS.put(KTEntities.BRICK_DRONE, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new BrickDroneModel<LivingEntity>(context.bakeLayer(BrickDroneModel.LAYER_LOCATION)), "brick_drone", 0.2f)))));
        RENDERERS.put(KTEntities.BULLET_DRONE, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new BulletDroneModel<LivingEntity>(context.bakeLayer(BulletDroneModel.LAYER_LOCATION)), "bullet_drone", 0.2f)))));
        RENDERERS.put(KTEntities.COBBLE_DRONE, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new CobbleDroneModelv2<LivingEntity>(context.bakeLayer(CobbleDroneModelv2.LAYER_LOCATION)), "cobble_drone", 0.2f)))));
        RENDERERS.put(KTEntities.FIREBALL_DRONE, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new FireballDroneModel<LivingEntity>(context.bakeLayer(FireballDroneModel.LAYER_LOCATION)), "fireball_drone", 0.2f)))));
        RENDERERS.put(KTEntities.GAUSS_DRONE, (EntityRendererProvider<Entity>)((EntityRendererProvider)context -> (EntityRenderer)Functions.cast((Object)((Object)new TurretRenderer(context, new GaussDroneModel<LivingEntity>(context.bakeLayer(GaussDroneModel.LAYER_LOCATION)), "gauss_drone", 0.2f)))));
        if (useNewArrowTurretModel) {
            LAYER_DEFINITIONS.put(ArrowTurretModelNew.LAYER_LOCATION, ArrowTurretModelNew::createBodyLayer);
        } else {
            LAYER_DEFINITIONS.put(ArrowTurretModelv3.LAYER_LOCATION, ArrowTurretModelv3::createBodyLayer);
        }
        LAYER_DEFINITIONS.put(StorageDroneModel.LAYER_LOCATION, StorageDroneModel::createBodyLayer);
        if (useNewBrickTurretModel) {
            LAYER_DEFINITIONS.put(BrickTurretModelNew.LAYER_LOCATION, BrickTurretModelNew::createBodyLayer);
        } else {
            LAYER_DEFINITIONS.put(BrickTurretModelv2.LAYER_LOCATION, BrickTurretModelv2::createBodyLayer);
        }
        LAYER_DEFINITIONS.put(BrickModel.LAYER_LOCATION, BrickModel::createBodyLayer);
        LAYER_DEFINITIONS.put(BulletModel.LAYER_LOCATION, BulletModel::createBodyLayer);
        if (useNewBulletTurretModel) {
            LAYER_DEFINITIONS.put(BulletTurretModelNew.LAYER_LOCATION, BulletTurretModelNew::createBodyLayer);
        } else {
            LAYER_DEFINITIONS.put(BulletTurretModelv4.LAYER_LOCATION, BulletTurretModelv4::createBodyLayer);
        }
        if (useNewCobbleTurretModel) {
            LAYER_DEFINITIONS.put(CobbleTurretModelNew.LAYER_LOCATION, CobbleTurretModelNew::createBodyLayer);
        } else {
            LAYER_DEFINITIONS.put(CobbleTurretModelv4.LAYER_LOCATION, CobbleTurretModelv4::createBodyLayer);
        }
        LAYER_DEFINITIONS.put(CobblestoneModel.LAYER_LOCATION, CobblestoneModel::createBodyLayer);
        if (useNewFireballTurretModel) {
            LAYER_DEFINITIONS.put(FireballTurretModelNew.LAYER_LOCATION, FireballTurretModelNew::createBodyLayer);
        } else {
            LAYER_DEFINITIONS.put(FireballTurretModelv4.LAYER_LOCATION, FireballTurretModelv4::createBodyLayer);
        }
        LAYER_DEFINITIONS.put(GaussTurretModelv2.LAYER_LOCATION, GaussTurretModelv2::createBodyLayer);
        LAYER_DEFINITIONS.put(GaussBulletModel.LAYER_LOCATION, GaussBulletModel::createBodyLayer);
        LAYER_DEFINITIONS.put(ArrowDroneModel.LAYER_LOCATION, ArrowDroneModel::createBodyLayer);
        LAYER_DEFINITIONS.put(BrickDroneModel.LAYER_LOCATION, BrickDroneModel::createBodyLayer);
        LAYER_DEFINITIONS.put(BulletDroneModel.LAYER_LOCATION, BulletDroneModel::createBodyLayer);
        LAYER_DEFINITIONS.put(CobbleDroneModelv2.LAYER_LOCATION, CobbleDroneModelv2::createBodyLayer);
        LAYER_DEFINITIONS.put(FireballDroneModel.LAYER_LOCATION, FireballDroneModel::createBodyLayer);
        LAYER_DEFINITIONS.put(GaussDroneModel.LAYER_LOCATION, GaussDroneModel::createBodyLayer);
        c.save();
    }

    public static void renderHealthAndAmmoIndicators(PoseStack poseStack, LivingEntity livingEntity, MultiBufferSource bufferSource, Font font) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (livingEntity instanceof Turret) {
            Turret turret = (Turret)livingEntity;
            assert (player != null);
            if (player.distanceTo((Entity)turret) < 23.0f && (turret.getOwner().isEmpty() || turret.getOwner().isPresent() && (player.getUUID().equals(turret.getOwner().get()) || player.isAlliedTo((Entity)turret)))) {
                poseStack.pushPose();
                String health = String.format("%.1f", Float.valueOf(livingEntity.getHealth())) + "/" + (int)livingEntity.getMaxHealth();
                poseStack.scale(0.03f, 0.03f, 0.03f);
                poseStack.mulPose(Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                poseStack.translate((float)(-font.width(health)) / 2.0f, -30.0f - livingEntity.getBbHeight() * 30.0f, 0.0f);
                font.drawInBatch(health, 0.0f, 0.0f, livingEntity.getHealth() < livingEntity.getMaxHealth() / 2.0f ? ChatFormatting.RED.getColor().intValue() : ChatFormatting.GREEN.getColor().intValue(), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                if (turret.noAmmo && !(turret instanceof StorageDrone)) {
                    poseStack.translate(0.0f, -13.0f, 0.0f);
                    MutableComponent noAmmo = Component.translatable((String)"k_turrets.no.ammo");
                    font.drawInBatch((Component)noAmmo, 0.0f, 0.0f, ChatFormatting.RED.getColor().intValue(), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                poseStack.popPose();
            }
        }
    }

    public static void addInfo(ItemStack stack, List<Component> tooltip) {
        if (stack.is(KTurrets.COBBLE_UNIT_AMMO_TAG)) {
            tooltip.add((Component)Component.translatable((String)"k_turrets.cobble.unit.ammo"));
        }
        if (stack.is(KTurrets.ARROW_UNIT_AMMO_TAG)) {
            tooltip.add((Component)Component.translatable((String)"k_turrets.arrow.unit.ammo"));
        }
        if (stack.is(KTurrets.GAUSS_UNIT_AMMO_TAG)) {
            tooltip.add((Component)Component.translatable((String)"k_turrets.gauss.unit.ammo"));
        }
        if (stack.is(KTurrets.BRICK_UNIT_AMMO_TAG)) {
            tooltip.add((Component)Component.translatable((String)"k_turrets.brick.unit.ammo"));
        }
        if (stack.is(KTurrets.BULLET_UNIT_AMMO_TAG)) {
            tooltip.add((Component)Component.translatable((String)"k_turrets.bullet.unit.ammo"));
        }
        if (stack.is(KTurrets.FIREBALL_UNIT_AMMO)) {
            tooltip.add((Component)Component.translatable((String)"k_turrets.fireball.unit.ammo"));
        }
    }

    public static void noDrones(GuiGraphics guiGraphics) {
        if (highlightDronePositions.isDown()) {
            Minecraft minecraft = Minecraft.getInstance();
            int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            MutableComponent warning = Component.translatable((String)"k_turrets.no.drones.nearby");
            guiGraphics.drawString(minecraft.font, (Component)warning, screenWidth / 2 - minecraft.font.width((FormattedText)warning) / 2, 5, Constants.GREEN.getIntColor());
        }
    }

    public static boolean renderDroneLocations(PoseStack poseStack) {
        if (highlightDronePositions.isDown()) {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            List nearbyDrones = minecraft.level.getEntitiesOfClass(Drone.class, new AABB(player.blockPosition()).inflate(128.0), arg_0 -> KTurretsClient.lambda$renderDroneLocations$22((Player)player, arg_0));
            if (!nearbyDrones.isEmpty()) {
                MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
                Vec3 projectedView = minecraft.gameRenderer.getMainCamera().getPosition();
                RenderSystem.disableDepthTest();
                poseStack.pushPose();
                poseStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
                IntegerColor yellow = new IntegerColor(-1998526446);
                nearbyDrones.forEach(arg_0 -> KTurretsClient.lambda$renderDroneLocations$23(poseStack, (MultiBufferSource)bufferSource, yellow, arg_0));
                poseStack.popPose();
                return false;
            }
            return true;
        }
        return true;
    }

    private static /* synthetic */ void lambda$renderDroneLocations$23(PoseStack poseStack, MultiBufferSource bufferSource, IntegerColor yellow, Drone drone) {
        Vec3 dronePosition = drone.getPosition(1.0f);
        poseStack.translate(dronePosition.x - 0.5, dronePosition.y - 0.2, dronePosition.z - 0.5);
        ClientMethods.addCube((VertexConsumer)bufferSource.getBuffer(RenderType.guiOverlay()), (Matrix4f)poseStack.last().pose(), (int)0, (int)0, (int)0, (float)yellow.getRed(), (float)yellow.getGreen(), (float)yellow.getBlue(), (float)yellow.getAlpha(), (boolean)false, (float)0.0f);
        poseStack.translate(-(dronePosition.x - 0.5), -(dronePosition.y - 0.2), -(dronePosition.z - 0.5));
    }

    private static /* synthetic */ boolean lambda$renderDroneLocations$22(Player player, Drone drone) {
        return drone.getOwner().isPresent() && drone.getOwner().get().equals(player.getUUID());
    }
}

