/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.google.common.base.Supplier;
import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTMenus;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.UnitLimits;
import dev.buildtool.kturrets.drones.StorageDrone;
import dev.buildtool.kturrets.packets.AddPlayerException;
import dev.buildtool.kturrets.packets.AmmoCheck;
import dev.buildtool.kturrets.packets.ClaimTurret;
import dev.buildtool.kturrets.packets.CompressItems;
import dev.buildtool.kturrets.packets.DismantleTurret;
import dev.buildtool.kturrets.packets.MagnetFilterMode;
import dev.buildtool.kturrets.packets.PickupParticles;
import dev.buildtool.kturrets.packets.RemovePlayerException;
import dev.buildtool.kturrets.packets.SetBehavior;
import dev.buildtool.kturrets.packets.SetMagnetState;
import dev.buildtool.kturrets.packets.SetProtectPlayer;
import dev.buildtool.kturrets.packets.SetRefillInventory;
import dev.buildtool.kturrets.packets.SetTarget;
import dev.buildtool.kturrets.packets.ToggleMobility;
import dev.buildtool.kturrets.packets.TogglePlayerProtection;
import dev.buildtool.kturrets.packets.TurretTargets;
import dev.buildtool.kturrets.registries.KTBlockEntities;
import dev.buildtool.kturrets.registries.KTBlocks;
import dev.buildtool.kturrets.registries.KTDataComponents;
import dev.buildtool.kturrets.registries.KTEntities;
import dev.buildtool.kturrets.registries.KTItems;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import dev.buildtool.satako.NeoforgeFunctions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="k_turrets")
public class KTurretsNeoforge {
    public static ModConfigSpec.IntValue ARROW_TURRET_DAMAGE;
    public static ModConfigSpec.IntValue ARROW_TURRET_RATE;
    public static ModConfigSpec.IntValue BULLET_TURRET_RATE;
    public static ModConfigSpec.IntValue FIREBALL_TURRET_RATE;
    public static ModConfigSpec.IntValue IRON_BULLET_DAMAGE;
    public static ModConfigSpec.IntValue FIREBALL_TURRET_DAMAGE;
    public static ModConfigSpec.IntValue BRICK_DAMAGE;
    public static ModConfigSpec.IntValue BRICK_TURRET_RATE;
    public static ModConfigSpec.IntValue GAUSS_TURRET_DAMAGE;
    public static ModConfigSpec.IntValue GAUSS_TURRET_RATE;
    public static ModConfigSpec.IntValue COBBLE_TURRET_DAMAGE;
    public static ModConfigSpec.IntValue COBBLE_TURRET_RATE;
    public static ModConfigSpec.BooleanValue SHOW_INTEGRITY;
    public static ModConfigSpec.IntValue TURRET_LIMIT_PER_PLAYER;
    public static ModConfigSpec.IntValue DRONE_LIMIT_PER_PLAYER;
    public static ModConfigSpec.DoubleValue PROJECTILE_SPEED;
    public static ModConfigSpec.ConfigValue<List<? extends String>> TARGET_EXCEPTIONS;
    public static ModConfigSpec.BooleanValue SET_OWNER_AUTO;
    public static ModConfigSpec.IntValue OWNER_FOLLOW_DISTANCE;
    public static ModConfigSpec.IntValue COBBLE_TURRET_HEALTH;
    public static ModConfigSpec.IntValue COBBLE_TURRET_ARMOR;
    public static ModConfigSpec.IntValue COBBLE_TURRET_RANGE;
    public static ModConfigSpec.IntValue FIREBALL_TURRET_RANGE;
    public static ModConfigSpec.IntValue FIREBALL_TURRET_HEALTH;
    public static ModConfigSpec.IntValue FIREBALL_TURRET_ARMOR;
    public static ModConfigSpec.IntValue ARROW_TURRET_HEALTH;
    public static ModConfigSpec.IntValue ARROW_TURRET_ARMOR;
    public static ModConfigSpec.IntValue ARROW_TURRET_RANGE;
    public static ModConfigSpec.IntValue BULLET_TURRET_HEALTH;
    public static ModConfigSpec.IntValue BULLET_TURRET_ARMOR;
    public static ModConfigSpec.IntValue BULLET_TURRET_RANGE;
    public static ModConfigSpec.IntValue BRICK_TURRET_HEALTH;
    public static ModConfigSpec.IntValue BRICK_TURRET_ARMOR;
    public static ModConfigSpec.IntValue BRICK_TURRET_RANGE;
    public static ModConfigSpec.IntValue GAUSS_TURRET_HEALTH;
    public static ModConfigSpec.IntValue GAUSS_TURRET_ARMOR;
    public static ModConfigSpec.IntValue GAUSS_TURRET_RANGE;
    public static ModConfigSpec.IntValue STORAGE_DRONE_HEALTH;
    public static ModConfigSpec.IntValue STORAGE_DRONE_ARMOR;
    static final DeferredRegister<Block> BLOCKS;
    static final DeferredRegister<Item> ITEMS;
    static final DeferredRegister<EntityType<?>> ENTITIES;
    static final DeferredRegister<MenuType<?>> MENUS;
    static final DeferredRegister<CreativeModeTab> TABS;
    static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS;
    static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    public static final ArrayList<String> DEFAULT_TARGETS;

    public KTurretsNeoforge(IEventBus eventBus, ModContainer modContainer) throws IOException {
        KTurrets.run();
        KTBlocks.BLOCK_MAP.forEach((s, blockLazyInitializer2) -> BLOCKS.register(s, () -> ((Supplier)blockLazyInitializer2).get()));
        KTItems.ITEM_MAP.forEach((arg_0, arg_1) -> ITEMS.register(arg_0, arg_1));
        KTEntities.ENTITY_MAP.forEach((s, entityTypeLazyInitializer2) -> ENTITIES.register(s, () -> ((Supplier)entityTypeLazyInitializer2).get()));
        KTMenus.MENUS.register(eventBus);
        TABS.register("main", () -> KTurrets.TAB);
        KTDataComponents.COMPONENTS.forEach((s, dataComponentType) -> DATA_COMPONENTS.register(s, () -> dataComponentType));
        BLOCK_ENTITIES.register("reloader", KTBlockEntities.RELOADER);
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        ENTITIES.register(eventBus);
        MENUS.register(eventBus);
        TABS.register(eventBus);
        DATA_COMPONENTS.register(eventBus);
        BLOCK_ENTITIES.register(eventBus);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            builder.push("Cobblestone turret");
            COBBLE_TURRET_HEALTH = builder.defineInRange("Integrity", 60, 10, 1024);
            COBBLE_TURRET_ARMOR = builder.defineInRange("Armor", 3, 0, 30);
            COBBLE_TURRET_RANGE = builder.defineInRange("Range", 8, 32, 200);
            builder.pop();
            builder.push("Fireball turret");
            FIREBALL_TURRET_HEALTH = builder.defineInRange("Integrity", 10, 60, 1024);
            FIREBALL_TURRET_ARMOR = builder.defineInRange("Armor", 3, 0, 30);
            FIREBALL_TURRET_RANGE = builder.defineInRange("Range", 8, 32, 200);
            builder.pop();
            builder.push("Arrow turret");
            ARROW_TURRET_HEALTH = builder.defineInRange("Integrity", 60, 10, 1024);
            ARROW_TURRET_ARMOR = builder.defineInRange("Armor", 3, 0, 30);
            ARROW_TURRET_RANGE = builder.defineInRange("Range", 32, 8, 200);
            builder.pop();
            builder.push("Bullet turret");
            BULLET_TURRET_HEALTH = builder.defineInRange("Integrity", 60, 10, 1024);
            BULLET_TURRET_ARMOR = builder.defineInRange("Armor", 3, 0, 30);
            BULLET_TURRET_RANGE = builder.defineInRange("Range", 32, 8, 200);
            builder.pop();
            builder.push("Brick turret");
            BRICK_TURRET_HEALTH = builder.defineInRange("Integrity", 60, 10, 1024);
            BRICK_TURRET_ARMOR = builder.defineInRange("Armor", 3, 0, 30);
            BRICK_TURRET_RANGE = builder.defineInRange("Range", 32, 8, 1024);
            builder.pop();
            builder.push("Gauss turret");
            GAUSS_TURRET_HEALTH = builder.defineInRange("Integrity", 60, 10, 1024);
            GAUSS_TURRET_ARMOR = builder.defineInRange("Armor", 3, 0, 30);
            GAUSS_TURRET_RANGE = builder.defineInRange("Range", 32, 8, 200);
            builder.pop();
            builder.push("Storage drone");
            STORAGE_DRONE_ARMOR = builder.defineInRange("Armor", 0, 0, 30);
            STORAGE_DRONE_HEALTH = builder.defineInRange("Health", 50, 10, 1024);
            return builder.build();
        }).getRight());
        Pair pair = new ModConfigSpec.Builder().configure(builder -> {
            builder.push("Common");
            PROJECTILE_SPEED = builder.defineInRange("Turret and drone projectile speed", 50.0, 0.1, 50.0);
            TARGET_EXCEPTIONS = builder.comment("List of mob ids to be excluded from default targets").defineList("Target list exceptions", List.of("minecraft:zombified_piglin", "minecraft:ender_dragon"), o -> o instanceof String && ((String)o).contains(":"));
            SET_OWNER_AUTO = builder.define("Set ownership automatically", true);
            OWNER_FOLLOW_DISTANCE = builder.defineInRange("Drones will keep to the owner at such distance", 30, 1, 128);
            builder.pop();
            builder.push("Stats");
            builder.push("Arrow units");
            ARROW_TURRET_RATE = builder.comment("In ticks").defineInRange("Delay between shots", 20, 1, 60);
            ARROW_TURRET_DAMAGE = builder.defineInRange("Base damage", 6, 1, 1024);
            builder.pop();
            builder.push("Bullet units");
            BULLET_TURRET_RATE = builder.comment("In ticks").defineInRange("Delay between shots", 20, 1, 60);
            IRON_BULLET_DAMAGE = builder.defineInRange("Damage", 8, 1, 1024);
            builder.pop();
            builder.push("Fireball units");
            FIREBALL_TURRET_RATE = builder.comment("In ticks").defineInRange("Delay between shots", 20, 1, 60);
            FIREBALL_TURRET_DAMAGE = builder.defineInRange("Damage", 6, 1, 1024);
            builder.pop();
            builder.push("Brick units");
            BRICK_TURRET_RATE = builder.comment("In ticks").defineInRange("Delay between shots", 20, 1, 60);
            BRICK_DAMAGE = builder.defineInRange("Damage", 9, 1, 1024);
            builder.pop();
            builder.push("Gauss units");
            GAUSS_TURRET_RATE = builder.comment("In ticks").defineInRange("Delay between shots", 20, 1, 60);
            GAUSS_TURRET_DAMAGE = builder.defineInRange("Damage", 12, 1, 1024);
            builder.pop();
            builder.push("Cobble units");
            COBBLE_TURRET_RATE = builder.comment("In ticks").defineInRange("Delay between shots", 20, 1, 60);
            COBBLE_TURRET_DAMAGE = builder.defineInRange("Damage", 3, 1, 1024);
            builder.pop();
            builder.pop();
            return builder.build();
        });
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)pair.getRight());
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            SHOW_INTEGRITY = builder.define("Show turret and drone integrity", true);
            return builder.build();
        }).getRight());
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)new ModConfigSpec.Builder().configure(builder -> {
            TURRET_LIMIT_PER_PLAYER = builder.defineInRange("Turret limit per player", () -> 10, 1, 300);
            DRONE_LIMIT_PER_PLAYER = builder.defineInRange("Drone limit per player", () -> 10, 1, 300);
            return builder.build();
        }).getRight());
        eventBus.addListener(this::registerAttributes);
        eventBus.addListener(this::registerNetwork);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::generateData);
        eventBus.addListener(this::sendMessage);
        eventBus.addListener(this::processMessage);
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.COBBLE_TURRET.get())), Turret.createDefaultAttributes().add(Attributes.FOLLOW_RANGE, (double)((Integer)COBBLE_TURRET_RANGE.get()).intValue()).add(Attributes.ARMOR, (double)((Integer)COBBLE_TURRET_ARMOR.get()).intValue()).add(Attributes.MAX_HEALTH, (double)((Integer)COBBLE_TURRET_HEALTH.get()).intValue()).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.FIRE_BALL_TURRET.get())), Turret.createDefaultAttributes().add(Attributes.FOLLOW_RANGE, (double)((Integer)FIREBALL_TURRET_RANGE.get()).intValue()).add(Attributes.MAX_HEALTH, (double)((Integer)FIREBALL_TURRET_HEALTH.get()).intValue()).add(Attributes.ARMOR, (double)((Integer)FIREBALL_TURRET_ARMOR.get()).intValue()).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.ARROW_TURRET.get())), Turret.createDefaultAttributes().add(Attributes.ARMOR, (double)((Integer)ARROW_TURRET_ARMOR.get()).intValue()).add(Attributes.MAX_HEALTH, (double)((Integer)ARROW_TURRET_HEALTH.get()).intValue()).add(Attributes.FOLLOW_RANGE, (double)((Integer)ARROW_TURRET_RANGE.get()).intValue()).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.BULLET_TURRET.get())), Turret.createDefaultAttributes().add(Attributes.FOLLOW_RANGE, (double)((Integer)BULLET_TURRET_RANGE.get()).intValue()).add(Attributes.ARMOR, (double)((Integer)BULLET_TURRET_ARMOR.get()).intValue()).add(Attributes.MAX_HEALTH, (double)((Integer)BULLET_TURRET_HEALTH.get()).intValue()).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.BRICK_TURRET.get())), Turret.createDefaultAttributes().add(Attributes.MAX_HEALTH, (double)((Integer)BRICK_TURRET_HEALTH.get()).intValue()).add(Attributes.ARMOR, (double)((Integer)BRICK_TURRET_ARMOR.get()).intValue()).add(Attributes.FOLLOW_RANGE, (double)((Integer)BRICK_TURRET_RANGE.get()).intValue()).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.GAUSS_TURRET.get())), Turret.createDefaultAttributes().add(Attributes.FOLLOW_RANGE, (double)((Integer)GAUSS_TURRET_RANGE.get()).intValue()).add(Attributes.ARMOR, (double)((Integer)GAUSS_TURRET_ARMOR.get()).intValue()).add(Attributes.MAX_HEALTH, (double)((Integer)GAUSS_TURRET_HEALTH.get()).intValue()).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.COBBLE_DRONE.get())), Drone.createDefaultAttributes().add(Attributes.MAX_HEALTH, (double)((Integer)COBBLE_TURRET_HEALTH.get()).intValue() * 0.83).add(Attributes.ARMOR, (double)((Integer)COBBLE_TURRET_ARMOR.get()).intValue() * 0.34).add(Attributes.FOLLOW_RANGE, (double)((Integer)COBBLE_TURRET_RANGE.get() - 5)).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.FIREBALL_DRONE.get())), Drone.createDefaultAttributes().add(Attributes.MAX_HEALTH, (double)((Integer)FIREBALL_TURRET_HEALTH.get()).intValue() * 0.83).add(Attributes.ARMOR, (double)((Integer)FIREBALL_TURRET_ARMOR.get()).intValue() * 0.34).add(Attributes.FOLLOW_RANGE, (double)((Integer)FIREBALL_TURRET_RANGE.get() - 5)).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.ARROW_DRONE.get())), Drone.createDefaultAttributes().add(Attributes.MAX_HEALTH, (double)((Integer)ARROW_TURRET_HEALTH.get()).intValue() * 0.83).add(Attributes.ARMOR, (double)((Integer)ARROW_TURRET_ARMOR.get()).intValue() * 0.34).add(Attributes.FOLLOW_RANGE, (double)((Integer)ARROW_TURRET_RANGE.get() - 5)).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.BULLET_DRONE.get())), Drone.createDefaultAttributes().add(Attributes.MAX_HEALTH, (double)((Integer)BULLET_TURRET_HEALTH.get()).intValue() * 0.83).add(Attributes.ARMOR, (double)((Integer)BULLET_TURRET_ARMOR.get()).intValue() * 0.34).add(Attributes.FOLLOW_RANGE, (double)((Integer)BULLET_TURRET_RANGE.get() - 5)).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.BRICK_DRONE.get())), Drone.createDefaultAttributes().add(Attributes.MAX_HEALTH, (double)((Integer)BRICK_TURRET_HEALTH.get()).intValue() * 0.83).add(Attributes.ARMOR, (double)((Integer)BRICK_TURRET_ARMOR.get()).intValue() * 0.34).add(Attributes.FOLLOW_RANGE, (double)((Integer)BRICK_TURRET_RANGE.get() - 5)).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.GAUSS_DRONE.get())), Drone.createDefaultAttributes().add(Attributes.MAX_HEALTH, (double)((Integer)GAUSS_TURRET_HEALTH.get()).intValue() * 0.83).add(Attributes.ARMOR, (double)((Integer)GAUSS_TURRET_ARMOR.get()).intValue() * 0.34).add(Attributes.FOLLOW_RANGE, (double)((Integer)GAUSS_TURRET_RANGE.get() - 5)).build());
        event.put(Functions.cast((EntityType)((EntityType)KTEntities.STORAGE_DRONE.get())), Drone.createDefaultAttributes().add(Attributes.MAX_HEALTH, (double)((Integer)STORAGE_DRONE_HEALTH.get()).intValue()).add(Attributes.ARMOR, (double)((Integer)STORAGE_DRONE_ARMOR.get()).intValue()).build());
    }

    private void registerNetwork(RegisterPayloadHandlersEvent event) {
        event.registrar("2").playToServer(AddPlayerException.TYPE, AddPlayerException.STREAM_CODEC, (payload, context) -> {
            Level serverLevel = context.player().level();
            Entity entity = serverLevel.getEntity(payload.turret());
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.addPlayerToExceptions(payload.playerName());
            }
        }).playToClient(AmmoCheck.TYPE, AmmoCheck.STREAM_CODEC, (payload, context) -> {
            Level level = context.player().level();
            Entity entity = level.getEntity(payload.unit());
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.noAmmo = payload.noAmmo();
            }
        }).playToServer(ClaimTurret.TYPE, ClaimTurret.STREAM_CODEC, (payload, context) -> {
            Level level = context.player().level();
            Entity entity = level.getEntity(payload.turret());
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setOwner(payload.person());
                turret.setOwnerName(context.player().getName().getString());
            }
        }).playToServer(CompressItems.TYPE, CompressItems.STREAM_CODEC, (payload, context) -> {
            Level level = context.player().level();
            Entity entity = level.getEntity(payload.drone());
            if (entity instanceof StorageDrone) {
                StorageDrone storageDrone = (StorageDrone)entity;
                HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>(27);
                for (ItemStack item2 : storageDrone.itemHandler.getItems()) {
                    itemCounts.merge(item2.getItem(), item2.getCount(), Integer::sum);
                }
                itemCounts.forEach((item, integer) -> {
                    ItemStack stack = new ItemStack((ItemLike)item);
                    ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>(9);
                    if (integer > 8) {
                        for (int i = 0; i < 9; ++i) {
                            tempStacks.add(new ItemStack((ItemLike)item));
                        }
                    }
                    if (!tempStacks.isEmpty()) {
                        CraftingInput craftingContainer = CraftingInput.of((int)3, (int)3, tempStacks);
                        level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingContainer, level).ifPresent(craftingRecipe -> {
                            ItemStack out = ((CraftingRecipe)craftingRecipe.value()).assemble((RecipeInput)craftingContainer, (HolderLookup.Provider)level.registryAccess());
                            if (out.isItemEnabled(level.enabledFeatures()) && !out.isEmpty() && out.getCount() == 1) {
                                CraftingInput reverse = CraftingInput.of((int)1, (int)1, List.of(out));
                                level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)reverse, level).ifPresent(craftingRecipe1 -> {
                                    ItemStack reverseOut = ((CraftingRecipe)craftingRecipe1.value()).assemble((RecipeInput)reverse, (HolderLookup.Provider)level.registryAccess());
                                    if (reverseOut.is(item)) {
                                        int toMake = integer / 9;
                                        int toConsume = toMake * 9;
                                        for (int j = 0; j < toConsume; ++j) {
                                            NeoforgeFunctions.extractItems((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)new ItemStack((ItemLike)item), (boolean)false);
                                        }
                                        for (int i = 0; i < toMake; ++i) {
                                            if (!NeoforgeFunctions.canInsertItem((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)out)) continue;
                                            NeoforgeFunctions.insertItem((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)out.copy());
                                        }
                                    }
                                });
                            }
                        });
                        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(4);
                        stacks.add(stack);
                        stacks.add(stack);
                        stacks.add(stack);
                        stacks.add(stack);
                        CraftingInput i2x2 = CraftingInput.of((int)2, (int)2, stacks);
                        level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)i2x2, level).ifPresent(craftingRecipe -> {
                            ItemStack out = ((CraftingRecipe)craftingRecipe.value()).assemble((RecipeInput)i2x2, (HolderLookup.Provider)level.registryAccess());
                            if (out.isItemEnabled(level.enabledFeatures()) && !out.isEmpty() && out.getCount() == 1) {
                                CraftingMenu craftingMenuReverse = new CraftingMenu(-2, context.player().getInventory());
                                TransientCraftingContainer craftingContainerReverse = new TransientCraftingContainer((AbstractContainerMenu)craftingMenuReverse, 2, 2);
                                craftingContainerReverse.setItem(0, out);
                                level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)i2x2, level).ifPresent(craftingRecipe1 -> {
                                    int toMake = integer / 4;
                                    int toConsume = toMake * 4;
                                    for (int j = 0; j < toConsume; ++j) {
                                        NeoforgeFunctions.extractItems((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)new ItemStack((ItemLike)item), (boolean)false);
                                    }
                                    for (int i = 0; i < toMake; ++i) {
                                        if (!NeoforgeFunctions.canInsertItem((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)out)) continue;
                                        NeoforgeFunctions.insertItem((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)out.copy());
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }).playToServer(DismantleTurret.TYPE, DismantleTurret.STREAM_CODEC, (payload, context) -> {
            ServerLevel level = (ServerLevel)context.player().level();
            Entity entity = level.getEntity(payload.id());
            if (entity instanceof Turret) {
                UUID uuid = context.player().getUUID();
                ItemStack egg = new ItemStack((ItemLike)Objects.requireNonNull(SpawnEggItem.byId((EntityType)entity.getType())));
                CompoundTag compoundTag = new CompoundTag();
                entity.save(compoundTag);
                egg.set(KTDataComponents.ATTACHED_NBT, (Object)new KTDataComponents.AttachedNBT(compoundTag));
                level.addFreshEntity((Entity)new ItemEntity((Level)level, entity.getX(), entity.getY(), entity.getZ(), egg));
                entity.discard();
                UnitLimits unitLimits = (UnitLimits)level.getDataStorage().computeIfAbsent(new SavedData.Factory(UnitLimits::new, UnitLimits::load, null), "k-turrets-unit-limits");
                if (entity instanceof Drone) {
                    unitLimits.setDroneCount(uuid, unitLimits.getDroneCount(uuid) - 1);
                } else {
                    unitLimits.setTurretCount(uuid, unitLimits.getTurretCount(uuid) - 1);
                }
                if (entity instanceof Drone) {
                    Drone drone = (Drone)entity;
                    if (!Functions.findItem((Item)((Item)KTItems.LIGHT_UPGRADE.get()), (ItemContainer)drone.upgrades).isEmpty()) {
                        level.removeBlock(drone.previousPosition, false);
                    }
                }
            }
        }).playToServer(MagnetFilterMode.TYPE, MagnetFilterMode.STREAM_CODEC, (payload, context) -> {
            ItemStack held = context.player().getInventory().getSelected();
            if (held.is((Item)KTItems.MAGNET_UPGRADE.get())) {
                held.set(KTDataComponents.MAGNET_MODE, (Object)new KTDataComponents.MagnetMode(payload.mode()));
            }
        }).playToClient(PickupParticles.TYPE, PickupParticles.STREAM_CODEC, (payload, context) -> {
            Level level = context.player().level();
            level.addParticle((ParticleOptions)KTurrets.PARTICLE, payload.x(), payload.y(), payload.z(), 0.0, 0.0, 0.0);
        }).playToServer(RemovePlayerException.TYPE, RemovePlayerException.STREAM_CODEC, (payload, context) -> {
            Level level = context.player().level();
            Entity entity = level.getEntity(payload.turret());
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.removePlayerFromExceptions(payload.name());
            }
        }).playToServer(SetBehavior.TYPE, SetBehavior.STREAM_CODEC, (payload, context) -> {
            Level level = context.player().level();
            Entity entity = level.getEntity(payload.drone());
            if (entity instanceof Drone) {
                Drone drone = (Drone)entity;
                drone.setBehavior(payload.behavior());
            }
        }).playToServer(SetMagnetState.TYPE, SetMagnetState.STREAM_CODEC, (payload, context) -> {
            Level level = context.player().level();
            Entity entity = level.getEntity(payload.drone());
            if (entity instanceof StorageDrone) {
                StorageDrone storageDrone = (StorageDrone)entity;
                storageDrone.setMagnetActive(payload.state());
            }
        }).playToServer(SetProtectPlayer.TYPE, SetProtectPlayer.STREAM_CODEC, (payload, context) -> {
            Level level = context.player().level();
            Entity entity = level.getEntity(payload.unit());
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setProtectOwner(payload.protect());
            }
        }).playToServer(SetRefillInventory.TYPE, SetRefillInventory.STREAM_CODEC, (payload, context) -> {
            Entity entity = context.player().level().getEntity(payload.unit());
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setRefillInventory(payload.refill());
            }
        }).playToServer(SetTarget.TYPE, SetTarget.STREAM_CODEC, (payload, context) -> {
            Entity entity = context.player().level().getEntity(payload.unit());
            if (entity instanceof Turret) {
                Turret t = (Turret)entity;
                List<EntityType<?>> targets = Turret.decodeTargets(t.getTargets());
                if (payload.state()) {
                    targets.add((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)payload.id())));
                } else {
                    targets.remove(BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)payload.id())));
                }
                t.setTargets(Turret.encodeTargets(targets));
            }
        }).playToServer(ToggleMobility.TYPE, ToggleMobility.STREAM_CODEC, (payload, context) -> {
            Entity entity = context.player().level().getEntity(payload.unit());
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setMoveable(payload.mobility());
            }
        }).playToServer(TogglePlayerProtection.TYPE, TogglePlayerProtection.STREAM_CODEC, (payload, context) -> {
            Entity entity = context.player().level().getEntity(payload.unit());
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setProtectionFromPlayers(payload.protect());
            }
        }).playToServer(TurretTargets.TYPE, TurretTargets.STREAM_CODEC, (payload, context) -> {
            Entity entity = context.player().level().getEntity(payload.turret());
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setTargets(payload.targets());
            }
        });
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (object, context) -> new ComponentItemHandler((MutableDataComponentHolder)object, DataComponents.CONTAINER, 27), new ItemLike[]{(ItemLike)KTItems.MAGNET_UPGRADE.get()});
    }

    private void generateData(GatherDataEvent event) {
        HolderLookup.Provider registries;
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        try {
            registries = (HolderLookup.Provider)lookupProvider.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        HolderLookup.Provider finalRegistries = registries;
        dataGenerator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(provider -> new BlockLootSubProvider(this, Set.of(), FeatureFlags.REGISTRY.allFlags(), finalRegistries){

            protected void generate() {
                this.add((Block)KTBlocks.TITANIUM_ORE.get(), this.createOreDrop((Block)KTBlocks.TITANIUM_ORE.get(), (Item)KTItems.RAW_TITANIUM.get()));
                this.add((Block)KTBlocks.DEEPSLATE_TITANIUM_ORE.get(), this.createOreDrop((Block)KTBlocks.DEEPSLATE_TITANIUM_ORE.get(), (Item)KTItems.RAW_TITANIUM.get()));
                this.dropSelf((Block)KTBlocks.RELOADER.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return BuiltInRegistries.BLOCK.stream().filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals("k_turrets")).toList();
            }
        }, LootContextParamSets.BLOCK)), lookupProvider));
        BlockTagsProvider blockTagsProvider = new BlockTagsProvider(this, packOutput, lookupProvider, "k_turrets", event.getExistingFileHelper()){

            protected void addTags(HolderLookup.Provider provider) {
            }
        };
        dataGenerator.addProvider(true, (DataProvider)blockTagsProvider);
        ItemTagsProvider itemTagsProvider = new ItemTagsProvider(this, packOutput, lookupProvider, blockTagsProvider.contentsGetter()){

            protected void addTags(HolderLookup.Provider provider) {
                this.tag(KTurrets.REPAIR_ITEMS).add((Object)((Item)KTItems.TITANIUM_INGOT.get()));
            }
        };
        dataGenerator.addProvider(true, (DataProvider)itemTagsProvider);
    }

    private void sendMessage(InterModEnqueueEvent event) {
        KTEntities.ENTITY_MAP.forEach((string, entityTypeSupplier) -> InterModComms.sendTo((String)"carryon", (String)"blacklistEntity", () -> string));
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.ARROW_TURRET.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.ARROW_DRONE.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.BRICK_DRONE.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.BRICK_TURRET.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.BULLET_DRONE.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.BULLET_TURRET.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.COBBLE_DRONE.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.COBBLE_TURRET.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.FIREBALL_DRONE.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.FIREBALL_TURRET.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.GAUSS_DRONE.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.GAUSS_TURRET.getId());
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> KTMenus.STORAGE_DRONE.getId());
    }

    private void processMessage(InterModProcessEvent event) {
        InterModComms.getMessages((String)"k_turrets").forEach(imcMessage -> {
            Object message = imcMessage.messageSupplier().get();
            if (message instanceof String) {
                String s = (String)message;
                String method = imcMessage.method();
                if (method.equals("addTargetException")) {
                    if (BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)s)).isPresent()) {
                        ((List)TARGET_EXCEPTIONS.get()).add((String)Functions.cast((Object)s));
                        KTurrets.LOGGER.info("Added {} to exceptions", (Object)s);
                    } else {
                        KTurrets.LOGGER.warn("Got request to add {} to exceptions, but it doesn't exist", (Object)s);
                    }
                } else if (method.equals("addDefaultTarget")) {
                    if (BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)s)).isPresent()) {
                        DEFAULT_TARGETS.add(s);
                        KTurrets.LOGGER.info("Added {} to targets", (Object)s);
                    } else {
                        KTurrets.LOGGER.warn("Got request to add {} to targets, but it doesn't exist", (Object)s);
                    }
                }
            }
        });
    }

    static {
        BLOCKS = DeferredRegister.createBlocks((String)"k_turrets");
        ITEMS = DeferredRegister.createItems((String)"k_turrets");
        ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"k_turrets");
        MENUS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"k_turrets");
        TABS = DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"k_turrets");
        DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"k_turrets");
        BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"k_turrets");
        DEFAULT_TARGETS = new ArrayList();
    }
}

