/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.google.common.collect.ArrayListMultimap;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.satako.platform.Services;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public class KTurretsServer {
    public static void showAmmo() {
        DefaultedRegistry items = BuiltInRegistries.ITEM;
        KTurrets.LOGGER.info("Cobble unit ammo:");
        items.getTag(KTurrets.COBBLE_UNIT_AMMO_TAG).ifPresent(item -> item.forEach(itemHolder -> KTurrets.LOGGER.info(itemHolder.getRegisteredName())));
        KTurrets.LOGGER.info("");
        KTurrets.LOGGER.info("Bullet unit ammo:");
        items.getTag(KTurrets.BULLET_UNIT_AMMO_TAG).ifPresent(item -> item.forEach(itemHolder -> KTurrets.LOGGER.info(itemHolder.getRegisteredName())));
        KTurrets.LOGGER.info("");
        KTurrets.LOGGER.info("Brick unit ammo:");
        items.getTag(KTurrets.BRICK_UNIT_AMMO_TAG).ifPresent(item -> item.forEach(itemHolder -> KTurrets.LOGGER.info(itemHolder.getRegisteredName())));
        KTurrets.LOGGER.info("");
        KTurrets.LOGGER.info("Gauss unit ammo:");
        items.getTag(KTurrets.GAUSS_UNIT_AMMO_TAG).ifPresent(item -> item.forEach(itemHolder -> KTurrets.LOGGER.info(itemHolder.getRegisteredName())));
        KTurrets.LOGGER.info("");
        KTurrets.LOGGER.info("Fireball unit ammo:");
        items.getTag(KTurrets.FIREBALL_UNIT_AMMO).ifPresent(item -> item.forEach(itemHolder -> KTurrets.LOGGER.info(itemHolder.getRegisteredName())));
        KTurrets.LOGGER.info("");
        KTurrets.LOGGER.info("Arrow unit ammo:");
        items.getTag(KTurrets.ARROW_UNIT_AMMO_TAG).ifPresent(item -> item.forEach(itemHolder -> KTurrets.LOGGER.info(itemHolder.getRegisteredName())));
    }

    static void storeUnitDeaths(MinecraftServer server) {
        if (server.isDedicatedServer()) {
            String s = KTurrets.GSON.toJson(KTurrets.serverUnitDeaths, KTurrets.TYPE);
            try {
                Path path = server.getServerDirectory().resolve(Path.of("k_turrets.json", new String[0]));
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.createFile(path, new FileAttribute[0]);
                }
                Files.writeString(path, (CharSequence)s, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static void notifyPlayer(Player player) {
        String uuid;
        if (Services.PLATFORM.isServer() && player.level().getServer().isDedicatedServer() && KTurrets.serverUnitDeaths.containsKey((Object)(uuid = player.getUUID().toString()))) {
            player.displayClientMessage((Component)Component.literal((String)"[K-Turrets] Some of your units were destroyed while you were offline"), false);
            KTurrets.serverUnitDeaths.get((Object)uuid).forEach(s -> player.displayClientMessage((Component)Component.literal((String)s), false));
            KTurrets.serverUnitDeaths.removeAll((Object)uuid);
        }
    }

    public static void loadUnitDeaths(MinecraftServer minecraftServer) {
        if (minecraftServer.isDedicatedServer()) {
            Path dir = minecraftServer.getServerDirectory();
            Path file = Path.of(dir.toString(), "k_turrets.json");
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    KTurrets.serverUnitDeaths = (ArrayListMultimap)KTurrets.GSON.fromJson((Reader)new FileReader(file.toFile()), KTurrets.TYPE);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

