/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class MultimapAdapter
implements JsonDeserializer<Multimap<String, ?>>,
JsonSerializer<Multimap<String, ?>> {
    public Multimap<String, ?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        ArrayListMultimap result = ArrayListMultimap.create();
        Map map = (Map)context.deserialize(json, this.multimapTypeToMapType(type));
        for (Map.Entry e : map.entrySet()) {
            Collection value = (Collection)e.getValue();
            result.putAll((Object)((String)e.getKey()), (Iterable)value);
        }
        return result;
    }

    public JsonElement serialize(Multimap<String, ?> src, Type type, JsonSerializationContext context) {
        Map map = src.asMap();
        return context.serialize((Object)map);
    }

    private <V> Type multimapTypeToMapType(Type type) {
        Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
        assert (typeArguments.length == 2);
        TypeToken mapTypeToken = new TypeToken<Map<String, Collection<V>>>(){}.where(new TypeParameter<V>(this){}, TypeToken.of((Type)typeArguments[1]));
        return mapTypeToken.getType();
    }
}

