/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.drones.StorageDrone;
import dev.buildtool.kturrets.menus.ReloaderMenu;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.registries.KTBlockEntities;
import dev.buildtool.satako.BlockEntity2;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ReloaderBlockEntity
extends BlockEntity2
implements MenuProvider {
    public ItemContainer ammo = Services.PLATFORM.createReloaderInventory(this);

    public ReloaderBlockEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)KTBlockEntities.RELOADER.get(), position, blockState);
    }

    static <T extends BlockEntity> void work(Level level, BlockPos pos, BlockState blockState, T t) {
        ReloaderBlockEntity reloaderBlockEntity = (ReloaderBlockEntity)t;
        List drones = level.getEntitiesOfClass(Drone.class, new AABB(pos).inflate(6.0));
        drones.forEach(drone -> {
            if (!(drone instanceof StorageDrone)) {
                ItemContainer itemHandler = drone.getContainedItems().get(0);
                block0: for (int i = 0; i < reloaderBlockEntity.ammo.getSlotCount(); ++i) {
                    ItemStack ammo = reloaderBlockEntity.ammo.extractItem(i, 64, true);
                    if (ammo.isEmpty()) continue;
                    for (int j = 0; j < itemHandler.getSlotCount(); ++j) {
                        if (!itemHandler.isItemValid(j, ammo)) continue;
                        ItemStack out = Functions.insertItemStacked((ItemContainer)itemHandler, (ItemStack)ammo.copy(), (boolean)false);
                        ammo.setCount(out.getCount());
                        if (!ammo.isEmpty()) break block0;
                        reloaderBlockEntity.ammo.extractItem(i, 64, false);
                        break block0;
                    }
                }
            }
        });
    }

    protected void saveAdditional(CompoundTag p_187471_, HolderLookup.Provider provider) {
        super.saveAdditional(p_187471_, provider);
        p_187471_.put("Ammo", (Tag)this.ammo.serializeNBT(provider));
    }

    public void loadAdditional(CompoundTag p_155245_, HolderLookup.Provider provider) {
        super.loadAdditional(p_155245_, provider);
        this.ammo.deserializeNBT(provider, p_155245_.getCompound("Ammo"));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"k_turrets.reloader");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
        friendlyByteBuf.writeBlockPos(this.getBlockPos());
        return new ReloaderMenu(i, inventory, friendlyByteBuf, this.getBlockPos());
    }
}

