/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.KTurretsServer;
import dev.buildtool.kturrets.Turret;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@EventBusSubscriber
public class SharedEvents {
    @SubscribeEvent
    public static void defendPlayer(LivingDamageEvent.Post event) {
        KTurrets.setTargets(event.getEntity(), event.getSource());
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppingEvent serverStoppingEvent) {
        MinecraftServer server = serverStoppingEvent.getServer();
        KTurretsServer.storeUnitDeaths(server);
    }

    @SubscribeEvent
    public static void notifyPlayer(PlayerEvent.PlayerLoggedInEvent playerLoggedInEvent) {
        Player player = playerLoggedInEvent.getEntity();
        KTurretsServer.notifyPlayer(player);
    }

    @SubscribeEvent
    public static void showAmmo(ServerStartedEvent serverStartedEvent) {
        KTurretsServer.showAmmo();
        KTurretsServer.loadUnitDeaths(serverStartedEvent.getServer());
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent lootTableLoadEvent) {
        LootTable lootTable = lootTableLoadEvent.getTable();
        ResourceLocation lootTableName = lootTableLoadEvent.getName();
        KTurrets.analyzeTables(lootTableName, lootTable);
    }

    @SubscribeEvent
    public static void preventDrowning(LivingBreatheEvent event) {
        if (event.getEntity() instanceof Turret) {
            event.setCanBreathe(true);
        }
    }

    @SubscribeEvent
    public static void dropExp(LivingDeathEvent livingDeathEvent) {
        LivingEntity entity;
        Level level;
        if (!livingDeathEvent.isCanceled() && (level = (entity = livingDeathEvent.getEntity()).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity deathCauser = livingDeathEvent.getSource().getEntity();
            KTurrets.dropExperienceAndItems(serverLevel, deathCauser, entity);
        }
    }
}

