/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.UnitLimits;
import dev.buildtool.kturrets.drones.StorageDrone;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.registries.KTDataComponents;
import dev.buildtool.kturrets.registries.KTItems;
import dev.buildtool.kturrets.tasks.RevengeTask;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import dev.buildtool.satako.UniqueList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public abstract class Turret
extends PathfinderMob
implements RangedAttackMob,
MenuProvider {
    private static final EntityDataAccessor<CompoundTag> TARGETS = SynchedEntityData.defineId(Turret.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(Turret.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<Boolean> MOVEABLE = SynchedEntityData.defineId(Turret.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PROTECTION_FROM_PLAYERS = SynchedEntityData.defineId(Turret.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> TEAM = SynchedEntityData.defineId(Turret.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<CompoundTag> IGNORED_PLAYERS = SynchedEntityData.defineId(Turret.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    protected static final EntityDataAccessor<Boolean> REFILL_INVENTORY = SynchedEntityData.defineId(Turret.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.defineId(Turret.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public boolean noAmmo;
    private static final EntityDataAccessor<Boolean> PROTECT_OWNER = SynchedEntityData.defineId(Turret.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public ItemContainer upgrades = Services.PLATFORM.createTurretUpgrades();
    public Predicate<LivingEntity> alienPlayers = livingEntity -> {
        if (this.getOwner().isPresent() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag compoundTag = (CompoundTag)this.entityData.get(IGNORED_PLAYERS);
            for (String key : compoundTag.getAllKeys()) {
                if (!compoundTag.getString(key).equals(player.getName().getString())) continue;
                return false;
            }
            return !player.getUUID().equals(this.getOwner().get()) && !this.isAlliedTo((Entity)player);
        }
        return false;
    };

    public Turret(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createDefaultAttributes() {
        return Turret.createLivingAttributes().add(Attributes.FLYING_SPEED, 0.27).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.MAX_HEALTH, 60.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 3.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        CompoundTag compoundNBT = new CompoundTag();
        ArrayList<EntityType> targets = new ArrayList<EntityType>(BuiltInRegistries.ENTITY_TYPE.stream().filter(entityType1 -> !entityType1.getCategory().isFriendly()).toList());
        List<String> exceptions = Services.PLATFORM.getDefaultExceptions();
        targets.removeIf(entityType -> exceptions.contains(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString()));
        for (int i = 0; i < targets.size(); ++i) {
            compoundNBT.putString("Target#" + i, BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)targets.get(i))).toString());
        }
        Services.PLATFORM.getDefaultTargets().stream().map(string -> (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)string))).forEach(targets::add);
        compoundNBT.putInt("Count", targets.size());
        builder.define(TARGETS, (Object)compoundNBT);
        builder.define(OWNER, Optional.empty());
        builder.define(MOVEABLE, (Object)false);
        builder.define(PROTECTION_FROM_PLAYERS, (Object)false);
        builder.define(TEAM, (Object)"");
        builder.define(OWNER_NAME, (Object)"");
        builder.define(IGNORED_PLAYERS, (Object)new CompoundTag());
        builder.define(REFILL_INVENTORY, (Object)true);
        builder.define(PROTECT_OWNER, (Object)true);
    }

    public String getAutomaticTeam() {
        return (String)this.entityData.get(TEAM);
    }

    public void setTeamAutomatically(String team) {
        this.entityData.set(TEAM, (Object)team);
    }

    public void setTargets(CompoundTag compoundNBT) {
        this.entityData.set(TARGETS, (Object)compoundNBT);
    }

    public CompoundTag getTargets() {
        return (CompoundTag)this.entityData.get(TARGETS);
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.entityData.get(OWNER);
    }

    public void setOwner(UUID owner) {
        this.entityData.set(OWNER, Optional.of(owner));
    }

    public void setMoveable(boolean moveable) {
        this.entityData.set(MOVEABLE, (Object)moveable);
    }

    public boolean isMoveable() {
        return (Boolean)this.entityData.get(MOVEABLE);
    }

    public void setProtectionFromPlayers(boolean protect) {
        this.entityData.set(PROTECTION_FROM_PLAYERS, (Object)protect);
    }

    public boolean isProtectingFromPlayers() {
        return (Boolean)this.entityData.get(PROTECTION_FROM_PLAYERS);
    }

    public void setRefillInventory(boolean b) {
        this.entityData.set(REFILL_INVENTORY, (Object)b);
    }

    public boolean isRefillingInventory() {
        return (Boolean)this.entityData.get(REFILL_INVENTORY);
    }

    public boolean isProtectingOwner() {
        return (Boolean)this.entityData.get(PROTECT_OWNER);
    }

    public void setProtectOwner(boolean p) {
        this.entityData.set(PROTECT_OWNER, (Object)p);
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new RevengeTask(this, new Class[0]));
    }

    public boolean attackable() {
        return false;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return Collections.emptyList();
    }

    public ItemStack getItemBySlot(EquipmentSlot p_184582_1_) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot p_184201_1_, ItemStack p_184201_2_) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public double getRange() {
        return this.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    protected float getHealthRecovered() {
        return this.getMaxHealth() / 6.0f;
    }

    protected InteractionResult mobInteract(Player playerEntity, InteractionHand interactionHand) {
        ItemStack itemInHand = playerEntity.getItemInHand(interactionHand);
        if (this.getHealth() < this.getMaxHealth() && playerEntity.isCrouching() && itemInHand.is(KTurrets.REPAIR_ITEMS)) {
            this.heal(this.getHealthRecovered());
            itemInHand.shrink(1);
            return InteractionResult.SUCCESS;
        }
        if (this.canUse(playerEntity)) {
            if (playerEntity.getTeam() != null) {
                this.setTeamAutomatically(playerEntity.getTeam().getName());
            } else {
                this.setTeamAutomatically("");
            }
            if (this.getOwnerName().isEmpty()) {
                this.setOwnerName(playerEntity.getName().getString());
            }
            if (itemInHand.getItem() == KTItems.TARGET_COPIER.get() && !(this instanceof StorageDrone)) {
                if (playerEntity.isCrouching()) {
                    CompoundTag compoundTag = new CompoundTag();
                    compoundTag.put("Filters", (Tag)this.getTargets());
                    CompoundTag ignoredPlayers = (CompoundTag)this.entityData.get(IGNORED_PLAYERS);
                    compoundTag.put("Ignored players", (Tag)ignoredPlayers);
                    itemInHand.set(KTDataComponents.ATTACHED_NBT, (Object)new KTDataComponents.AttachedNBT(compoundTag));
                    playerEntity.displayClientMessage((Component)Component.translatable((String)"k_turrets.filters.stored"), true);
                } else if (itemInHand.has(KTDataComponents.ATTACHED_NBT)) {
                    CompoundTag compoundNBT = ((KTDataComponents.AttachedNBT)itemInHand.get(KTDataComponents.ATTACHED_NBT)).compoundTag();
                    this.setTargets(compoundNBT.getCompound("Filters"));
                    CompoundTag ignoredPlayers = compoundNBT.getCompound("Ignored players");
                    this.entityData.set(IGNORED_PLAYERS, (Object)ignoredPlayers);
                    playerEntity.displayClientMessage((Component)Component.translatable((String)"k_turrets.filters.copied"), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (this instanceof StorageDrone) {
                if (playerEntity.isShiftKeyDown()) {
                    if (this.level().isClientSide) {
                        Services.PLATFORM.openOptionsScreen(this);
                    }
                } else {
                    Services.PLATFORM.openScreen(playerEntity, this);
                }
            } else if (playerEntity.isShiftKeyDown()) {
                if (this.level().isClientSide) {
                    Services.PLATFORM.openOptionsScreen(this);
                }
            } else if (!this.level().isClientSide) {
                Services.PLATFORM.openScreen(playerEntity, this);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.level().isClientSide) {
            if (this instanceof Drone) {
                if (this.getOwnerName().isEmpty()) {
                    playerEntity.displayClientMessage((Component)Component.translatable((String)"k_turrets.drone.not.yours"), true);
                } else {
                    playerEntity.displayClientMessage((Component)Component.translatable((String)"k_turrets.drone.belongs.to").append(" " + this.getOwnerName()), true);
                }
            } else if (this.getOwnerName().isEmpty()) {
                playerEntity.displayClientMessage((Component)Component.translatable((String)"k_turrets.turret.not.yours"), true);
            } else {
                playerEntity.displayClientMessage((Component)Component.translatable((String)"k_turrets.turret.belongs.to").append(" " + this.getOwnerName()), true);
            }
        }
        return InteractionResult.FAIL;
    }

    protected boolean canUse(Player playerEntity) {
        return this.getOwner().isEmpty() || this.getOwner().get().equals(playerEntity.getUUID());
    }

    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.put("Targets", (Tag)this.getTargets());
        this.getOwner().ifPresent(uuid1 -> compoundNBT.putUUID("Owner", uuid1));
        compoundNBT.putBoolean("Mobile", this.isMoveable());
        compoundNBT.putBoolean("Player protection", this.isProtectingFromPlayers());
        compoundNBT.putString("Team", this.getAutomaticTeam());
        compoundNBT.putString("Owner name", this.getOwnerName());
        compoundNBT.put("Exceptions", (Tag)this.entityData.get(IGNORED_PLAYERS));
        compoundNBT.putBoolean("Refill inventory", this.isRefillingInventory());
        compoundNBT.putBoolean("Protect owner", this.isProtectingOwner());
        compoundNBT.put("Upgrades", (Tag)this.upgrades.serializeNBT((HolderLookup.Provider)this.registryAccess()));
    }

    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        UUID uuid;
        super.readAdditionalSaveData(compoundNBT);
        this.setTargets(compoundNBT.getCompound("Targets"));
        if (compoundNBT.contains("Owner") && !(uuid = compoundNBT.getUUID("Owner")).equals(Util.NIL_UUID)) {
            this.setOwner(uuid);
        }
        this.setMoveable(compoundNBT.getBoolean("Mobile"));
        this.setProtectionFromPlayers(compoundNBT.getBoolean("Player protection"));
        this.setTeamAutomatically(compoundNBT.getString("Team"));
        if (compoundNBT.contains("Owner name")) {
            this.setOwnerName(compoundNBT.getString("Owner name"));
        }
        CompoundTag exceptions = compoundNBT.getCompound("Exceptions");
        this.entityData.set(IGNORED_PLAYERS, (Object)exceptions);
        this.setTeamAutomatically(compoundNBT.getString("Team"));
        this.setRefillInventory(compoundNBT.getBoolean("Refill inventory"));
        this.setProtectOwner(compoundNBT.getBoolean("Protect owner"));
        this.upgrades.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compoundNBT.getCompound("Upgrades"));
        this.upgrades.setSize(3);
    }

    public static List<EntityType<?>> decodeTargets(CompoundTag compoundNBT) {
        int count = compoundNBT.getInt("Count");
        ArrayList list = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            String next = compoundNBT.getString("Target#" + i);
            list.add((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)next)));
        }
        return list;
    }

    public static CompoundTag encodeTargets(List<EntityType<?>> list) {
        CompoundTag compoundNBT = new CompoundTag();
        for (int i = 0; i < list.size(); ++i) {
            EntityType<?> entityType = list.get(i);
            compoundNBT.putString("Target#" + i, BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
        }
        compoundNBT.putInt("Count", list.size());
        return compoundNBT;
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.getContainedItems().forEach(itemHandler -> itemHandler.getItems().forEach(stack -> Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)stack)));
        this.getOwner().ifPresent(uuid1 -> {
            if (!this.level().isClientSide) {
                Player player = this.level().getPlayerByUUID(uuid1);
                if (player != null) {
                    if (damageSource.getDirectEntity() != null) {
                        MutableComponent deathMessageA = this.getDisplayName().copy().append(" ").append((Component)Component.translatable((String)"k_turrets.was.destroyed.by").append(" ").append(damageSource.getDirectEntity().getDisplayName()).append(" ").append((Component)Component.translatable((String)"k_turrets.at").append(" " + (int)this.getX() + " " + (int)this.getY() + " " + (int)this.getZ())));
                        player.displayClientMessage((Component)deathMessageA, false);
                    } else if (damageSource.getEntity() != null) {
                        MutableComponent deathMessageB = this.getDisplayName().copy().append(" ").append((Component)Component.translatable((String)"k_turrets.was.destroyed.by").append(" ").append(damageSource.getEntity().getDisplayName()).append(" ").append((Component)Component.translatable((String)"k_turrets.at").append(" " + (int)this.getX() + " " + (int)this.getY() + " " + (int)this.getZ())));
                        player.displayClientMessage((Component)deathMessageB, false);
                    } else {
                        MutableComponent deathMessageC = damageSource.getLocalizedDeathMessage((LivingEntity)this).copy().append(" ").append((Component)Component.translatable((String)"k_turrets.at").append(" " + (int)this.getX() + " " + (int)this.getY() + " " + (int)this.getZ()));
                        player.displayClientMessage((Component)deathMessageC, false);
                    }
                }
                if (dev.buildtool.satako.platform.Services.PLATFORM.isServer()) {
                    ServerLevel serverLevel = (ServerLevel)this.level();
                    UnitLimits unitLimits = (UnitLimits)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(UnitLimits::new, UnitLimits::load, null), "k-turrets-unit-limits");
                    if (this instanceof Drone) {
                        unitLimits.setDroneCount(this.uuid, unitLimits.getDroneCount(this.uuid) - 1);
                    } else {
                        unitLimits.setTurretCount(this.uuid, unitLimits.getTurretCount(this.uuid) - 1);
                    }
                    if (player == null) {
                        if (damageSource.getDirectEntity() != null) {
                            MutableComponent deathMessageA = this.getDisplayName().copy().append(" ").append((Component)Component.translatable((String)"k_turrets.was.destroyed.by").append(" ").append(damageSource.getDirectEntity().getDisplayName()).append(" ").append((Component)Component.translatable((String)"k_turrets.at").append(" " + (int)this.getX() + " " + (int)this.getY() + " " + (int)this.getZ())));
                            KTurrets.serverUnitDeaths.put((Object)uuid1.toString(), (Object)deathMessageA.getString());
                        } else if (damageSource.getEntity() != null) {
                            MutableComponent deathMessageB = this.getDisplayName().copy().append(" ").append((Component)Component.translatable((String)"k_turrets.was.destroyed.by").append(" ").append(damageSource.getEntity().getDisplayName()).append(" ").append((Component)Component.translatable((String)"k_turrets.at").append(" " + (int)this.getX() + " " + (int)this.getY() + " " + (int)this.getZ())));
                            KTurrets.serverUnitDeaths.put((Object)uuid1.toString(), (Object)deathMessageB.getString());
                        } else {
                            MutableComponent deathMessageC = damageSource.getLocalizedDeathMessage((LivingEntity)this).copy().append(" ").append((Component)Component.translatable((String)"k_turrets.at").append(" " + (int)this.getX() + " " + (int)this.getY() + " " + (int)this.getZ()));
                            KTurrets.serverUnitDeaths.put((Object)uuid1.toString(), (Object)deathMessageC.getString());
                        }
                    }
                }
            }
        });
        Turret turret = this;
        if (turret instanceof Drone) {
            Drone drone = (Drone)turret;
            if (!Functions.findItem((Item)((Item)KTItems.LIGHT_UPGRADE.get()), (ItemContainer)drone.upgrades).isEmpty()) {
                this.level().removeBlock(drone.previousPosition, false);
            }
        }
    }

    public abstract List<ItemContainer> getContainedItems();

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_184601_1_) {
        return SoundEvents.SHIELD_BLOCK;
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        if (effectInstance.is(MobEffects.POISON) || effectInstance.is(MobEffects.HEAL) || effectInstance.is(MobEffects.HEALTH_BOOST) || effectInstance.is(MobEffects.REGENERATION) || effectInstance.is(MobEffects.WITHER) || effectInstance.is(MobEffects.HUNGER)) {
            return false;
        }
        return super.canBeAffected(effectInstance);
    }

    public boolean canBeCollidedWith() {
        return !this.isMoveable();
    }

    public boolean isPushable() {
        return this.isMoveable();
    }

    public void knockback(double p_147241_, double p_147242_, double p_147243_) {
        if (this.isMoveable()) {
            super.knockback(p_147241_, p_147242_, p_147243_);
        }
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.DRAGON_FIREBALL_EXPLODE;
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    public boolean isAlliedTo(Entity target) {
        Turret turret;
        return super.isAlliedTo(target) || this.getOwner().isPresent() && target.getUUID().equals(this.getOwner().get()) || target instanceof Turret && (turret = (Turret)target).getOwner().isPresent() && turret.getOwner().equals(this.getOwner());
    }

    public boolean isInvulnerableTo(DamageSource p_20122_) {
        Entity source = p_20122_.getEntity();
        if (source instanceof Player) {
            Player player = (Player)source;
            if (this.getOwner().isPresent() && player.getUUID().equals(this.getOwner().get())) {
                return true;
            }
        }
        return super.isInvulnerableTo(p_20122_);
    }

    public abstract boolean isArmed();

    @Nullable
    public UUID getOwnerUUID() {
        return this.getOwner().isPresent() ? this.getOwner().get() : null;
    }

    public PlayerTeam getTeam() {
        if (this.getOwner().isPresent()) {
            Player owner = this.level().getPlayerByUUID(this.getOwner().get());
            if (owner != null && owner.getTeam() != null) {
                return owner.getTeam();
            }
            return this.getAutomaticTeam().isEmpty() ? null : this.level().getScoreboard().getPlayerTeam(this.getAutomaticTeam());
        }
        return super.getTeam();
    }

    public void setOwnerName(String name) {
        this.entityData.set(OWNER_NAME, (Object)name);
    }

    public String getOwnerName() {
        return (String)this.entityData.get(OWNER_NAME);
    }

    public void addPlayerToExceptions(String name) {
        CompoundTag compoundTag = (CompoundTag)this.entityData.get(IGNORED_PLAYERS);
        for (String key : compoundTag.getAllKeys()) {
            String nickname = compoundTag.getString(key);
            if (!nickname.equals(name)) continue;
            return;
        }
        compoundTag.putString("IgnoredPlayer#" + compoundTag.size(), name);
    }

    public void removePlayerFromExceptions(String name) {
        CompoundTag compoundTag = (CompoundTag)this.entityData.get(IGNORED_PLAYERS);
        for (String key : compoundTag.getAllKeys()) {
            String nickname = compoundTag.getString(key);
            if (!nickname.equals(name)) continue;
            compoundTag.remove(key);
            break;
        }
    }

    public List<String> getExceptions() {
        UniqueList exceptions = new UniqueList(1);
        CompoundTag compoundTag = (CompoundTag)this.entityData.get(IGNORED_PLAYERS);
        compoundTag.getAllKeys().forEach(arg_0 -> Turret.lambda$getExceptions$8((List)exceptions, compoundTag, arg_0));
        return exceptions;
    }

    public boolean isInWall() {
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.isRefillingInventory()) {
                Services.PLATFORM.refillInventory(this, this.level());
            }
            if (this.level().getGameTime() % 30L == 0L) {
                ServerLevel serverLevel = (ServerLevel)this.level();
                Services.PLATFORM.checkAmmo(!this.isArmed(), this.getId(), serverLevel, this.getX(), this.getY(), this.getZ());
            }
        }
    }

    public int getDamage() {
        return 0;
    }

    public boolean fireImmune() {
        return Functions.contains((Item)((Item)KTItems.FIRE_SHIELD.get()), (ItemContainer)this.upgrades);
    }

    private static /* synthetic */ void lambda$getExceptions$8(List exceptions, CompoundTag compoundTag, String s) {
        exceptions.add(compoundTag.getString(s));
    }
}

