/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.saveddata.SavedData;

public class UnitLimits
extends SavedData {
    public ArrayListMultimap<UUID, Integer> limitMap = ArrayListMultimap.create((int)1, (int)2);

    public int getTurretCount(UUID player) {
        List list = this.limitMap.get((Object)player);
        if (list.isEmpty()) {
            return 0;
        }
        return (Integer)list.getFirst();
    }

    public int getDroneCount(UUID player) {
        List list = this.limitMap.get((Object)player);
        if (list.isEmpty()) {
            return 0;
        }
        return (Integer)list.get(1);
    }

    public void setTurretCount(UUID player, int count) {
        List list = this.limitMap.get((Object)player);
        if (list.isEmpty()) {
            list.add(count);
            list.add(0);
        } else {
            list.set(0, count);
        }
    }

    public void setDroneCount(UUID player, int count) {
        List list = this.limitMap.get((Object)player);
        if (list.isEmpty()) {
            list.add(0);
            list.add(count);
        } else {
            list.set(1, count);
        }
    }

    static UnitLimits load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        UnitLimits limitCapability = new UnitLimits();
        int turretEntries = compoundTag.getInt("Turret entries");
        for (int i = 0; i < turretEntries; ++i) {
            UUID uuid = compoundTag.getUUID("Player #" + i + " UUID");
            int turretSlots = compoundTag.getInt("Player " + String.valueOf(uuid) + " turret count");
            int droneSlots = compoundTag.getInt("Player " + String.valueOf(uuid) + " drone count");
            limitCapability.limitMap.put((Object)uuid, (Object)turretSlots);
            limitCapability.limitMap.put((Object)uuid, (Object)droneSlots);
        }
        return limitCapability;
    }

    public CompoundTag save(CompoundTag arg, HolderLookup.Provider arg2) {
        CompoundTag compoundTag = new CompoundTag();
        int number = 0;
        for (Map.Entry uuidCollectionEntry : this.limitMap.asMap().entrySet()) {
            List collection = (List)uuidCollectionEntry.getValue();
            UUID uuid = (UUID)uuidCollectionEntry.getKey();
            compoundTag.putUUID("Player #" + number + " UUID", uuid);
            compoundTag.putInt("Player " + String.valueOf(uuid) + " turret count", ((Integer)collection.get(0)).intValue());
            compoundTag.putInt("Player " + String.valueOf(uuid) + " drone count", ((Integer)collection.get(1)).intValue());
            ++number;
        }
        compoundTag.putInt("Turret entries", number);
        return compoundTag;
    }
}

