/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.google.common.collect.TreeBasedTable;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.satako.Constants;
import dev.buildtool.satako.UniqueList;
import dev.buildtool.satako.client.gui.BetterButton;
import dev.buildtool.satako.client.gui.Label;
import dev.buildtool.satako.client.gui.Screen2;
import dev.buildtool.satako.client.gui.ScrollArea;
import dev.buildtool.satako.client.gui.SwitchButton;
import dev.buildtool.satako.client.gui.TextField;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class UnitSettingsScreen
extends Screen2 {
    protected Turret turret;
    private final List<Label> suggestions = new ArrayList<Label>(14);
    private final UniqueList<EntityType<?>> targets;
    private final ArrayList<BetterButton> hideableWidgets = new ArrayList();
    private TextField addEntity;
    private final List<String> exceptions = new ArrayList<String>();
    private final ArrayList<BetterButton> exceptionButtons = new ArrayList();

    public UnitSettingsScreen(Component title, Turret turret) {
        super(title);
        this.targets = new UniqueList(Turret.decodeTargets(turret.getTargets()));
        this.exceptions.addAll(turret.getExceptions());
        this.turret = turret;
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        void var6_15;
        super.init();
        TreeBasedTable table = TreeBasedTable.create();
        ArrayList<Object> widgets = new ArrayList<Object>();
        if (!this.exceptions.isEmpty()) {
            Label textField = new Label(0, 0, (Component)Component.translatable((String)"k_turrets.ignored.players"), Constants.BLACK);
            widgets.add(textField);
            table.put((Object)0, (Object)0, (Object)textField);
        }
        int row = 1;
        for (String string2 : this.exceptions) {
            SwitchButton switchButton = new SwitchButton(0, 0, (Component)Component.literal((String)string2), (Component)Component.literal((String)(String.valueOf(ChatFormatting.STRIKETHROUGH) + string2)), true, button -> {
                SwitchButton switchButton = (SwitchButton)button;
                if (switchButton.state) {
                    this.turret.addPlayerToExceptions(string2);
                    Services.PLATFORM.addPlayerException(this.turret.getId(), string2);
                } else {
                    this.turret.removePlayerFromExceptions(string2);
                    Services.PLATFORM.removePlayerException(this.turret.getId(), string2);
                }
            });
            this.exceptionButtons.add((BetterButton)switchButton);
            widgets.add(switchButton);
            table.put((Object)row, (Object)0, (Object)switchButton);
            ++row;
        }
        if (!this.exceptions.isEmpty()) {
            Label separator = new Label(0, 0, (Component)Component.translatable((String)"k_turrets.targets"), Constants.DARK);
            widgets.add(separator);
            table.put((Object)row, (Object)0, (Object)separator);
            ++row;
        }
        this.targets.sort(Comparator.comparing(o -> BuiltInRegistries.ENTITY_TYPE.getKey(o).toString()));
        List<SwitchButton> buttons = this.targets.stream().map(entityType -> BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString()).map(entityName -> new SwitchButton(0, 0, (Component)Component.literal((String)entityName), (Component)Component.literal((String)(String.valueOf(ChatFormatting.STRIKETHROUGH) + entityName)), true, button -> {
            SwitchButton switchButton = (SwitchButton)button;
            List<EntityType<?>> targets = Turret.decodeTargets(this.turret.getTargets());
            if (switchButton.state) {
                targets.add((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)entityName)));
                this.turret.setTargets(Turret.encodeTargets(targets));
            }
            Services.PLATFORM.setTarget(this.turret.getId(), switchButton.state, (String)entityName);
        })).toList();
        for (BetterButton betterButton : buttons) {
            table.put((Object)row, (Object)0, (Object)betterButton);
            ++row;
        }
        ScrollArea scrollArea = new ScrollArea(0, 20, this.width / 2, this.height - 40, (Component)Component.empty(), (Screen)this);
        this.addRenderableWidget((GuiEventListener)scrollArea);
        table.cellSet().forEach(cell -> scrollArea.addWidget((AbstractWidget)cell.getValue(), ((Integer)cell.getRowKey()).intValue(), ((Integer)cell.getColumnKey()).intValue()));
        scrollArea.alignWidgets();
        int n = 20;
        TextField addEntity = new TextField(this.width / 2 + 16, n, "", this.width / 2);
        addEntity.setResponder(string -> {
            this.suggestions.forEach(arg_0 -> ((UnitSettingsScreen)this).removeWidget(arg_0));
            this.suggestions.clear();
            if (!string.isEmpty()) {
                int yOffset = 20;
                if (string.startsWith("!")) {
                    List players = this.turret.level().players();
                    players.remove(Minecraft.getInstance().player);
                    for (Player player : players) {
                        Label hint = new Label(addEntity.getX(), addEntity.getY() + yOffset, player.getName(), Constants.BLACK, button -> {
                            addEntity.setValue("!" + button.getMessage().getString());
                            this.suggestions.forEach(arg_0 -> ((UnitSettingsScreen)this).removeWidget(arg_0));
                            this.suggestions.clear();
                            this.hideableWidgets.forEach(betterButton -> {
                                betterButton.visible = true;
                            });
                        });
                        this.addRenderableWidget((GuiEventListener)hint);
                        this.suggestions.add(hint);
                        yOffset += 20;
                        if (!players.isEmpty()) {
                            this.hideableWidgets.forEach(betterButton -> {
                                betterButton.visible = false;
                            });
                            continue;
                        }
                        this.hideableWidgets.forEach(betterButton -> {
                            betterButton.visible = true;
                        });
                    }
                } else {
                    ArrayList<ResourceLocation> entityTypes = new ArrayList<ResourceLocation>(BuiltInRegistries.ENTITY_TYPE.keySet().stream().filter(resourceLocation -> resourceLocation.toString().contains((CharSequence)string)).toList());
                    entityTypes.removeAll(this.targets.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0)).toList());
                    for (ResourceLocation entityType : entityTypes.subList(0, Math.min(entityTypes.size(), 20))) {
                        Label hint = new Label(addEntity.getX(), addEntity.getY() + yOffset, (Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + entityType.toString())), Constants.BLACK, button -> {
                            addEntity.setValue(button.getMessage().getString().substring(2));
                            this.suggestions.forEach(arg_0 -> ((UnitSettingsScreen)this).removeWidget(arg_0));
                            this.suggestions.clear();
                            this.hideableWidgets.forEach(betterButton -> {
                                betterButton.visible = true;
                            });
                        });
                        this.addRenderableWidget((GuiEventListener)hint);
                        this.suggestions.add(hint);
                        yOffset += 20;
                    }
                    if (!entityTypes.isEmpty()) {
                        this.hideableWidgets.forEach(betterButton -> {
                            betterButton.visible = false;
                        });
                    } else {
                        this.hideableWidgets.forEach(betterButton -> {
                            betterButton.visible = true;
                        });
                    }
                }
            } else {
                this.hideableWidgets.forEach(betterButton -> {
                    betterButton.visible = true;
                });
            }
        });
        this.addRenderableWidget((GuiEventListener)addEntity);
        BetterButton addButton = new BetterButton(addEntity.getX(), (int)(var6_13 += 24), (Component)Component.translatable((String)"k_turrets.add.entity.type"), button -> {
            String string = addEntity.getValue();
            if (string.startsWith("!") && string.length() > 1) {
                String playerName = string.substring(1);
                if (this.exceptions.contains(playerName)) {
                    this.addPopup((Component)Component.translatable((String)"k_turrets.player.is.already.in.exceptions", (Object[])new Object[]{playerName}));
                } else {
                    this.turret.addPlayerToExceptions(playerName);
                    this.exceptions.add(playerName);
                    Services.PLATFORM.addPlayerException(this.turret.getId(), playerName);
                    addEntity.setValue("");
                    this.rebuildWidgets();
                }
            } else if (!string.isEmpty()) {
                EntityType entityTypesValue = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)string));
                if (entityTypesValue == EntityType.PIG && this.targets.contains((Object)entityTypesValue)) {
                    this.addPopup((Component)Component.translatable((String)"k_turrets.entity.doesnt.exist"));
                } else {
                    this.targets.add((Object)entityTypesValue);
                    Services.PLATFORM.setTarget(this.turret.getId(), true, string);
                    addEntity.setValue("");
                    this.rebuildWidgets();
                    this.addPopup((Component)Component.translatable((String)"k_turrets.added"));
                }
            }
        });
        this.addRenderableWidget((GuiEventListener)addButton);
        this.hideableWidgets.add(addButton);
        BetterButton dismantle = new BetterButton(addEntity.getX(), (int)(var6_14 += 20), (Component)Component.translatable((String)"k_turrets.dismantle"), button -> {
            this.onClose();
            Services.PLATFORM.sendDismantle(this.turret.getId());
        });
        this.addRenderableWidget((GuiEventListener)dismantle);
        this.hideableWidgets.add(dismantle);
        BetterButton clearTargets = new BetterButton(addEntity.getX(), (int)(var6_15 += 20), (Component)Component.translatable((String)"k_turrets.clear.list"), button -> {
            this.targets.clear();
            this.rebuildWidgets();
            Services.PLATFORM.sendTargets(this.turret.getId(), new CompoundTag());
        });
        this.addRenderableWidget((GuiEventListener)clearTargets);
        this.hideableWidgets.add(clearTargets);
        BetterButton resetTargets = new BetterButton(clearTargets.getX() + clearTargets.getWidth(), (int)var6_15, (Component)Component.translatable((String)"k_turrets.reset.list"), pButton -> {
            List<EntityType<?>> entityTypeList = BuiltInRegistries.ENTITY_TYPE.stream().filter(entityType1 -> !entityType1.getCategory().isFriendly()).toList();
            this.targets.addAll(entityTypeList);
            this.rebuildWidgets();
            List<EntityType<?>> entityTypes = Turret.decodeTargets(this.turret.getTargets());
            entityTypes.clear();
            entityTypes.addAll(entityTypeList);
            CompoundTag compoundNBT = Turret.encodeTargets(entityTypeList);
            this.turret.setTargets(compoundNBT);
            Services.PLATFORM.sendTargets(this.turret.getId(), compoundNBT);
        });
        this.addRenderableWidget((GuiEventListener)resetTargets);
        this.hideableWidgets.add(resetTargets);
        SwitchButton mobility = new SwitchButton(addEntity.getX(), (int)(var6_16 += 20), (Component)Component.translatable((String)"k_turrets.mobile"), (Component)Component.translatable((String)"k_turrets.immobile"), this.turret.isMoveable(), pButton -> {
            SwitchButton switchButton1 = (SwitchButton)pButton;
            this.turret.setMoveable(switchButton1.state);
            Services.PLATFORM.toggleMobility(this.turret.getId(), switchButton1.state);
        });
        this.addRenderableWidget((GuiEventListener)mobility);
        this.hideableWidgets.add((BetterButton)mobility);
        mobility.setTooltip(Tooltip.create((Component)Component.translatable((String)"k_turrets.pushable")));
        SwitchButton playerProtection = new SwitchButton(addEntity.getX(), (int)(var6_17 += 20), (Component)Component.translatable((String)"k_turrets.protect.from.players"), (Component)Component.translatable((String)"k_turrets.not.protect.from.players"), this.turret.isProtectingFromPlayers(), pButton -> {
            SwitchButton switchButton1 = (SwitchButton)pButton;
            this.turret.setProtectionFromPlayers(switchButton1.state);
            Services.PLATFORM.togglePlayerProtection(this.turret.getId(), switchButton1.state);
        });
        this.addRenderableWidget((GuiEventListener)playerProtection);
        this.hideableWidgets.add((BetterButton)playerProtection);
        playerProtection.setTooltip(Tooltip.create((Component)Component.translatable((String)"k_turrets.protection.from.players")));
        SwitchButton refillSwitch = new SwitchButton(addEntity.getX(), (int)(var6_18 += 20), (Component)Component.translatable((String)"k_turrets.refill.inventory"), (Component)Component.translatable((String)"k_turrets.dont.refill.inventory"), this.turret.isRefillingInventory(), pButton -> {
            SwitchButton b = (SwitchButton)pButton;
            this.turret.setRefillInventory(b.state);
            Services.PLATFORM.setRefillInventory(this.turret.getId(), b.state);
        });
        this.addRenderableWidget((GuiEventListener)refillSwitch);
        this.hideableWidgets.add((BetterButton)refillSwitch);
        refillSwitch.setTooltip(Tooltip.create((Component)Component.translatable((String)"k_turrets.refill.info")));
        SwitchButton protectSwitch = new SwitchButton(addEntity.getX(), (int)(var6_19 += 20), (Component)Component.translatable((String)"k_turrets.protect.player"), (Component)Component.translatable((String)"k_turrets.do.not.protect.player"), this.turret.isProtectingOwner(), pButton -> {
            SwitchButton switchButton = (SwitchButton)pButton;
            this.turret.setProtectOwner(switchButton.state);
            Services.PLATFORM.togglePlayerProtection(this.turret.getId(), switchButton.state);
        });
        this.addRenderableWidget((GuiEventListener)protectSwitch);
        this.hideableWidgets.add((BetterButton)protectSwitch);
        protectSwitch.setTooltip(Tooltip.create((Component)Component.translatable((String)"k_turrets.player.protection")));
        void finalElementYPos = var6_20 += 20;
        this.turret.getOwner().ifPresentOrElse(arg_0 -> this.lambda$init$30(addEntity, (int)finalElementYPos, arg_0), () -> this.lambda$init$32(addEntity, (int)finalElementYPos));
        Label range = new Label(addEntity.getX() + 4, (int)(var6_21 += 24), (Component)Component.translatable((String)"k_turrets.range").append(": ").append("" + this.turret.getRange()), Constants.BLACK);
        this.hideableWidgets.add((BetterButton)this.addRenderableWidget((GuiEventListener)range));
        Label health = new Label(range.getX(), (int)(var6_22 += 20), (Component)Component.translatable((String)"k_turrets.integrity").append(": ").append(String.format("%.1f", Float.valueOf(this.turret.getHealth())) + "/" + this.turret.getMaxHealth()), Constants.BLACK);
        this.hideableWidgets.add((BetterButton)this.addRenderableWidget((GuiEventListener)health));
        int primaryDamage = this.turret.getDamage();
        MutableComponent damageText = Component.translatable((String)"k_turrets.damage", (Object[])new Object[]{primaryDamage});
        Label damage = new Label(range.getX(), (int)(var6_23 += 209), (Component)damageText, Constants.BLACK);
        this.hideableWidgets.add((BetterButton)damage);
        this.addRenderableWidget((GuiEventListener)damage);
        Label armor = new Label(range.getX(), (int)(var6_24 += 20), (Component)Component.translatable((String)"k_turrets.armor", (Object[])new Object[]{String.format("%.1f", this.turret.getAttribute(Attributes.ARMOR).getValue())}), Constants.BLACK);
        this.hideableWidgets.add((BetterButton)armor);
        this.addRenderableWidget((GuiEventListener)armor);
    }
}

