/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.drones;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.menus.BrickDroneContainer;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.projectiles.Brick;
import dev.buildtool.kturrets.registries.KTEntities;
import dev.buildtool.kturrets.registries.Sounds;
import dev.buildtool.kturrets.tasks.AttackTargetGoal;
import dev.buildtool.kturrets.tasks.RestrictedRangedAttackGoal;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BrickDrone
extends Drone {
    public ItemContainer ammo = Services.PLATFORM.createBrickDroneAmmo();

    public BrickDrone(Level world) {
        super((EntityType<? extends PathfinderMob>)Functions.cast((EntityType)((EntityType)KTEntities.BRICK_DRONE.get())), world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new RestrictedRangedAttackGoal(this, 1.0, Services.PLATFORM.getBrickTurretDelay(), (float)this.getRange()));
        this.targetSelector.addGoal(5, (Goal)new AttackTargetGoal(this));
    }

    @Override
    public List<ItemContainer> getContainedItems() {
        return List.of(this.ammo, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return !this.ammo.isEmpty();
    }

    public void performRangedAttack(LivingEntity target, float p_33318_) {
        if (target.isAlive()) {
            for (ItemStack ammoItem : this.ammo.getItems()) {
                if (ammoItem.isEmpty()) continue;
                double xa = target.getX() - this.getX();
                double ya = target.getEyeY() - this.getEyeY();
                double za = target.getZ() - this.getZ();
                Brick brick = new Brick((LivingEntity)this, new Vec3(xa, ya, za), this.level());
                brick.setDamage(Services.PLATFORM.getBrickDamage());
                this.level().addFreshEntity((Entity)brick);
                this.playSound((SoundEvent)Sounds.BRICK_SHOT.get(), 0.3f, 1.0f);
                ammoItem.shrink(1);
                break;
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, Inventory p_39955_, Player p_39956_) {
        FriendlyByteBuf buffer = Functions.emptyBuffer();
        buffer.writeInt(this.getId());
        return new BrickDroneContainer(p_39954_, p_39955_, buffer, 0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.put("Ammo", (Tag)this.ammo.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.ammo.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compoundNBT.getCompound("Ammo"));
    }

    @Override
    public int getDamage() {
        return Services.PLATFORM.getBrickDamage();
    }
}

