/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.drones;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.menus.BulletDroneContainer;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.projectiles.Bullet;
import dev.buildtool.kturrets.registries.KTEntities;
import dev.buildtool.kturrets.registries.Sounds;
import dev.buildtool.kturrets.tasks.AttackTargetGoal;
import dev.buildtool.kturrets.tasks.RestrictedRangedAttackGoal;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BulletDrone
extends Drone {
    public final ItemContainer ammo = Services.PLATFORM.createBulletDroneAmmo();

    public BulletDrone(Level world) {
        super((EntityType<? extends PathfinderMob>)Functions.cast((EntityType)((EntityType)KTEntities.BULLET_DRONE.get())), world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new RestrictedRangedAttackGoal(this, 1.0, Services.PLATFORM.getBulletTurretDelay(), (float)this.getRange()));
        this.targetSelector.addGoal(5, (Goal)new AttackTargetGoal(this));
    }

    @Override
    public List<ItemContainer> getContainedItems() {
        return List.of(this.ammo, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return !this.ammo.isEmpty();
    }

    public void performRangedAttack(LivingEntity livingEntity, float p_33318_) {
        if (livingEntity.isAlive()) {
            for (ItemStack item : this.ammo.getItems()) {
                if (item.isEmpty()) continue;
                double d0 = livingEntity.getX() - this.getX();
                double d1 = livingEntity.getEyeY() - this.getEyeY();
                double d2 = livingEntity.getZ() - this.getZ();
                Bullet bullet = new Bullet((LivingEntity)this, new Vec3(d0, d1, d2), this.level());
                bullet.setDamage(Services.PLATFORM.getBulletDamage());
                this.level().addFreshEntity((Entity)bullet);
                this.playSound((SoundEvent)Sounds.BULLET_FIRE.get(), 1.0f, 1.0f);
                item.shrink(1);
                break;
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, Inventory inventory, Player player) {
        FriendlyByteBuf friendlyByteBuf = Functions.emptyBuffer();
        friendlyByteBuf.writeInt(this.getId());
        return new BulletDroneContainer(p_39954_, inventory, friendlyByteBuf, 0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.put("Ammo", (Tag)this.ammo.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.ammo.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compoundNBT.getCompound("Ammo"));
    }

    @Override
    public int getDamage() {
        return Services.PLATFORM.getBulletDamage();
    }
}

