/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.drones;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.menus.CobbleDroneContainer;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.projectiles.Cobblestone;
import dev.buildtool.kturrets.registries.KTEntities;
import dev.buildtool.kturrets.registries.Sounds;
import dev.buildtool.kturrets.tasks.AttackTargetGoal;
import dev.buildtool.kturrets.tasks.RestrictedRangedAttackGoal;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CobbleDrone
extends Drone {
    public ItemContainer stone = Services.PLATFORM.createCobbleDroneAmmo();

    public CobbleDrone(Level world) {
        super((EntityType<? extends PathfinderMob>)Functions.cast((EntityType)((EntityType)KTEntities.COBBLE_DRONE.get())), world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new RestrictedRangedAttackGoal(this, 1.0, Services.PLATFORM.getCobbleTurretDelay(), (float)this.getRange()));
        this.targetSelector.addGoal(5, (Goal)new AttackTargetGoal(this));
    }

    @Override
    public List<ItemContainer> getContainedItems() {
        return List.of(this.stone, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return !this.stone.isEmpty();
    }

    public void performRangedAttack(LivingEntity target, float p_33318_) {
        if (target.isAlive()) {
            for (ItemStack cobblestoneItem : this.stone.getItems()) {
                if (cobblestoneItem.isEmpty()) continue;
                double xa = target.getX() - this.getX();
                double ya = target.getEyeY() - this.getEyeY();
                double za = target.getZ() - this.getZ();
                Cobblestone cobblestone = new Cobblestone((LivingEntity)this, new Vec3(xa, ya, za), this.level());
                cobblestone.setDamage(Services.PLATFORM.getCobbleUnitDamage());
                this.level().addFreshEntity((Entity)cobblestone);
                this.playSound((SoundEvent)Sounds.COBBLE_SHOT.get(), 1.0f, 1.0f);
                cobblestoneItem.shrink(1);
                break;
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, Inventory p_39955_, Player p_39956_) {
        FriendlyByteBuf friendlyByteBuf = Functions.emptyBuffer();
        friendlyByteBuf.writeInt(this.getId());
        return new CobbleDroneContainer(p_39954_, p_39955_, friendlyByteBuf, 0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.put("Ammo", (Tag)this.stone.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.stone.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compoundNBT.getCompound("Ammo"));
    }

    @Override
    public int getDamage() {
        return Services.PLATFORM.getCobbleUnitDamage();
    }
}

