/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.drones;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.menus.StorageDroneMenu;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.registries.KTEntities;
import dev.buildtool.kturrets.registries.KTItems;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class StorageDrone
extends Drone {
    private static final EntityDataAccessor<Boolean> MAGNET_ACTIVE = SynchedEntityData.defineId(StorageDrone.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public ItemContainer itemHandler = Services.PLATFORM.createStorageDroneInventory();

    public StorageDrone(Level world) {
        super((EntityType<? extends PathfinderMob>)Functions.cast((EntityType)((EntityType)KTEntities.STORAGE_DRONE.get())), world);
    }

    @Override
    public List<ItemContainer> getContainedItems() {
        return List.of(this.itemHandler, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return false;
    }

    public void performRangedAttack(LivingEntity p_33317_, float p_33318_) {
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MAGNET_ACTIVE, (Object)true);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, Inventory p_39955_, Player p_39956_) {
        FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
        byteBuf.writeInt(this.getId());
        return new StorageDroneMenu(p_39954_, p_39955_, byteBuf, 0);
    }

    @Override
    protected InteractionResult mobInteract(Player playerEntity, InteractionHand interactionHand) {
        return super.mobInteract(playerEntity, interactionHand);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.put("Items", (Tag)this.itemHandler.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compoundNBT.putBoolean("Magnet on", this.isMagnetActive());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.itemHandler.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compoundNBT.getCompound("Items"));
        this.setMagnetActive(compoundNBT.getBoolean("Magnet on"));
    }

    @Override
    public void tick() {
        ItemStack magnet;
        super.tick();
        if (!this.level().isClientSide && (magnet = Functions.findItem((Item)((Item)KTItems.MAGNET_UPGRADE.get()), (ItemContainer)this.upgrades)).is((Item)KTItems.MAGNET_UPGRADE.get()) && this.isMagnetActive()) {
            List itemEntities = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(32.0));
            itemEntities.forEach(itemEntity -> {
                ItemStack entityItem = itemEntity.getItem();
                if (!entityItem.is((Item)KTItems.STORAGE_DRONE.get())) {
                    Services.PLATFORM.useMagnet(magnet, this, (ItemEntity)itemEntity);
                }
            });
        }
    }

    public void setMagnetActive(boolean b) {
        this.entityData.set(MAGNET_ACTIVE, (Object)b);
    }

    public boolean isMagnetActive() {
        return (Boolean)this.entityData.get(MAGNET_ACTIVE);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Mob.class, living -> {
            Player owner;
            if (this.getOwner().isPresent() && (owner = this.level().getPlayerByUUID(this.getOwnerUUID())) != null) {
                Mob mob = (Mob)living;
                return mob.getTarget() == owner;
            }
            return false;
        }, 6.0f, 1.0, 1.0, living -> true));
    }
}

