/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.buildtool.satako.Functions;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BrickDroneModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"brick_drone"), "main");
    private final ModelPart rotor1;
    private final ModelPart base;
    private final ModelPart rotor2;
    private final ModelPart rotor3;
    private final ModelPart rotor4;
    private final ModelPart sides;
    private final ModelPart barrel;

    public BrickDroneModel(ModelPart root) {
        this.rotor1 = root.getChild("rotor1");
        this.base = root.getChild("base");
        this.rotor2 = root.getChild("rotor2");
        this.rotor3 = root.getChild("rotor3");
        this.rotor4 = root.getChild("rotor4");
        this.sides = root.getChild("sides");
        this.barrel = this.sides.getChild("muzzle");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rotor1 = partdefinition.addOrReplaceChild("rotor1", CubeListBuilder.create().texOffs(0, 20).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.5f, (float)14.5f, (float)6.0f));
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(17, 14).addBox(-4.0f, -9.0f, -2.0f, 8.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 14).addBox(-6.0f, -9.0f, -6.0f, 2.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(4.0f, -9.0f, -6.0f, 2.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(17, 0).addBox(-2.0f, -8.0f, -3.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = base.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, -6.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 28).addBox(-11.0f, -6.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)-4.0f, (float)5.5f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = base.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(10, 28).addBox(-11.0f, -6.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(15, 28).addBox(-1.0f, -6.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)-4.0f, (float)-5.5f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition rotor2 = partdefinition.addOrReplaceChild("rotor2", CubeListBuilder.create().texOffs(0, 14).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.5f, (float)14.5f, (float)6.0f));
        PartDefinition rotor3 = partdefinition.addOrReplaceChild("rotor3", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.5f, (float)14.5f, (float)-6.0f));
        PartDefinition rotor4 = partdefinition.addOrReplaceChild("rotor4", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.5f, (float)14.5f, (float)-6.0f));
        PartDefinition sides = partdefinition.addOrReplaceChild("sides", CubeListBuilder.create().texOffs(27, 31).addBox(1.0f, -1.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(20, 31).addBox(-2.0f, -1.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition muzzle = sides.addOrReplaceChild("muzzle", CubeListBuilder.create().texOffs(23, 22).addBox(-1.0f, -1.0f, -4.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.sides.yRot = Functions.getDefaultHeadYaw((float)netHeadYaw);
        this.barrel.xRot = Functions.getDefaultHeadPitch((float)headPitch);
        this.rotor1.yRot = ageInTicks * 1.5f;
        this.rotor2.yRot = -ageInTicks * 1.5f;
        this.rotor3.yRot = ageInTicks * 1.5f;
        this.rotor4.yRot = -ageInTicks * 1.5f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.rotor1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.base.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rotor2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rotor3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rotor4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.sides.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

