/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.buildtool.satako.Functions;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class GaussDroneModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"gauss_drone"), "main");
    private final ModelPart rotor1;
    private final ModelPart rotor2;
    private final ModelPart rotor3;
    private final ModelPart rotor4;
    private final ModelPart sides;
    private final ModelPart bb_main;
    private final ModelPart muzzle;

    public GaussDroneModel(ModelPart root) {
        this.rotor1 = root.getChild("rotor1");
        this.rotor2 = root.getChild("rotor2");
        this.rotor3 = root.getChild("rotor3");
        this.rotor4 = root.getChild("rotor4");
        this.sides = root.getChild("sides");
        this.bb_main = root.getChild("bb_main");
        this.muzzle = this.sides.getChild("muzzle");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rotor1 = partdefinition.addOrReplaceChild("rotor1", CubeListBuilder.create().texOffs(34, 23).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)12.5f, (float)5.5f));
        PartDefinition rotor2 = partdefinition.addOrReplaceChild("rotor2", CubeListBuilder.create().texOffs(10, 30).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)12.5f, (float)5.5f));
        PartDefinition rotor3 = partdefinition.addOrReplaceChild("rotor3", CubeListBuilder.create().texOffs(12, 22).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.5f, (float)12.5f, (float)-5.5f));
        PartDefinition rotor4 = partdefinition.addOrReplaceChild("rotor4", CubeListBuilder.create().texOffs(12, 19).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.5f, (float)12.5f, (float)-5.5f));
        PartDefinition sides = partdefinition.addOrReplaceChild("sides", CubeListBuilder.create().texOffs(17, 30).addBox(1.0f, -9.0f, -1.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(29, 28).addBox(-2.0f, -9.0f, -1.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition muzzle = sides.addOrReplaceChild("muzzle", CubeListBuilder.create().texOffs(24, 6).addBox(-1.0f, -1.0f, -5.25f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(34, 15).addBox(-1.0f, -2.0f, 0.75f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)1.25f));
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(12, 19).addBox(-6.0f, -11.0f, -6.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 17).addBox(5.0f, -11.0f, -6.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 28).addBox(-3.0f, -11.0f, -1.0f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(24, 19).addBox(2.0f, -11.0f, -1.0f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, -10.0f, -1.0f, 12.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(35, 0).addBox(4.0f, -9.0f, 2.0f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 17).addBox(4.0f, -9.0f, -1.0f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 8).addBox(4.0f, -3.0f, -5.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-5.0f, -3.0f, -5.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(12, 6).addBox(-5.0f, -9.0f, -1.0f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-5.0f, -9.0f, 2.0f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.sides.yRot = Functions.getDefaultHeadYaw((float)netHeadYaw);
        this.muzzle.xRot = Functions.getDefaultHeadPitch((float)headPitch);
        this.rotor1.yRot = ageInTicks * 1.5f;
        this.rotor2.yRot = -ageInTicks * 1.5f;
        this.rotor3.yRot = ageInTicks * 1.5f;
        this.rotor4.yRot = -ageInTicks * 1.5f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.rotor1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rotor2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rotor3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rotor4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.sides.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

