/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.platform;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTMenus;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.KTurretsNeoforge;
import dev.buildtool.kturrets.ReloaderBlockEntity;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.UnitSettingsScreen;
import dev.buildtool.kturrets.drones.ArrowDrone;
import dev.buildtool.kturrets.drones.BrickDrone;
import dev.buildtool.kturrets.drones.BulletDrone;
import dev.buildtool.kturrets.drones.CobbleDrone;
import dev.buildtool.kturrets.drones.FireballDrone;
import dev.buildtool.kturrets.drones.GaussDrone;
import dev.buildtool.kturrets.drones.StorageDrone;
import dev.buildtool.kturrets.menus.ArrowDroneContainer;
import dev.buildtool.kturrets.menus.ArrowTurretContainer;
import dev.buildtool.kturrets.menus.BrickDroneContainer;
import dev.buildtool.kturrets.menus.BrickTurretContainer;
import dev.buildtool.kturrets.menus.BulletDroneContainer;
import dev.buildtool.kturrets.menus.BulletTurretContainer;
import dev.buildtool.kturrets.menus.CobbleDroneContainer;
import dev.buildtool.kturrets.menus.CobbleTurretContainer;
import dev.buildtool.kturrets.menus.FireballDroneContainer;
import dev.buildtool.kturrets.menus.FireballTurretContainer;
import dev.buildtool.kturrets.menus.GaussDroneContainer;
import dev.buildtool.kturrets.menus.GaussTurretContainer;
import dev.buildtool.kturrets.menus.MagnetMenu;
import dev.buildtool.kturrets.menus.ReloaderMenu;
import dev.buildtool.kturrets.menus.StorageDroneMenu;
import dev.buildtool.kturrets.packets.AddPlayerException;
import dev.buildtool.kturrets.packets.AmmoCheck;
import dev.buildtool.kturrets.packets.ClaimTurret;
import dev.buildtool.kturrets.packets.CompressItems;
import dev.buildtool.kturrets.packets.DismantleTurret;
import dev.buildtool.kturrets.packets.MagnetFilterMode;
import dev.buildtool.kturrets.packets.PickupParticles;
import dev.buildtool.kturrets.packets.RemovePlayerException;
import dev.buildtool.kturrets.packets.SetBehavior;
import dev.buildtool.kturrets.packets.SetMagnetState;
import dev.buildtool.kturrets.packets.SetRefillInventory;
import dev.buildtool.kturrets.packets.SetTarget;
import dev.buildtool.kturrets.packets.ToggleMobility;
import dev.buildtool.kturrets.packets.TogglePlayerProtection;
import dev.buildtool.kturrets.packets.TurretTargets;
import dev.buildtool.kturrets.platform.PlatformHooks;
import dev.buildtool.kturrets.registries.KTDataComponents;
import dev.buildtool.kturrets.registries.KTItems;
import dev.buildtool.kturrets.screens.StorageDroneScreen;
import dev.buildtool.kturrets.turrets.ArrowTurret;
import dev.buildtool.kturrets.turrets.BrickTurret;
import dev.buildtool.kturrets.turrets.BulletTurret;
import dev.buildtool.kturrets.turrets.CobbleTurret;
import dev.buildtool.kturrets.turrets.FireballTurret;
import dev.buildtool.kturrets.turrets.GaussTurret;
import dev.buildtool.satako.Constants;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.ItemContainer;
import dev.buildtool.satako.ItemHandler;
import dev.buildtool.satako.ItemHandlerSlot;
import dev.buildtool.satako.Menu;
import dev.buildtool.satako.NeoforgeFunctions;
import dev.buildtool.satako.NeoforgeMethods;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class NeoForgePlatformHooks
implements PlatformHooks {
    @Override
    public int getTurretLimit() {
        return (Integer)KTurretsNeoforge.TURRET_LIMIT_PER_PLAYER.get();
    }

    @Override
    public int getDroneLimit() {
        return (Integer)KTurretsNeoforge.DRONE_LIMIT_PER_PLAYER.get();
    }

    @Override
    public boolean setOwnerAutomatically() {
        return (Boolean)KTurretsNeoforge.SET_OWNER_AUTO.get();
    }

    @Override
    public void refillInventory(Turret turret, Level level) {
        for (Direction direction : Direction.values()) {
            BlockPos blockPos = turret.blockPosition();
            BlockPos pos = blockPos.relative(direction);
            IItemHandler iItemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)direction.getOpposite());
            if (iItemHandler == null) continue;
            NeoforgeMethods.transferItems((IItemHandler)iItemHandler, (IItemHandler)((IItemHandler)turret.getContainedItems().get(0)), (int)1);
            break;
        }
    }

    @Override
    public List<String> getDefaultExceptions() {
        return (List)KTurretsNeoforge.TARGET_EXCEPTIONS.get();
    }

    @Override
    public ItemContainer createTurretUpgrades() {
        return new ItemHandler(this, 3){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (stack.is((Item)KTItems.EXP_LINK.get())) {
                    return !Functions.contains((Item)((Item)KTItems.EXP_LINK.get()), (ItemContainer)this);
                }
                if (stack.is((Item)KTItems.FIRE_SHIELD.get())) {
                    return !Functions.contains((Item)((Item)KTItems.FIRE_SHIELD.get()), (ItemContainer)this);
                }
                if (stack.is((Item)KTItems.LOOTING_LINK.get())) {
                    return !Functions.contains((Item)((Item)KTItems.LOOTING_LINK.get()), (ItemContainer)this);
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    public ItemContainer createDroneUpgrades(final Drone thisDrone) {
        return new ItemHandler(this, 5){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (stack.is((Item)KTItems.RECALL_UPGRADE.get())) {
                    return !Functions.contains((Item)((Item)KTItems.RECALL_UPGRADE.get()), (ItemContainer)this);
                }
                if (stack.is((Item)KTItems.MAGNET_UPGRADE.get())) {
                    return thisDrone instanceof StorageDrone && !Functions.contains((Item)((Item)KTItems.MAGNET_UPGRADE.get()), (ItemContainer)this);
                }
                if (stack.is((Item)KTItems.LIGHT_UPGRADE.get())) {
                    return !Functions.contains((Item)((Item)KTItems.LIGHT_UPGRADE.get()), (ItemContainer)this);
                }
                if (stack.is((Item)KTItems.EXP_LINK.get())) {
                    return !(thisDrone instanceof StorageDrone) && !Functions.contains((Item)((Item)KTItems.EXP_LINK.get()), (ItemContainer)this);
                }
                if (stack.is((Item)KTItems.FIRE_SHIELD.get())) {
                    return !Functions.contains((Item)((Item)KTItems.FIRE_SHIELD.get()), (ItemContainer)this);
                }
                if (stack.is((Item)KTItems.LOOTING_LINK.get())) {
                    return !Functions.contains((Item)((Item)KTItems.LOOTING_LINK.get()), (ItemContainer)this);
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    public int getFollowOwnerDistance() {
        return (Integer)KTurretsNeoforge.OWNER_FOLLOW_DISTANCE.get();
    }

    @Override
    public ItemContainer createStorageDroneInventory() {
        return new ItemHandler(this, 27){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return !stack.is((Item)KTItems.STORAGE_DRONE.get());
            }
        };
    }

    @Override
    public ItemContainer createReloaderInventory(ReloaderBlockEntity reloaderBlockEntity) {
        return new ItemHandler(this, 108, (BlockEntity)reloaderBlockEntity){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot <= 17) {
                    return stack.is(KTurrets.ARROW_UNIT_AMMO_TAG);
                }
                if (slot <= 35) {
                    return stack.is(KTurrets.BULLET_UNIT_AMMO_TAG);
                }
                if (slot <= 53) {
                    return stack.is(KTurrets.BRICK_UNIT_AMMO_TAG);
                }
                if (slot <= 71) {
                    return stack.is(KTurrets.FIREBALL_UNIT_AMMO);
                }
                if (slot <= 89) {
                    return stack.is(KTurrets.COBBLE_UNIT_AMMO_TAG);
                }
                if (slot <= 107) {
                    return stack.is(KTurrets.GAUSS_UNIT_AMMO_TAG);
                }
                return false;
            }
        };
    }

    @Override
    public void addReloaderSlots(ReloaderMenu reloaderMenu, ReloaderBlockEntity reloaderBlockEntity) {
        int index = 0;
        for (int j = 0; j < 6; ++j) {
            for (int k = 0; k < 18; ++k) {
                ItemHandlerSlot slot = new ItemHandlerSlot((IItemHandler)reloaderBlockEntity.ammo, index++, k * 18, j * 18);
                if (index <= 18) {
                    slot.setColor(new IntegerColor(-1013111));
                } else if (index <= 36) {
                    slot.setColor(new IntegerColor(-5994478));
                } else if (index <= 54) {
                    slot.setColor(new IntegerColor(-5849968));
                } else if (index <= 72) {
                    slot.setColor(new IntegerColor(-8599069));
                } else if (index <= 90) {
                    slot.setColor(new IntegerColor(-14032844));
                } else {
                    slot.setColor(new IntegerColor(-6810971));
                }
                reloaderMenu.addSlot((Slot)slot);
            }
        }
    }

    @Override
    public void addMagnetSlots(ItemStack magnet, MagnetMenu menu) {
        IItemHandler iItemHandler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(magnet, null);
        int index = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                menu.addSlot((Slot)new ItemHandlerSlot(iItemHandler, index++, k * 18, j * 18));
            }
        }
    }

    @Override
    public ItemContainer createArrowTurretWeaponInv() {
        return new ItemHandler(this, 1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.getItem() instanceof CrossbowItem || stack.getItem() instanceof BowItem;
            }
        };
    }

    @Override
    public ItemContainer createArrowTurretInventory() {
        return new ItemHandler(this, 27){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.ARROW_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public int getArrowDamage() {
        return (Integer)KTurretsNeoforge.ARROW_TURRET_DAMAGE.get();
    }

    @Override
    public float getProjectileSpeed() {
        return ((Double)KTurretsNeoforge.PROJECTILE_SPEED.get()).intValue();
    }

    @Override
    public void addTurretSlots(ArrowTurretContainer container, ArrowTurret turret) {
        container.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.weapon, 0, 72, 0).setColor(Constants.GREEN).setTooltip((Component)Component.translatable((String)"k_turrets.bow.or.crossbow")));
        int slot = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                container.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.ammo, slot++, k * 18, j * 18 + 18));
            }
        }
        container.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 0, 54, 72).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        container.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 1, 72, 72).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        container.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 2, 90, 72).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
    }

    @Override
    public int getArrowUnitDelay() {
        return (Integer)KTurretsNeoforge.ARROW_TURRET_RATE.get();
    }

    @Override
    public void openScreen(Player player, Turret turret) {
        player.openMenu((MenuProvider)turret, byteBuf -> byteBuf.writeInt(turret.getId()));
    }

    @Override
    public MenuType<?> getArrowTurretMenu() {
        return (MenuType)KTMenus.ARROW_TURRET.get();
    }

    @Override
    public MenuType<?> getMagnetMenu() {
        return (MenuType)KTMenus.MAGNET.get();
    }

    @Override
    public MenuType<?> getReloaderMenu() {
        return (MenuType)KTMenus.RELOADER.get();
    }

    @Override
    public void useMagnet(ItemStack magnet, StorageDrone storageDrone, ItemEntity itemEntity) {
        IItemHandler iItemHandler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(magnet, null);
        if (iItemHandler != null && magnet.has(KTDataComponents.MAGNET_MODE)) {
            ServerLevel serverLevel = (ServerLevel)storageDrone.level();
            ItemStack entityItem = itemEntity.getItem();
            if (((KTDataComponents.MagnetMode)magnet.get(KTDataComponents.MAGNET_MODE)).state()) {
                for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                    ItemStack item = iItemHandler.getStackInSlot(i);
                    if (!Functions.areItemTypesEqual((ItemStack)item, (ItemStack)entityItem)) continue;
                    ItemStack tryInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)entityItem, (boolean)true);
                    if (!tryInsert.isEmpty()) break;
                    itemEntity.setPickUpDelay(20);
                    itemEntity.setDeltaMovement(storageDrone.getPosition(1.0f).subtract(itemEntity.position()).normalize().multiply(new Vec3(0.5, 0.5, 0.5)));
                    PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)storageDrone.getX(), (double)storageDrone.getY(), (double)storageDrone.getZ(), (double)22.0, (CustomPacketPayload)new PickupParticles(itemEntity.getX(), itemEntity.getY(), itemEntity.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    if (storageDrone.distanceTo((Entity)itemEntity) < 1.0f && NeoforgeFunctions.insertItem((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)entityItem)) {
                        itemEntity.discard();
                    }
                    break;
                }
            } else {
                ItemStack tryInsert;
                boolean isBlacklisted = false;
                for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                    ItemStack itemStack = iItemHandler.getStackInSlot(i);
                    if (!Functions.areItemTypesEqual((ItemStack)itemStack, (ItemStack)entityItem)) continue;
                    isBlacklisted = true;
                    break;
                }
                if (!isBlacklisted && (tryInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)entityItem, (boolean)true)).isEmpty()) {
                    itemEntity.setPickUpDelay(Functions.secondsToTicks((int)5));
                    itemEntity.setDeltaMovement(storageDrone.getPosition(1.0f).subtract(itemEntity.position()).normalize().multiply(0.25, 0.25, 0.25));
                    PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)storageDrone.getX(), (double)storageDrone.getY(), (double)storageDrone.getZ(), (double)22.0, (CustomPacketPayload)new PickupParticles(itemEntity.getX(), itemEntity.getY(), itemEntity.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    if (storageDrone.distanceTo((Entity)itemEntity) < 1.0f && NeoforgeFunctions.insertItem((IItemHandler)((IItemHandler)storageDrone.itemHandler), (ItemStack)entityItem)) {
                        itemEntity.discard();
                    }
                }
            }
        }
    }

    @Override
    public MenuType<?> getStorageDroneMenu() {
        return (MenuType)KTMenus.STORAGE_DRONE.get();
    }

    @Override
    public void addStorageDroneSlots(StorageDroneMenu storageDroneMenu, StorageDrone storageDrone) {
        int index = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                storageDroneMenu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)storageDrone.itemHandler, index++, 18 * k, 18 * j));
            }
        }
        storageDroneMenu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)storageDrone.upgrades, 0, 45, 54).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        storageDroneMenu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)storageDrone.upgrades, 1, 63, 54).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        storageDroneMenu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)storageDrone.upgrades, 2, 81, 54).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        storageDroneMenu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)storageDrone.upgrades, 3, 99, 54).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
    }

    @Override
    public void sendCompressItems(StorageDroneMenu droneMenu) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CompressItems(droneMenu.storageDrone.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void dismantle(int id) {
        PacketDistributor.sendToServer((CustomPacketPayload)new DismantleTurret(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void toggleMobility(Drone drone) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ToggleMobility(drone.getId(), !drone.isMoveable()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void claim(int id, UUID uuid) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ClaimTurret(id, uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void setBehavior(int id, Drone.Behavior behavior) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetBehavior(id, behavior), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void setMagnetState(int id, boolean state) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetMagnetState(id, state), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void openOptionsScreen(Turret turret) {
        this.openScreen(turret);
    }

    @Override
    public ItemContainer createBrickTurretAmmo() {
        return new ItemHandler(this, 27){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.BRICK_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public int getBrickUnitDelay() {
        return (Integer)KTurretsNeoforge.BRICK_TURRET_RATE.get();
    }

    @Override
    public int getBrickDamage() {
        return (Integer)KTurretsNeoforge.BRICK_DAMAGE.get();
    }

    @Override
    public void createBrickTurretSlots(BrickTurretContainer brickTurretContainer, BrickTurret turret) {
        int index = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                brickTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.ammo, index++, k * 18, j * 18));
            }
        }
        brickTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 0, 54, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        brickTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 1, 72, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        brickTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 2, 90, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
    }

    @Override
    public MenuType<BrickTurretContainer> getBrickTurretMenu() {
        return (MenuType)KTMenus.BRICK_TURRET.get();
    }

    @Override
    public int getBrickTurretDelay() {
        return (Integer)KTurretsNeoforge.BRICK_TURRET_RATE.get();
    }

    @Override
    public ItemContainer createBulletTurretAmmo() {
        return new ItemHandler(this, 27){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.BULLET_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public int getBulletTurretDelay() {
        return (Integer)KTurretsNeoforge.BULLET_TURRET_RATE.get();
    }

    @Override
    public int getBulletDamage() {
        return (Integer)KTurretsNeoforge.IRON_BULLET_DAMAGE.get();
    }

    @Override
    public void addBulletTurretSlots(Menu menu, BulletTurret turret) {
        int slot = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.ammo, slot++, k * 18, j * 18));
            }
        }
        menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 0, 54, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 1, 72, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 2, 90, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
    }

    @Override
    public MenuType<BulletTurretContainer> getBulletTurretMenu() {
        return (MenuType)KTMenus.BULLET_TURRET.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(Turret turret) {
        if (turret instanceof StorageDrone) {
            StorageDrone storageDrone = (StorageDrone)turret;
            Minecraft.getInstance().setScreen((Screen)new StorageDroneScreen(storageDrone));
        } else {
            Minecraft.getInstance().setScreen((Screen)new UnitSettingsScreen((Component)Component.translatable((String)"k_turrets.unit.options"), turret));
        }
    }

    @Override
    public ItemContainer createCobbleTurretAmmo() {
        return new ItemHandler(this, 27){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.COBBLE_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public int getCobbleTurretDelay() {
        return (Integer)KTurretsNeoforge.COBBLE_TURRET_RATE.get();
    }

    @Override
    public int getCobbleUnitDamage() {
        return (Integer)KTurretsNeoforge.COBBLE_TURRET_DAMAGE.get();
    }

    @Override
    public MenuType<CobbleTurretContainer> getCobbleTurretMenu() {
        return (MenuType)KTMenus.COBBLE_TURRET.get();
    }

    @Override
    public void addCobbleTurretSlots(CobbleTurretContainer cobbleTurretContainer, CobbleTurret cobbleTurret) {
        int index = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                cobbleTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleTurret.ammo, index++, k * 18, j * 18));
            }
        }
        cobbleTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleTurret.upgrades, 0, 54, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        cobbleTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleTurret.upgrades, 1, 72, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        cobbleTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleTurret.upgrades, 2, 90, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
    }

    @Override
    public ItemContainer createFireballTurretAmmo() {
        return new ItemHandler(this, 27){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.FIREBALL_UNIT_AMMO);
            }
        };
    }

    @Override
    public int getFireballUnitDamage() {
        return (Integer)KTurretsNeoforge.FIREBALL_TURRET_DAMAGE.get();
    }

    @Override
    public int getFireballTurretDelay() {
        return (Integer)KTurretsNeoforge.FIREBALL_TURRET_RATE.get();
    }

    @Override
    public MenuType<FireballTurretContainer> getFireballTurretMenu() {
        return (MenuType)KTMenus.FIREBALL_TURRET.get();
    }

    @Override
    public void addFireballTurretSlots(FireballTurretContainer fireballTurretContainer, FireballTurret turret) {
        int index = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                fireballTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.ammo, index++, k * 18, j * 18));
            }
        }
        fireballTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 0, 54, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        fireballTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 1, 72, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        fireballTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 2, 90, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
    }

    @Override
    public ItemContainer createGaussTurretAmmo() {
        return new ItemHandler(this, 27){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.GAUSS_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public MenuType<GaussTurretContainer> getGaussTurretMenu() {
        return (MenuType)KTMenus.GAUSS_TURRET.get();
    }

    @Override
    public void addGaussTurretSlots(GaussTurretContainer gaussTurretContainer, GaussTurret turret) {
        int ind = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                gaussTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.ammo, ind++, k * 18, j * 18));
            }
        }
        gaussTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 0, 54, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        gaussTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 1, 72, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
        gaussTurretContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)turret.upgrades, 2, 90, 54).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")).setColor(KTurrets.upgradeSlotColor));
    }

    @Override
    public int getGaussUnitDamage() {
        return (Integer)KTurretsNeoforge.GAUSS_TURRET_DAMAGE.get();
    }

    @Override
    public int getGaussUnitDelay() {
        return (Integer)KTurretsNeoforge.GAUSS_TURRET_RATE.get();
    }

    @Override
    public ItemContainer createArrowDroneWeaponInv() {
        return new ItemHandler(this, 1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.getItem() instanceof CrossbowItem || stack.getItem() instanceof BowItem;
            }
        };
    }

    @Override
    public ItemContainer createArrowDroneAmmo() {
        return new ItemHandler(this, 18){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.ARROW_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public MenuType<ArrowDroneContainer> getArrowDroneMenu() {
        return (MenuType)KTMenus.ARROW_DRONE.get();
    }

    @Override
    public void addArrowDroneSlots(Menu menu, ArrowDrone drone) {
        menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)drone.weapon, 0, 72, 0).setTooltip((Component)Component.translatable((String)"k_turrets.bow.or.crossbow")).setColor(Constants.GREEN));
        int slot = 0;
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 9; ++k) {
                menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)drone.ammo, slot++, k * 18, j * 18 + 36));
            }
        }
        MutableComponent upgrade = Component.translatable((String)"k_turrets.upgrade.slot");
        menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)drone.upgrades, 0, 36, 72).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)upgrade));
        menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)drone.upgrades, 1, 54, 72).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)upgrade));
        menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)drone.upgrades, 2, 72, 72).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)upgrade));
        menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)drone.upgrades, 3, 90, 72).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)upgrade));
        menu.addSlot((Slot)new ItemHandlerSlot((IItemHandler)drone.upgrades, 4, 108, 72).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)upgrade));
    }

    @Override
    public void checkAmmo(boolean b, int id, ServerLevel serverLevel, double x, double y, double z) {
        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)x, (double)y, (double)z, (double)Constants.MAX_DISTANCE_AT_WHICH_TEXT_IS_DISTINGUISHABLE, (CustomPacketPayload)new AmmoCheck(b, id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public MenuType<BrickDroneContainer> getBrickDroneMenu() {
        return (MenuType)KTMenus.BRICK_DRONE.get();
    }

    @Override
    public ItemContainer createBrickDroneAmmo() {
        return new ItemHandler(this, 18){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.BRICK_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public void addBrickDroneSlots(BrickDroneContainer brickDroneContainer, BrickDrone brickDrone) {
        int index = 0;
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 9; ++k) {
                brickDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)brickDrone.ammo, index++, k * 18, j * 18));
            }
        }
        brickDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)brickDrone.upgrades, 0, 36, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        brickDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)brickDrone.upgrades, 1, 54, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        brickDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)brickDrone.upgrades, 2, 72, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        brickDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)brickDrone.upgrades, 3, 90, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        brickDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)brickDrone.upgrades, 4, 108, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
    }

    @Override
    public ItemContainer createBulletDroneAmmo() {
        return new ItemHandler(this, 18){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.BULLET_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public MenuType<BulletDroneContainer> getBulletDroneMenu() {
        return (MenuType)KTMenus.BULLET_DRONE.get();
    }

    @Override
    public void addBulletDroneSlots(BulletDroneContainer bulletDroneContainer, BulletDrone bulletDrone) {
        int index = 0;
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 9; ++k) {
                bulletDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)bulletDrone.ammo, index++, k * 18, j * 18));
            }
        }
        bulletDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)bulletDrone.upgrades, 0, 36, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        bulletDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)bulletDrone.upgrades, 1, 54, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        bulletDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)bulletDrone.upgrades, 2, 72, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        bulletDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)bulletDrone.upgrades, 3, 90, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        bulletDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)bulletDrone.upgrades, 4, 108, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
    }

    @Override
    public MenuType<CobbleDroneContainer> getCobbleDroneMenu() {
        return (MenuType)KTMenus.COBBLE_DRONE.get();
    }

    @Override
    public void addCobbleDroneSlots(CobbleDroneContainer cobbleDroneContainer, CobbleDrone cobbleDrone) {
        int index = 0;
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 9; ++k) {
                cobbleDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleDrone.stone, index++, k * 18, j * 18));
            }
        }
        cobbleDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleDrone.upgrades, 0, 36, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        cobbleDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleDrone.upgrades, 1, 54, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        cobbleDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleDrone.upgrades, 2, 72, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        cobbleDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleDrone.upgrades, 3, 90, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        cobbleDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)cobbleDrone.upgrades, 4, 108, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
    }

    @Override
    public ItemContainer createCobbleDroneAmmo() {
        return new ItemHandler(this, 18){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.COBBLE_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public ItemContainer createFireballDroneAmmo() {
        return new ItemHandler(this, 18){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.FIREBALL_UNIT_AMMO);
            }
        };
    }

    @Override
    public MenuType<FireballDroneContainer> getFireballDroneMenu() {
        return (MenuType)KTMenus.FIREBALL_DRONE.get();
    }

    @Override
    public void addFireballDroneSlots(FireballDroneContainer fireballDroneContainer, FireballDrone fireballDrone) {
        int index = 0;
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 9; ++k) {
                fireballDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)fireballDrone.ammo, index++, k * 18, j * 18));
            }
        }
        fireballDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)fireballDrone.upgrades, 0, 36, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        fireballDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)fireballDrone.upgrades, 1, 54, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        fireballDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)fireballDrone.upgrades, 2, 72, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        fireballDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)fireballDrone.upgrades, 3, 90, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        fireballDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)fireballDrone.upgrades, 4, 108, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
    }

    @Override
    public ItemContainer createGaussDroneAmmo() {
        return new ItemHandler(this, 18){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.is(KTurrets.GAUSS_UNIT_AMMO_TAG);
            }
        };
    }

    @Override
    public MenuType<GaussDroneContainer> getGaussDroneMenu() {
        return (MenuType)KTMenus.GAUSS_DRONE.get();
    }

    @Override
    public void addGaussDroneSlots(GaussDroneContainer gaussDroneContainer, GaussDrone gaussDrone) {
        int index = 0;
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 9; ++k) {
                gaussDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)gaussDrone.ammo, index++, k * 18, j * 18));
            }
        }
        gaussDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)gaussDrone.upgrades, 0, 36, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        gaussDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)gaussDrone.upgrades, 1, 54, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        gaussDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)gaussDrone.upgrades, 2, 72, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        gaussDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)gaussDrone.upgrades, 3, 90, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
        gaussDroneContainer.addSlot((Slot)new ItemHandlerSlot((IItemHandler)gaussDrone.upgrades, 4, 108, 36).setColor(KTurrets.upgradeSlotColor).setTooltip((Component)Component.translatable((String)"k_turrets.upgrade.slot")));
    }

    @Override
    public void openReloaderScreen(Player player, ReloaderBlockEntity blockEntity, BlockPos blockPos) {
        player.openMenu((MenuProvider)blockEntity, byteBuf -> byteBuf.writeBlockPos(blockPos));
    }

    @Override
    public void sendSetMagnetMode(boolean state) {
        PacketDistributor.sendToServer((CustomPacketPayload)new MagnetFilterMode(state), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void initializeProperties() {
    }

    @Override
    public int getStorageDroneIntegrity() {
        return (Integer)KTurretsNeoforge.STORAGE_DRONE_HEALTH.get();
    }

    @Override
    public int getStorageDroneArmor() {
        return (Integer)KTurretsNeoforge.STORAGE_DRONE_ARMOR.get();
    }

    @Override
    public int getBulletTurretIntegrity() {
        return (Integer)KTurretsNeoforge.BULLET_TURRET_HEALTH.get();
    }

    @Override
    public int getBulletTurretArmor() {
        return (Integer)KTurretsNeoforge.BULLET_TURRET_ARMOR.get();
    }

    @Override
    public int getBulletTurretRange() {
        return (Integer)KTurretsNeoforge.BULLET_TURRET_RANGE.get();
    }

    @Override
    public int getFireballTurretIntegrity() {
        return (Integer)KTurretsNeoforge.FIREBALL_TURRET_HEALTH.get();
    }

    @Override
    public int getFireballTurretArmor() {
        return (Integer)KTurretsNeoforge.FIREBALL_TURRET_ARMOR.get();
    }

    @Override
    public int getFireballTurretRange() {
        return (Integer)KTurretsNeoforge.FIREBALL_TURRET_RANGE.get();
    }

    @Override
    public int getBrickTurretIntegrity() {
        return (Integer)KTurretsNeoforge.BRICK_TURRET_HEALTH.get();
    }

    @Override
    public int getBrickTurretArmor() {
        return (Integer)KTurretsNeoforge.BRICK_TURRET_ARMOR.get();
    }

    @Override
    public int getBrickTurretRange() {
        return (Integer)KTurretsNeoforge.BRICK_TURRET_RANGE.get();
    }

    @Override
    public int getGaussTurretIntegrity() {
        return (Integer)KTurretsNeoforge.GAUSS_TURRET_HEALTH.get();
    }

    @Override
    public int getGaussTurretArmor() {
        return (Integer)KTurretsNeoforge.GAUSS_TURRET_ARMOR.get();
    }

    @Override
    public int getGaussTurretRange() {
        return (Integer)KTurretsNeoforge.GAUSS_TURRET_RANGE.get();
    }

    @Override
    public int getCobbleTurretIntegrity() {
        return (Integer)KTurretsNeoforge.COBBLE_TURRET_HEALTH.get();
    }

    @Override
    public int getCobbleTurretArmor() {
        return (Integer)KTurretsNeoforge.COBBLE_TURRET_ARMOR.get();
    }

    @Override
    public int getCobbleTurretRange() {
        return (Integer)KTurretsNeoforge.COBBLE_TURRET_RANGE.get();
    }

    @Override
    public int getArrowTurretIntegrity() {
        return (Integer)KTurretsNeoforge.ARROW_TURRET_HEALTH.get();
    }

    @Override
    public int getArrowTurretArmor() {
        return (Integer)KTurretsNeoforge.ARROW_TURRET_ARMOR.get();
    }

    @Override
    public int getArrowTurretRange() {
        return (Integer)KTurretsNeoforge.ARROW_TURRET_RANGE.get();
    }

    @Override
    public void addPlayerException(int unit, String name) {
        PacketDistributor.sendToServer((CustomPacketPayload)new AddPlayerException(unit, name), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void removePlayerException(int unit, String name) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RemovePlayerException(unit, name), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void setTarget(int unitId, boolean state, String type) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetTarget(unitId, state, type), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendTargets(int unitId, CompoundTag compoundTag) {
        PacketDistributor.sendToServer((CustomPacketPayload)new TurretTargets(unitId, compoundTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void toggleMobility(int unitId, boolean mobility) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ToggleMobility(unitId, mobility), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void togglePlayerProtection(int unitId, boolean state) {
        PacketDistributor.sendToServer((CustomPacketPayload)new TogglePlayerProtection(unitId, state), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void setRefillInventory(int unitId, boolean refill) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetRefillInventory(unitId, refill), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendDismantle(int unit) {
        PacketDistributor.sendToServer((CustomPacketPayload)new DismantleTurret(unit), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public List<String> getDefaultTargets() {
        return KTurretsNeoforge.DEFAULT_TARGETS;
    }
}

