/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.projectiles;

import dev.buildtool.kturrets.KTDamageTypes;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.platform.Services;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class Arrow2
extends Arrow {
    public Arrow2(Level world, AbstractArrow abstractArrowEntity, Turret shooter, float f, float dx, float dy, float dz) {
        super(EntityType.ARROW, world);
        this.copyPosition((Entity)abstractArrowEntity);
        if (abstractArrowEntity instanceof SpectralArrow) {
            this.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200));
        } else if (abstractArrowEntity instanceof Arrow) {
            Arrow arrow = (Arrow)abstractArrowEntity;
            PotionContents potionContents = arrow.getPotionContents();
            potionContents.getAllEffects().forEach(arg_0 -> ((Arrow2)this).addEffect(arg_0));
        }
        this.setOwner(abstractArrowEntity.getOwner());
    }

    protected void onHitBlock(BlockHitResult p_36755_) {
        super.onHitBlock(p_36755_);
        this.discard();
    }

    protected boolean canHitEntity(Entity target) {
        Entity entity = this.getOwner();
        if (entity instanceof Turret) {
            Turret owner = (Turret)entity;
            if (target instanceof Player) {
                Player player = (Player)target;
                if (owner.getOwner().isPresent() && player.getUUID().equals(owner.getOwner().get())) {
                    return false;
                }
                return !target.isAlliedTo((Entity)owner);
            }
            if (target instanceof Turret) {
                Turret turret = (Turret)target;
                if (owner.getOwner().isPresent()) {
                    if (turret.getOwner().isPresent()) {
                        return !owner.getOwner().get().equals(turret.getOwner().get());
                    }
                    return true;
                }
                return true;
            }
            if (target.getType().getCategory().isFriendly()) {
                return target == owner.getTarget();
            }
            return Turret.decodeTargets(owner.getTargets()).contains(target.getType()) || target == owner.getTarget();
        }
        return false;
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Level var9;
        Entity entity = entityHitResult.getEntity();
        float f = (float)this.getDeltaMovement().length();
        double d = this.getBaseDamage();
        Entity shooter = this.getOwner();
        DamageSource damageSource = this.damageSources().source(KTDamageTypes.TURRET_ARROW, shooter);
        if (this.getWeaponItem() != null && (var9 = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var9;
            d = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damageSource, (float)((float)d));
        }
        if (this.isCritArrow()) {
            long l = this.random.nextInt((int)(d / 2.0 + 2.0));
            d = (int)Math.min(l + (long)d, Integer.MAX_VALUE);
        }
        if (shooter instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)shooter;
            livingEntity.setLastHurtMob(entity);
        }
        int j = entity.getRemainingFireTicks();
        if (this.isOnFire()) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damageSource, (float)d)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    livingEntity2.setArrowCount(livingEntity2.getArrowCount() + 1);
                }
                this.doKnockback(livingEntity2, damageSource);
                Level var13 = this.level();
                if (var13 instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)var13;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel2, (Entity)livingEntity2, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingEntity2);
                if (livingEntity2 != shooter && livingEntity2 instanceof Player && shooter instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)shooter).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
            }
            this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        } else {
            entity.setRemainingFireTicks(j);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                this.discard();
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.getDeltaMovement().length() < 0.01) {
            this.discard();
        }
    }

    public void shoot(double p_36775_, double p_36776_, double p_36777_, float p_36778_, float p_36779_) {
        double movementMultiplier = Services.PLATFORM.getProjectileSpeed();
        Vec3 vec3 = new Vec3(p_36775_, p_36776_, p_36777_).normalize().scale(movementMultiplier * 3.0);
        this.setDeltaMovement(vec3);
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }
}

