/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.projectiles;

import dev.buildtool.kturrets.KTDamageTypes;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.projectiles.Brick;
import dev.buildtool.kturrets.projectiles.Bullet;
import dev.buildtool.kturrets.projectiles.Cobblestone;
import dev.buildtool.kturrets.projectiles.GaussBullet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class PresetProjectile
extends AbstractHurtingProjectile {
    protected static final EntityDataAccessor<Integer> DAMAGE = SynchedEntityData.defineId(PresetProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public PresetProjectile(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
        this.accelerationPower *= (double)Services.PLATFORM.getProjectileSpeed();
    }

    public PresetProjectile(EntityType<? extends AbstractHurtingProjectile> entityType, LivingEntity owner, Vec3 movement, Level level) {
        super(entityType, owner, movement, level);
        this.accelerationPower *= (double)Services.PLATFORM.getProjectileSpeed();
        this.moveTo(owner.getX(), owner.getEyeY(), owner.getZ());
    }

    protected boolean shouldBurn() {
        return false;
    }

    public float getInertia() {
        return 1.0f;
    }

    protected void onHitBlock(BlockHitResult blockRayTraceResult) {
        super.onHitBlock(blockRayTraceResult);
        this.discard();
    }

    protected boolean canHitEntity(Entity target) {
        Entity entity = this.getOwner();
        if (entity instanceof Turret) {
            Turret shooter = (Turret)entity;
            if (target instanceof Player) {
                Player player = (Player)target;
                if (shooter.getOwner().isPresent() && player.getUUID().equals(shooter.getOwner().get())) {
                    return false;
                }
                return !target.isAlliedTo((Entity)shooter);
            }
            if (target instanceof Turret) {
                Turret turret = (Turret)target;
                if (shooter.getOwner().isPresent()) {
                    if (turret.getOwner().isPresent()) {
                        return !shooter.getOwner().get().equals(turret.getOwner().get());
                    }
                    return true;
                }
                return true;
            }
            if (target.getType().getCategory().isFriendly()) {
                return target == shooter.getTarget();
            }
            return Turret.decodeTargets(shooter.getTargets()).contains(target.getType()) || target == shooter.getTarget();
        }
        return false;
    }

    protected void onHitEntity(EntityHitResult entityRayTraceResult) {
        Entity entity = entityRayTraceResult.getEntity();
        Entity turret = this.getOwner();
        assert (turret != null);
        DamageSource damageSource = this.level().damageSources().mobAttack((LivingEntity)turret);
        PresetProjectile presetProjectile = this;
        Objects.requireNonNull(presetProjectile);
        PresetProjectile presetProjectile2 = presetProjectile;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Brick.class, Bullet.class, GaussBullet.class, Cobblestone.class}, (Object)((Object)presetProjectile2), n)) {
            case 0: {
                Brick brick = (Brick)presetProjectile2;
                damageSource = this.level().damageSources().source(KTDamageTypes.BRICK, turret);
                break;
            }
            case 1: {
                Bullet bullet = (Bullet)presetProjectile2;
                damageSource = this.level().damageSources().source(KTDamageTypes.BULLET, turret);
                break;
            }
            case 2: {
                GaussBullet gaussBullet = (GaussBullet)presetProjectile2;
                damageSource = this.level().damageSources().source(KTDamageTypes.GAUSS_BULLET, turret);
                break;
            }
            case 3: {
                Cobblestone cobblestone = (Cobblestone)presetProjectile2;
                damageSource = this.level().damageSources().source(KTDamageTypes.COBBLESTONE, turret);
                break;
            }
        }
        if (entity.hurt(damageSource, (float)this.getDamage())) {
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DAMAGE, (Object)0);
    }

    public void setDamage(int damage) {
        this.entityData.set(DAMAGE, (Object)damage);
    }

    public int getDamage() {
        return (Integer)this.entityData.get(DAMAGE);
    }

    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.putInt("Damage", this.getDamage());
    }

    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.setDamage(compoundNBT.getInt("Damage"));
    }
}

