/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.projectiles;

import dev.buildtool.kturrets.KTDamageTypes;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.platform.Services;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class SmallFireball2
extends SmallFireball {
    public SmallFireball2(Level level) {
        super(EntityType.SMALL_FIREBALL, level);
    }

    public SmallFireball2(Level level, LivingEntity owner, Vec3 movement) {
        super(level, owner, movement);
        this.accelerationPower *= (double)Services.PLATFORM.getProjectileSpeed();
    }

    protected boolean canHitEntity(Entity target) {
        Entity entity = this.getOwner();
        if (entity instanceof Turret) {
            Turret owner = (Turret)entity;
            if (target instanceof Player) {
                Player player = (Player)target;
                if (owner.getOwner().isPresent() && player.getUUID().equals(owner.getOwner().get())) {
                    return false;
                }
                return !target.isAlliedTo((Entity)owner);
            }
            if (target instanceof Turret) {
                Turret turret = (Turret)target;
                if (owner.getOwner().isPresent()) {
                    if (turret.getOwner().isPresent()) {
                        return !owner.getOwner().get().equals(turret.getOwner().get());
                    }
                    return true;
                }
                return true;
            }
            if (target.getType().getCategory().isFriendly()) {
                return target == owner.getTarget();
            }
            return Turret.decodeTargets(owner.getTargets()).contains(target.getType()) || target == owner.getTarget();
        }
        return false;
    }

    protected void onHitEntity(EntityHitResult p_213868_1_) {
        Entity entity;
        if (!this.level().isClientSide && !(entity = p_213868_1_.getEntity()).fireImmune()) {
            Entity turret = this.getOwner();
            int i = entity.getRemainingFireTicks();
            entity.igniteForSeconds(5.0f);
            DamageSource fireball = this.level().damageSources().source(KTDamageTypes.TURRET_FIREBALL, turret);
            boolean flag = entity.hurt(fireball, (float)Services.PLATFORM.getFireballUnitDamage());
            if (!flag) {
                entity.setRemainingFireTicks(i);
            } else {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)entity, (DamageSource)fireball);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }
}

