/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.registries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class KTDataComponents {
    public static HashMap<String, DataComponentType<?>> COMPONENTS = new HashMap();
    public static DataComponentType<AttachedNBT> ATTACHED_NBT = DataComponentType.builder().persistent(AttachedNBT.CODEC).build();
    public static DataComponentType<MagnetMode> MAGNET_MODE = DataComponentType.builder().persistent(MagnetMode.CODEC).build();
    public static DataComponentType<MagnetInventory> MAGNET_INVENTORY = DataComponentType.builder().persistent(MagnetInventory.CODEC).networkSynchronized(MagnetInventory.STREAM_CODEC).build();

    static {
        COMPONENTS.put("nbt", ATTACHED_NBT);
        COMPONENTS.put("magnet_mode", MAGNET_MODE);
        COMPONENTS.put("magnet_filters", MAGNET_INVENTORY);
    }

    public record AttachedNBT(CompoundTag compoundTag) {
        static final Codec<AttachedNBT> CODEC = RecordCodecBuilder.create(attachedNBTInstance -> attachedNBTInstance.group((App)CompoundTag.CODEC.fieldOf("compoundTag").forGetter(o -> o.compoundTag)).apply((Applicative)attachedNBTInstance, AttachedNBT::new));
    }

    public record MagnetMode(boolean state) {
        static final Codec<MagnetMode> CODEC = RecordCodecBuilder.create(magnetStateInstance -> magnetStateInstance.group((App)Codec.BOOL.fieldOf("mode").forGetter(o -> o.state)).apply((Applicative)magnetStateInstance, MagnetMode::new));
    }

    public record MagnetInventory(List<ItemStack> filters) {
        static final Codec<MagnetInventory> CODEC = RecordCodecBuilder.create(magnetInventoryInstance -> magnetInventoryInstance.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("filters").forGetter(o -> o.filters)).apply((Applicative)magnetInventoryInstance, MagnetInventory::new));
        static final StreamCodec<RegistryFriendlyByteBuf, MagnetInventory> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, MagnetInventory::filters, MagnetInventory::new);
    }
}

