/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.registries;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.buildtool.kturrets.ContainerItem;
import dev.buildtool.kturrets.Magnet;
import dev.buildtool.kturrets.TargetCopier;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.registries.KTBlocks;
import dev.buildtool.kturrets.registries.KTDataComponents;
import dev.buildtool.kturrets.registries.KTEntities;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;

public class KTItems {
    public static final HashMap<String, Supplier<Item>> ITEM_MAP = new HashMap();
    public static final Supplier<Item> TITANIUM_INGOT = Suppliers.memoize(() -> new Item(KTItems.defaults()));
    public static Supplier<Item> ARROW_TURRET = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.ARROW_TURRET.get(), 827911, 10657801, KTItems.defaults(), ContainerItem.Unit.TURRET){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getArrowDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + Services.PLATFORM.getArrowTurretIntegrity()));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + Services.PLATFORM.getArrowTurretArmor()));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getArrowTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getArrowUnitDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> BULLET = Suppliers.memoize(() -> new Item(KTItems.defaults()));
    public static Supplier<Item> STORAGE_DRONE = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.STORAGE_DRONE.get(), 0, 0, KTItems.defaults(), ContainerItem.Unit.DRONE){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + Services.PLATFORM.getStorageDroneIntegrity()));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + Services.PLATFORM.getStorageDroneArmor()));
        }
    });
    public static Supplier<Item> LIGHT_UPGRADE = Suppliers.memoize(() -> new Item(KTItems.defaults().stacksTo(4)));
    public static Supplier<Item> MAGNET_UPGRADE = Suppliers.memoize(() -> new Magnet(KTItems.defaults().stacksTo(4).component(KTDataComponents.MAGNET_MODE, (Object)new KTDataComponents.MagnetMode(false)).component(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)NonNullList.withSize((int)27, (Object)ItemStack.EMPTY)))));
    public static Supplier<Item> RECALL_UPGRADE = Suppliers.memoize(() -> new Item(KTItems.defaults().stacksTo(4)){

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.recall.description"));
        }
    });
    public static Supplier<Item> EXP_LINK = Suppliers.memoize(() -> new Item(KTItems.defaults().stacksTo(4)){

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.exp.link.info"));
        }
    });
    public static Supplier<Item> FIRE_SHIELD = Suppliers.memoize(() -> new Item(KTItems.defaults().stacksTo(4)){

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.fire.shield.info"));
        }
    });
    public static Supplier<Item> LOOTING_LINK = Suppliers.memoize(() -> new Item(KTItems.defaults().stacksTo(4)){

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.looting.link.info"));
        }
    });
    public static final Supplier<Item> COPPER_PLATE = Suppliers.memoize(() -> new Item(KTItems.defaults()));
    public static final Supplier<Item> BULLET_TURRET = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.BULLET_TURRET.get(), 10658208, 40610, KTItems.defaults(), ContainerItem.Unit.TURRET){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getBulletDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + Services.PLATFORM.getBulletTurretIntegrity()));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + Services.PLATFORM.getBulletTurretArmor()));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getBulletTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getBulletTurretDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> FIREBALL_TURRET = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.FIRE_BALL_TURRET.get(), 0, 10616837, KTItems.defaults(), ContainerItem.Unit.TURRET){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getFireballUnitDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + Services.PLATFORM.getFireballTurretIntegrity()));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + Services.PLATFORM.getFireballTurretArmor()));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getFireballTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getFireballTurretDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> BRICK_TURRET = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.BRICK_TURRET.get(), 721151, 16739330, KTItems.defaults(), ContainerItem.Unit.TURRET){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getBrickDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + Services.PLATFORM.getBrickTurretIntegrity()));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + Services.PLATFORM.getBrickTurretArmor()));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getBrickTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getBrickTurretDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static Supplier<Item> GAUSS_TURRET = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.GAUSS_TURRET.get(), 0xA0A0A0, 0x505050, KTItems.defaults(), ContainerItem.Unit.TURRET){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getGaussUnitDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + Services.PLATFORM.getGaussTurretIntegrity()));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + Services.PLATFORM.getGaussTurretArmor()));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getGaussTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getGaussUnitDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> COBBLE_TURRET = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.COBBLE_TURRET.get(), 4618123, 2968665, KTItems.defaults(), ContainerItem.Unit.TURRET){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getCobbleUnitDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + Services.PLATFORM.getCobbleTurretIntegrity()));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + Services.PLATFORM.getCobbleTurretArmor()));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getCobbleTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getCobbleTurretDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> BRICK_DRONE = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.BRICK_DRONE.get(), 16739330, 721151, KTItems.defaults(), ContainerItem.Unit.DRONE){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getBrickDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + String.format("%.1f", (double)Services.PLATFORM.getBrickTurretIntegrity() * 0.83)));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + String.format("%.1f", (double)Services.PLATFORM.getBrickTurretArmor() * 0.34)));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getBrickTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getBrickTurretDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> BULLET_DRONE = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.BULLET_DRONE.get(), 40610, 10658208, KTItems.defaults(), ContainerItem.Unit.DRONE){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getBulletDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + String.format("%.1f", (double)Services.PLATFORM.getBulletTurretIntegrity() * 0.83)));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + String.format("%.1f", (double)Services.PLATFORM.getBulletTurretArmor() * 0.34)));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getBulletTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getBulletTurretDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> COBBLE_DRONE = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.COBBLE_DRONE.get(), 2968665, 4618123, KTItems.defaults(), ContainerItem.Unit.DRONE){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getCobbleUnitDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + String.format("%.1f", (double)Services.PLATFORM.getCobbleTurretIntegrity() * 0.83)));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + String.format("%.1f", (double)Services.PLATFORM.getCobbleTurretArmor() * 0.34)));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getCobbleTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getCobbleTurretDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> ARROW_DRONE = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.ARROW_DRONE.get(), 10657801, 827911, KTItems.defaults(), ContainerItem.Unit.DRONE){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getArrowDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + String.format("%.1f", (double)Services.PLATFORM.getArrowTurretIntegrity() * 0.83)));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + String.format("%.1f", (double)Services.PLATFORM.getArrowTurretArmor() * 0.34)));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getArrowTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getArrowUnitDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> GAUSS_DRONE = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.GAUSS_DRONE.get(), 0x505050, 0xA0A0A0, KTItems.defaults(), ContainerItem.Unit.DRONE){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getGaussUnitDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + String.format("%.1f", (double)Services.PLATFORM.getGaussTurretIntegrity() * 0.83)));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + String.format("%.1f", (double)Services.PLATFORM.getGaussTurretArmor() * 0.34)));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getGaussTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getGaussUnitDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> FIREBALL_DRONE = Suppliers.memoize(() -> new ContainerItem((EntityType)KTEntities.FIREBALL_DRONE.get(), 10616837, 0, KTItems.defaults(), ContainerItem.Unit.DRONE){

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
            list.add((Component)Component.translatable((String)"k_turrets.damage.info").append(": " + Services.PLATFORM.getFireballUnitDamage()));
            list.add((Component)Component.translatable((String)"k_turrets.integrity").append(": " + String.format("%.1f", (double)Services.PLATFORM.getFireballTurretIntegrity() * 0.83)));
            list.add((Component)Component.translatable((String)"k_turrets.armor.info").append(": " + String.format("%.1f", (double)Services.PLATFORM.getFireballTurretArmor() * 0.34)));
            list.add((Component)Component.translatable((String)"k_turrets.range").append(": " + Services.PLATFORM.getFireballTurretRange()));
            list.add((Component)Component.translatable((String)"k_turrets.fire.rate").append(": " + String.format("%.1f", Float.valueOf(20.0f / (float)Services.PLATFORM.getFireballTurretDelay()))).append(" ").append((Component)Component.translatable((String)"k_turrets.shots.per.second")));
        }
    });
    public static final Supplier<Item> GAUSS_BULLET = Suppliers.memoize(() -> new Item(KTItems.defaults()));
    public static final Supplier<Item> EXPLOSIVE_POWDER = Suppliers.memoize(() -> new Item(KTItems.defaults()));
    public static final Supplier<Item> TITANIUM_ORE = Suppliers.memoize(() -> new BlockItem((Block)KTBlocks.TITANIUM_ORE.get(), KTItems.defaults()));
    public static final Supplier<Item> DEEPSLATE_TITANIUM_ORE = Suppliers.memoize(() -> new BlockItem((Block)KTBlocks.DEEPSLATE_TITANIUM_ORE.get(), KTItems.defaults()));
    public static final Supplier<Item> RAW_TITANIUM = Suppliers.memoize(() -> new Item(KTItems.defaults()));
    public static final Supplier<Item> TARGET_COPIER = Suppliers.memoize(() -> new TargetCopier(KTItems.defaults().stacksTo(1)));
    public static final Supplier<Item> RELOADER = Suppliers.memoize(() -> new BlockItem((Block)KTBlocks.RELOADER.get(), KTItems.defaults()));

    private static Item.Properties defaults() {
        return new Item.Properties();
    }

    static {
        ITEM_MAP.put("arrow_turret_item", ARROW_TURRET);
        ITEM_MAP.put("titanium_ingot", TITANIUM_INGOT);
        ITEM_MAP.put("light_upgrade", LIGHT_UPGRADE);
        ITEM_MAP.put("magnet_upgrade", MAGNET_UPGRADE);
        ITEM_MAP.put("recall_upgrade", RECALL_UPGRADE);
        ITEM_MAP.put("fire_shield", FIRE_SHIELD);
        ITEM_MAP.put("exp_link", EXP_LINK);
        ITEM_MAP.put("looting_link", LOOTING_LINK);
        ITEM_MAP.put("storage_drone", STORAGE_DRONE);
        ITEM_MAP.put("bullet", BULLET);
        ITEM_MAP.put("gauss_bullet", GAUSS_BULLET);
        ITEM_MAP.put("explosive_powder", EXPLOSIVE_POWDER);
        ITEM_MAP.put("brick_turret_item", BRICK_TURRET);
        ITEM_MAP.put("bullet_turret_item", BULLET_TURRET);
        ITEM_MAP.put("cobble_turret_item", COBBLE_TURRET);
        ITEM_MAP.put("fireball_turret_item", FIREBALL_TURRET);
        ITEM_MAP.put("gauss_turret_item", GAUSS_TURRET);
        ITEM_MAP.put("arrow_drone_item", ARROW_DRONE);
        ITEM_MAP.put("brick_drone_item", BRICK_DRONE);
        ITEM_MAP.put("bullet_drone_item", BULLET_DRONE);
        ITEM_MAP.put("cobble_drone_item", COBBLE_DRONE);
        ITEM_MAP.put("fireball_drone_item", FIREBALL_DRONE);
        ITEM_MAP.put("gauss_drone_item", GAUSS_DRONE);
        ITEM_MAP.put("reloader", RELOADER);
        ITEM_MAP.put("titanium_ore", TITANIUM_ORE);
        ITEM_MAP.put("deepslate_titanium_ore", DEEPSLATE_TITANIUM_ORE);
        ITEM_MAP.put("target_copier", TARGET_COPIER);
        ITEM_MAP.put("raw_titanium", RAW_TITANIUM);
        ITEM_MAP.put("copper_plate", COPPER_PLATE);
    }
}

