/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.buildtool.kturrets.models.BulletModel;
import dev.buildtool.kturrets.projectiles.Bullet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class BulletRenderer
extends EntityRenderer<Bullet> {
    private static final ResourceLocation IRON = ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"textures/entity/iron_bullet.png");
    private final BulletModel<Bullet> bulletModel;

    public BulletRenderer(EntityRendererProvider.Context rendererManager) {
        super(rendererManager);
        this.shadowRadius = 0.0f;
        this.bulletModel = new BulletModel(rendererManager.bakeLayer(BulletModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(Bullet p_110775_1_) {
        return IRON;
    }

    public void render(Bullet bullet, float yaw, float partialTick, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLight) {
        super.render((Entity)bullet, yaw, partialTick, matrixStack, renderTypeBuffer, packedLight);
        matrixStack.pushPose();
        matrixStack.translate(0.0, -1.4, 0.0);
        this.bulletModel.setupAnim(bullet, 0.0f, 0.0f, partialTick, yaw, 0.0f);
        this.bulletModel.renderToBuffer(matrixStack, renderTypeBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(bullet))), packedLight, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }
}

