/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.buildtool.kturrets.models.GaussBulletModel;
import dev.buildtool.kturrets.projectiles.GaussBullet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class GaussBulletRenderer
extends EntityRenderer<GaussBullet> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"k_turrets", (String)"textures/entity/gauss_bullet.png");
    private final GaussBulletModel<GaussBullet> bulletModel;

    public GaussBulletRenderer(EntityRendererProvider.Context p_i46179_1_) {
        super(p_i46179_1_);
        this.shadowRadius = 0.0f;
        this.bulletModel = new GaussBulletModel(p_i46179_1_.bakeLayer(new ModelLayerLocation(TEXTURE, "main")));
    }

    public ResourceLocation getTextureLocation(GaussBullet p_110775_1_) {
        return TEXTURE;
    }

    public void render(GaussBullet bullet, float yaw, float partialTick, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLight) {
        super.render((Entity)bullet, yaw, partialTick, matrixStack, renderTypeBuffer, packedLight);
        matrixStack.pushPose();
        matrixStack.translate(0.0, -1.4, 0.0);
        this.bulletModel.setupAnim(bullet, 0.0f, 0.0f, partialTick, yaw, 0.0f);
        this.bulletModel.renderToBuffer(matrixStack, renderTypeBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(bullet))), packedLight, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }
}

