/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.screens;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.drones.StorageDrone;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.registries.KTItems;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import dev.buildtool.satako.client.gui.BetterButton;
import dev.buildtool.satako.client.gui.Screen2;
import dev.buildtool.satako.client.gui.SwitchButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;

public class StorageDroneScreen
extends Screen2 {
    private final StorageDrone drone;

    public StorageDroneScreen(Drone drone) {
        super((Component)Component.translatable((String)"k_turrets.storage.drone"));
        this.drone = (StorageDrone)drone;
    }

    public void init() {
        super.init();
        MutableComponent dismantle = Component.translatable((String)"k_turrets.dismantle");
        this.addRenderableWidget((GuiEventListener)new BetterButton(this.centerX - this.font.width(dismantle.getString()) / 2, this.centerY - 40, (Component)dismantle, p_onPress_1_ -> {
            Services.PLATFORM.dismantle(this.drone.getId());
            this.minecraft.player.closeContainer();
        }));
        MutableComponent switchB = Component.translatable((String)"k_turrets.immobile");
        this.addRenderableWidget((GuiEventListener)new SwitchButton(this.centerX - this.font.width(switchB.getString()) / 2, this.centerY - 20, (Component)Component.translatable((String)"k_turrets.mobile"), (Component)switchB, this.drone.isMoveable(), p_onPress_1_ -> {
            Services.PLATFORM.toggleMobility(this.drone);
            this.drone.setMoveable(!this.drone.isMoveable());
        }));
        if (!this.drone.getOwner().isPresent()) {
            MutableComponent claim = Component.translatable((String)"k_turrets.claim.drone");
            this.addRenderableWidget((GuiEventListener)new BetterButton(this.centerX - this.font.width((FormattedText)claim) / 2, this.centerY + 20, (Component)claim, p_onPress_1_ -> {
                Services.PLATFORM.claim(this.drone.getId(), this.minecraft.player.getUUID());
                this.drone.setOwner(this.minecraft.player.getUUID());
                this.minecraft.player.closeContainer();
            }));
        } else {
            MutableComponent follow = Component.translatable((String)"k_turrets.following.owner");
            SwitchButton toggle = new SwitchButton(this.centerX - this.font.width((FormattedText)follow) / 2, this.centerY, (Component)follow, (Component)Component.translatable((String)"k_turrets.staying"), this.drone.getBehavior() == Drone.Behavior.FOLLOW_AND_ATTACK, pButton -> {
                SwitchButton switchButton = (SwitchButton)pButton;
                if (switchButton.state) {
                    this.drone.setBehavior(Drone.Behavior.FOLLOW_AND_ATTACK);
                    Services.PLATFORM.setBehavior(this.drone.getId(), Drone.Behavior.FOLLOW_AND_ATTACK);
                } else {
                    this.drone.setBehavior(Drone.Behavior.STAY);
                    Services.PLATFORM.setBehavior(this.drone.getId(), Drone.Behavior.STAY);
                }
            });
            this.addRenderableWidget((GuiEventListener)toggle);
        }
        if (!Functions.findItem((Item)((Item)KTItems.MAGNET_UPGRADE.get()), (ItemContainer)this.drone.upgrades).isEmpty()) {
            MutableComponent magnetOff = Component.translatable((String)"k_turrets.magnetOff.off");
            this.addRenderableWidget((GuiEventListener)new SwitchButton(this.centerX - this.font.width(magnetOff.getString()) / 2, this.centerY + 20, (Component)Component.translatable((String)"k_turrets.magnetOff.on"), (Component)magnetOff, this.drone.isMagnetActive(), pButton -> {
                SwitchButton switchButton = (SwitchButton)pButton;
                this.drone.setMagnetActive(switchButton.state);
                Services.PLATFORM.setMagnetState(this.drone.getId(), switchButton.state);
            }));
        }
    }
}

