/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.tasks;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.Turret;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class AttackTargetGoal
extends NearestAttackableTargetGoal<LivingEntity> {
    private final Turret turret;

    public AttackTargetGoal(Turret turret) {
        super((Mob)turret, LivingEntity.class, 0, true, true, livingEntity -> {
            if (livingEntity instanceof Player) {
                if (turret.isProtectingFromPlayers()) {
                    return turret.alienPlayers.test((LivingEntity)livingEntity);
                }
                return false;
            }
            return Turret.decodeTargets(turret.getTargets()).contains(livingEntity.getType());
        });
        this.turret = turret;
    }

    public boolean canUse() {
        Turret turret = this.turret;
        if (turret instanceof Drone) {
            Drone drone = (Drone)turret;
            return (drone.getBehavior() == Drone.Behavior.GUARD || drone.getBehavior() == Drone.Behavior.FOLLOW_AND_ATTACK) && drone.isArmed() && super.canUse();
        }
        return this.turret.isArmed() && super.canUse();
    }

    public boolean canContinueToUse() {
        Turret turret = this.turret;
        if (turret instanceof Drone) {
            Drone drone = (Drone)turret;
            return (drone.getBehavior() == Drone.Behavior.GUARD || drone.getBehavior() == Drone.Behavior.FOLLOW_AND_ATTACK) && drone.isArmed() && super.canContinueToUse();
        }
        return this.turret.isArmed() && super.canContinueToUse();
    }

    protected AABB getTargetSearchArea(double p_26069_) {
        return this.mob.getBoundingBox().inflate(p_26069_, p_26069_, p_26069_);
    }
}

