/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.tasks;

import dev.buildtool.kturrets.Drone;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class AvoidAggressors
extends Goal {
    private final Drone drone;

    public AvoidAggressors(Drone drone) {
        this.drone = drone;
    }

    public boolean canUse() {
        Player owner = this.drone.level().getPlayerByUUID(this.drone.getOwnerUUID());
        if (owner != null) {
            List aggressors = this.drone.level().getEntitiesOfClass(Mob.class, this.drone.getBoundingBox().inflate(5.0), mob -> mob.getTarget() == owner);
            Optional<Mob> aggressor = aggressors.stream().filter(mob -> mob.distanceTo((Entity)this.drone) < 3.0f).findAny();
            return aggressor.isPresent();
        }
        return false;
    }

    public void tick() {
        this.drone.getMoveControl().strafe(5.0f, 0.0f);
    }
}

