/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.tasks;

import dev.buildtool.kturrets.Drone;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class FollowOwnerGoal
extends Goal {
    protected Drone drone;
    protected Level level;

    public FollowOwnerGoal(Drone drone) {
        this.drone = drone;
        this.level = drone.level();
    }

    public boolean canUse() {
        return (this.drone.getBehavior() == Drone.Behavior.FOLLOW_AND_ATTACK || this.drone.getBehavior() == Drone.Behavior.FOLLOW_ONLY) && this.drone.getOwner().isPresent();
    }

    public void tick() {
        this.drone.getOwner().ifPresent(uuid -> {
            Player player = this.level.getPlayerByUUID(uuid);
            if (player != null) {
                if (this.drone.distanceToSqr((Entity)player) > 25.0) {
                    this.drone.getNavigation().moveTo(player.getX(), player.getY() + 2.0, player.getZ(), 1.0);
                } else if (this.drone.getNavigation().isInProgress()) {
                    this.drone.getNavigation().stop();
                }
            }
        });
    }
}

