/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.tasks;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.platform.Services;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;

public class RestrictedRangedAttackGoal
extends RangedAttackGoal {
    private Drone drone;

    public RestrictedRangedAttackGoal(RangedAttackMob p_25768_, double speed, int attackInterval, float attackRadius) {
        super(p_25768_, speed, attackInterval, attackRadius);
        this.drone = (Drone)p_25768_;
    }

    public void tick() {
        Player owner = this.drone.level().getPlayerByUUID(this.drone.getOwnerUUID());
        if (owner == null) {
            this.work();
        } else {
            float distanceToPlayer = this.drone.distanceTo((Entity)owner);
            if (distanceToPlayer < (float)Services.PLATFORM.getFollowOwnerDistance()) {
                this.work();
            } else if (this.drone.getTarget() != null) {
                this.drone.setTarget(null);
                this.drone.getNavigation().moveTo((Entity)owner, 1.0);
            }
        }
    }

    private void work() {
        double d0 = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean flag = this.mob.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo(this.target.getX(), this.target.getY() + 3.0, this.target.getZ(), 1.0);
        }
        this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = (float)Math.sqrt(d0) / this.attackRadius;
            float f1 = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.performRangedAttack(this.target, f1);
            this.attackTime = Mth.floor((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }
}

