/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.turrets;

import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.menus.ArrowTurretContainer;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.projectiles.Arrow2;
import dev.buildtool.kturrets.registries.KTEntities;
import dev.buildtool.kturrets.tasks.AttackTargetGoal;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ArrowTurret
extends Turret {
    public final ItemContainer weapon = Services.PLATFORM.createArrowTurretWeaponInv();
    public final ItemContainer ammo = Services.PLATFORM.createArrowTurretInventory();

    public ArrowTurret(Level world) {
        super((EntityType<? extends PathfinderMob>)Functions.cast((EntityType)((EntityType)KTEntities.ARROW_TURRET.get())), world);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            ItemStack weapon = this.weapon.getStackInSlot(0);
            if (weapon.isEmpty()) {
                weapon = new ItemStack((ItemLike)Items.BOW);
            }
            for (ItemStack arrows : this.ammo.getItems()) {
                if (arrows.isEmpty()) continue;
                AbstractArrow arrowEntity = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)arrows, (float)distanceFactor, (ItemStack)weapon);
                double dx = target.getX() - this.getX();
                double dy = target.getEyeY() - this.getEyeY();
                double dz = target.getZ() - this.getZ();
                double damage = Services.PLATFORM.getArrowDamage();
                arrowEntity.setBaseDamage(damage);
                Arrow2 arrow2 = new Arrow2(this.level(), arrowEntity, this, distanceFactor, (float)dx, (float)dy, (float)dz);
                arrow2.setBaseDamage(arrowEntity.getBaseDamage());
                Registry enchantmentRegistry = this.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                if (weapon.getItem() instanceof CrossbowItem) {
                    arrow2.shotFromCrossbow();
                    int i = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)enchantmentRegistry.getHolder(Enchantments.PIERCING).get()), (ItemStack)weapon);
                    if (i > 0) {
                        arrow2.setPierceLevel((byte)i);
                    }
                }
                arrow2.setNoGravity(true);
                arrow2.shoot(dx, dy, dz, 1.8f, 0.0f);
                this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
                this.level().addFreshEntity((Entity)arrow2);
                arrows.shrink(1);
                ItemEnchantments enchantments = weapon.getEnchantments();
                int inf = enchantments.getLevel((Holder)enchantmentRegistry.getHolder(Enchantments.INFINITY).get());
                int multi = enchantments.getLevel((Holder)enchantmentRegistry.getHolder(Enchantments.MULTISHOT).get());
                if (inf != 0 || multi != 0) break;
                weapon.hurtAndBreak(1, (LivingEntity)this, EquipmentSlot.MAINHAND);
                break;
            }
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.weapon.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compoundNBT.getCompound("Weapon"));
        this.ammo.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compoundNBT.getCompound("Ammo"));
    }

    @Override
    public List<ItemContainer> getContainedItems() {
        return Arrays.asList(this.ammo, this.weapon, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return !this.ammo.isEmpty();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.put("Ammo", (Tag)this.ammo.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compoundNBT.put("Weapon", (Tag)this.weapon.serializeNBT((HolderLookup.Provider)this.registryAccess()));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        FriendlyByteBuf packetBuffer = Functions.emptyBuffer();
        packetBuffer.writeInt(this.getId());
        return new ArrowTurretContainer(p_createMenu_1_, p_createMenu_2_, packetBuffer, 0);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.0, Services.PLATFORM.getArrowUnitDelay(), (float)this.getRange()));
        this.targetSelector.addGoal(5, (Goal)new AttackTargetGoal(this));
    }

    @Override
    public ItemStack getItemBySlot(EquipmentSlot p_184582_1_) {
        return this.weapon.getStackInSlot(0);
    }

    @Override
    public int getDamage() {
        return Services.PLATFORM.getArrowDamage();
    }
}

