/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.turrets;

import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.menus.BulletTurretContainer;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.projectiles.Bullet;
import dev.buildtool.kturrets.registries.KTEntities;
import dev.buildtool.kturrets.registries.Sounds;
import dev.buildtool.kturrets.tasks.AttackTargetGoal;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BulletTurret
extends Turret {
    public final ItemContainer ammo = Services.PLATFORM.createBulletTurretAmmo();

    public BulletTurret(Level world) {
        super((EntityType<? extends PathfinderMob>)Functions.cast((EntityType)((EntityType)KTEntities.BULLET_TURRET.get())), world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.0, Services.PLATFORM.getBulletTurretDelay(), (float)this.getRange()));
        this.targetSelector.addGoal(5, (Goal)new AttackTargetGoal(this));
    }

    public void performRangedAttack(LivingEntity livingEntity, float v) {
        if (livingEntity.isAlive()) {
            for (ItemStack item : this.ammo.getItems()) {
                if (item.isEmpty()) continue;
                double d0 = livingEntity.getX() - this.getX();
                double d1 = livingEntity.getEyeY() - this.getEyeY();
                double d2 = livingEntity.getZ() - this.getZ();
                Bullet bullet = new Bullet((LivingEntity)this, new Vec3(d0, d1, d2), this.level());
                this.level().addFreshEntity((Entity)bullet);
                bullet.setDamage(Services.PLATFORM.getBulletDamage());
                this.playSound((SoundEvent)Sounds.BULLET_FIRE.get(), 1.0f, 1.0f);
                item.shrink(1);
                break;
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        FriendlyByteBuf packetBuffer = Functions.emptyBuffer();
        packetBuffer.writeInt(this.getId());
        return new BulletTurretContainer(i, playerInventory, packetBuffer, 0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.put("Ammo", (Tag)this.ammo.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.ammo.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compoundNBT.getCompound("Ammo"));
    }

    @Override
    public List<ItemContainer> getContainedItems() {
        return List.of(this.ammo, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return !this.ammo.isEmpty();
    }

    @Override
    public int getDamage() {
        return Services.PLATFORM.getBulletDamage();
    }
}

