/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.turrets;

import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.menus.GaussTurretContainer;
import dev.buildtool.kturrets.platform.Services;
import dev.buildtool.kturrets.projectiles.GaussBullet;
import dev.buildtool.kturrets.registries.KTEntities;
import dev.buildtool.kturrets.registries.Sounds;
import dev.buildtool.kturrets.tasks.AttackTargetGoal;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.ItemContainer;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GaussTurret
extends Turret {
    public ItemContainer ammo = Services.PLATFORM.createGaussTurretAmmo();

    public GaussTurret(Level world) {
        super((EntityType<? extends PathfinderMob>)Functions.cast((EntityType)((EntityType)KTEntities.GAUSS_TURRET.get())), world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.0, Services.PLATFORM.getGaussUnitDelay(), (float)this.getRange()));
        this.targetSelector.addGoal(5, (Goal)new AttackTargetGoal(this));
    }

    @Override
    public List<ItemContainer> getContainedItems() {
        return List.of(this.ammo, this.upgrades);
    }

    @Override
    public boolean isArmed() {
        return !this.ammo.isEmpty();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            for (ItemStack item : this.ammo.getItems()) {
                if (item.isEmpty()) continue;
                this.playSound((SoundEvent)Sounds.GAUSS_SHOT.get(), 1.5f, 1.0f);
                item.shrink(1);
                double xa = target.getX() - this.getX();
                double ya = target.getEyeY() - this.getEyeY();
                double za = target.getZ() - this.getZ();
                GaussBullet gaussBullet = new GaussBullet((LivingEntity)this, new Vec3(xa, ya, za), this.level());
                gaussBullet.setDamage(Services.PLATFORM.getGaussUnitDamage());
                gaussBullet.setPos(this.getX(), this.getEyeY(), this.getZ());
                this.level().addFreshEntity((Entity)gaussBullet);
                break;
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        FriendlyByteBuf buffer = Functions.emptyBuffer();
        buffer.writeInt(this.getId());
        return new GaussTurretContainer(p_createMenu_1_, p_createMenu_2_, buffer, 0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compoundNBT) {
        super.addAdditionalSaveData(compoundNBT);
        compoundNBT.put("Ammo", (Tag)this.ammo.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        super.readAdditionalSaveData(compoundNBT);
        this.ammo.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compoundNBT.getCompound("Ammo"));
    }

    @Override
    public int getDamage() {
        return Services.PLATFORM.getGaussUnitDamage();
    }
}

