/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.colorpicker;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;

public class ColorPickerButton
extends PopupButton<ColorPickerScreen.ColorPickerResponse> {
    final DynamicTexture colorWheel = TextureCache.getTexture(TextureCache.ColorWheel);

    public ColorPickerButton(int width, int height, IntSupplier color, PopupButtonScreen.OnClose<ColorPickerScreen.ColorPickerResponse> onClose) {
        this(width, height, color, () -> false, onClose);
    }

    public ColorPickerButton(int width, int height, IntSupplier color, BooleanSupplier withAlpha, PopupButtonScreen.OnClose<ColorPickerScreen.ColorPickerResponse> onClose) {
        super(width, height, (Component)Component.literal((String)""), () -> new ColorPickerScreen((Component)Constants.getTranslatedTextComponent(""), color.getAsInt(), withAlpha.getAsBoolean()), onClose);
        this.init();
    }

    void init() {
        this.setTooltip(Constants.getString("jm.common.button.colorwheel.tooltip"));
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        DrawUtil.drawQuad(graphics, this.colorWheel, this.getX() + 3, this.getY() + 3, this.getWidth() - 6, this.getHeight() - 6, false, 0.0);
    }
}

