/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.properties.catagory.Category;

public class MultiplayerCategories {
    private static int order = 1;
    public static final Category Multiplayer = MultiplayerCategories.create("Multiplayer", "base category", "base category", () -> true);
    public static final Category Radar = MultiplayerCategories.create("Radar", "jm.options.multiplayer.category.radar", "jm.options.multiplayer.category.radar.tooltip", () -> JourneymapClient.getInstance().getStateHandler().isExpandedRadarEnabled());
    public static final Category Debug = MultiplayerCategories.create("Debug", "jm.options.multiplayer.category.debug", "jm.options.multiplayer.category.admin.debug", () -> JourneymapClient.getInstance().getStateHandler().isServerAdmin());
    public static final List<Category> values = Arrays.asList(Category.Inherit, Category.Hidden, Radar);

    public static Category valueOf(String name) {
        for (Category category : values) {
            if (!category.getName().equalsIgnoreCase(name)) continue;
            return category;
        }
        return null;
    }

    private static Category create(String name, String label, Supplier<Boolean> enabled) {
        return MultiplayerCategories.create(name, label, null, enabled);
    }

    public static Category create(String name, String label, String tooltip, Supplier<Boolean> enabled) {
        return new MultiplayerCategory(name, order++, label, tooltip, enabled);
    }

    public static class MultiplayerCategory
    extends Category {
        final Supplier<Boolean> enabled;

        public MultiplayerCategory(String name, int order, String label, Supplier<Boolean> enabled) {
            super(name, order, label);
            this.enabled = enabled;
        }

        public MultiplayerCategory(String name, int order, String label, boolean unique, Supplier<Boolean> enabled) {
            super(name, order, label, unique);
            this.enabled = enabled;
        }

        public MultiplayerCategory(String name, int order, String label, String tooltip, Supplier<Boolean> enabled) {
            super(name, order, label, tooltip);
            this.enabled = enabled;
        }

        public boolean enabled() {
            return this.enabled.get();
        }
    }
}

