/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.JourneymapClient;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.ExternalWaypointFinder;
import journeymap.client.waypoint.PlayerPoint;
import journeymap.client.waypoint.WaypointHandler;
import journeymap.common.Journeymap;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.util.PlayerRadarManager;
import journeymap.common.waypoint.WaypointEventManager;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
public class WaypointStore {
    private static WaypointStore INSTANCE;
    private final Map<String, ClientWaypointImpl> waypointMap = new LinkedHashMap<String, ClientWaypointImpl>();
    private ExternalWaypointFinder externalWaypoints;
    private final Set<String> dimensions = new HashSet<String>();
    private final Set<ClientWaypointImpl> playerPoints = new HashSet<ClientWaypointImpl>();

    public static WaypointStore getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WaypointStore();
        }
        return INSTANCE;
    }

    public List<ClientWaypointImpl> getAll(String modId) {
        if (modId != null) {
            return this.waypointMap.values().stream().filter(wp -> modId.equals(wp.getModId())).toList();
        }
        return Collections.emptyList();
    }

    public Collection<ClientWaypointImpl> getAll() {
        try {
            return Collections.synchronizedCollection(this.waypointMap.values());
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error getting all waypoints. Thread:" + Thread.currentThread().getName(), t);
            return Collections.emptyList();
        }
    }

    public Collection<ClientWaypointImpl> getPlayerPoints() {
        if (PlayerRadarManager.getInstance().getPlayers().size() != this.playerPoints.size() && JourneymapClient.getInstance().getWaypointProperties().showPlayers.get().booleanValue()) {
            this.playerPoints.clear();
            PlayerRadarManager.getInstance().getPlayers().forEach((uuid, player) -> {
                try {
                    this.playerPoints.add(new PlayerPoint((Player)player));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        return this.playerPoints;
    }

    public void save(ClientWaypointImpl waypoint, boolean isNew) {
        this.save(waypoint, true, isNew);
    }

    public void bulkAdd(List<ClientWaypointImpl> waypoints) {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        waypoints.forEach(waypoint -> {
            if (!this.isDuplicate((ClientWaypointImpl)waypoint)) {
                this.waypointMap.put(waypoint.getGuid(), (ClientWaypointImpl)waypoint);
                if (waypoint.isPersistent()) {
                    dao.addWaypoint((WaypointImpl)waypoint);
                }
                waypoint.setDirty(false);
            }
        });
        WaypointHandler.getInstance().getDao().save(true);
    }

    private boolean isDuplicate(ClientWaypointImpl waypoint) {
        for (ClientWaypointImpl wp : this.waypointMap.values()) {
            if (wp.getX() != waypoint.getX() || wp.getY() != waypoint.getY() || wp.getZ() != waypoint.getZ() || !wp.getGroupId().equalsIgnoreCase(waypoint.getGroupId()) || !wp.getPrimaryDimension().equalsIgnoreCase(waypoint.getPrimaryDimension())) continue;
            return true;
        }
        return false;
    }

    public void save(ClientWaypointImpl waypoint, boolean fireEvent, boolean isNew) {
        if (isNew && this.isDuplicate(waypoint)) {
            return;
        }
        if (waypoint.isDirty()) {
            WaypointDAO dao = WaypointHandler.getInstance().getDao();
            this.waypointMap.put(waypoint.getGuid(), waypoint);
            if (fireEvent) {
                if (isNew) {
                    WaypointEventManager.createWaypointEvent(waypoint);
                } else {
                    WaypointEventManager.updateWaypointEvent(waypoint);
                }
            }
            if (waypoint.isPersistent()) {
                dao.addWaypoint(waypoint);
                WaypointHandler.getInstance().getDao().save(true);
            }
            waypoint.setDirty(false);
        }
    }

    public void bulkSave() {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        for (ClientWaypointImpl waypoint : this.waypointMap.values()) {
            WaypointEventManager.updateWaypointEvent(waypoint);
            if (!waypoint.isPersistent() || !waypoint.isDirty()) continue;
            waypoint.setDirty(false);
            dao.addWaypoint(waypoint);
        }
        dao.save(true);
    }

    public ClientWaypointImpl get(String id) {
        return this.waypointMap.get(id);
    }

    public void remove(ClientWaypointImpl waypoint, boolean fireEvent) {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        this.waypointMap.remove(waypoint.getGuid());
        if (waypoint.isPersistent()) {
            if (fireEvent) {
                WaypointEventManager.deleteWaypointEvent(waypoint);
            }
            dao.deleteWaypoint(waypoint);
            dao.save(true);
        }
    }

    public void remove(WaypointGroup group) {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        if (group != null) {
            group.getWaypointIds().forEach(id -> {
                ClientWaypointImpl waypoint = this.get((String)id);
                this.waypointMap.remove(waypoint.getGuid());
                if (waypoint.isPersistent()) {
                    WaypointEventManager.deleteWaypointEvent(waypoint);
                    dao.deleteWaypoint(waypoint);
                }
            });
        }
    }

    public void reset() {
        this.playerPoints.clear();
        this.waypointMap.clear();
        this.dimensions.clear();
        this.externalWaypoints = new ExternalWaypointFinder();
        if (JourneymapClient.getInstance().getWaypointProperties().managerEnabled.get().booleanValue()) {
            this.load();
        }
    }

    public ExternalWaypointFinder getExternalWaypoints() {
        if (this.externalWaypoints == null) {
            this.externalWaypoints = new ExternalWaypointFinder();
        }
        return this.externalWaypoints;
    }

    private void load() {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        Map<String, WaypointImpl> waypoints = dao.getWaypoints();
        Journeymap.getLogger().info("Loaded {} waypoints from disk.", (Object)waypoints.size());
        for (WaypointImpl waypoint : waypoints.values()) {
            this.waypointMap.put(waypoint.getGuid(), (ClientWaypointImpl)waypoint);
            WaypointEventManager.readWaypointEvent(waypoint);
            this.dimensions.addAll(waypoint.getDimensions());
        }
    }

    public List<String> getLoadedDimensions() {
        return new ArrayList<String>(this.dimensions);
    }

    public static void toggleAllWaypoints() {
        List<ClientWaypointImpl> validWaypoints = WaypointStore.getInstance().waypointMap.values().stream().filter(wp -> WaypointGroupStore.getInstance().get(wp.groupId).isEnabled()).toList();
        boolean enable = !validWaypoints.stream().filter(wp -> !wp.isEnabled()).toList().isEmpty();
        WaypointStore.getInstance().toggleWaypoints(validWaypoints, enable);
    }

    public void toggleWaypoints(List<ClientWaypointImpl> waypoints, boolean enable) {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        waypoints.forEach(wp -> {
            wp.setEnabled(enable);
            if (wp.isPersistent()) {
                dao.addWaypoint((WaypointImpl)wp);
            }
        });
        dao.save(true);
    }

    public void toggleWaypoints(List<ClientWaypointImpl> waypoints) {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        waypoints.forEach(wp -> {
            wp.setEnabled(!wp.isEnabled());
            if (wp.isPersistent()) {
                dao.addWaypoint((WaypointImpl)wp);
            }
        });
        dao.save(true);
    }

    public static void toggleWaypointRendering() {
        WaypointStore.renderWaypoints(JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get() == false);
    }

    public static void renderWaypoints(boolean value) {
        ChatLog.announceWaypointRendering(value);
        JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.set(value);
    }
}

