/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.epicpowerbracelets;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.foxgirl.epicpowerbracelets.item.AbstractBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.InvisibilityBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.NightVisionBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.SlowFallBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.SpeedBraceletItem;
import dev.foxgirl.epicpowerbracelets.item.StrengthBraceletItem;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class EpicPowerBraceletsImpl {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"epicpowerbracelets", (ResourceKey)Registries.ITEM);
    public static final RegistrySupplier<AbstractBraceletItem> INVISIBILITY_BRACELET = ITEMS.register("invisibility_bracelet", InvisibilityBraceletItem::new);
    public static final RegistrySupplier<AbstractBraceletItem> NIGHT_VISION_BRACELET = ITEMS.register("night_vision_bracelet", NightVisionBraceletItem::new);
    public static final RegistrySupplier<AbstractBraceletItem> SLOW_FALL_BRACELET = ITEMS.register("slow_fall_bracelet", SlowFallBraceletItem::new);
    public static final RegistrySupplier<AbstractBraceletItem> SPEED_BRACELET = ITEMS.register("speed_bracelet", SpeedBraceletItem::new);
    public static final RegistrySupplier<AbstractBraceletItem> STRENGTH_BRACELET = ITEMS.register("strength_bracelet", StrengthBraceletItem::new);
    public static final Supplier<Set<AbstractBraceletItem>> BRACELETS = Suppliers.memoize(() -> ImmutableSet.copyOf((Object[])new AbstractBraceletItem[]{(AbstractBraceletItem)((Object)((Object)INVISIBILITY_BRACELET.get())), (AbstractBraceletItem)((Object)((Object)NIGHT_VISION_BRACELET.get())), (AbstractBraceletItem)((Object)((Object)SLOW_FALL_BRACELET.get())), (AbstractBraceletItem)((Object)((Object)SPEED_BRACELET.get())), (AbstractBraceletItem)((Object)((Object)STRENGTH_BRACELET.get()))}));
    private final Map<UUID, Set<MobEffect>> activeEffectsMapping = new WeakHashMap<UUID, Set<MobEffect>>();

    public EpicPowerBraceletsImpl() {
        ITEMS.register();
        TickEvent.PLAYER_POST.register(this::onPlayerTick);
        TickEvent.SERVER_LEVEL_POST.register(this::onLevelTick);
    }

    private Set<MobEffect> getActiveEffects(Player player) {
        return this.activeEffectsMapping.computeIfAbsent(player.getUUID(), __ -> new ReferenceArraySet());
    }

    private void onPlayerTick(Player player) {
        if (player.level().isClientSide()) {
            return;
        }
        Set<MobEffect> activeEffects = this.getActiveEffects(player);
        for (AbstractBraceletItem bracelet : BRACELETS.get()) {
            Holder<MobEffect> effect = bracelet.getMobEffect();
            MobEffectInstance effectInstance = player.getEffect(effect);
            if (player.getMainHandItem().getItem() == bracelet || player.getOffhandItem().getItem() == bracelet) {
                if (effectInstance != null && effectInstance.getAmplifier() != 0) continue;
                player.addEffect(new MobEffectInstance(effect, 210), (Entity)player);
                activeEffects.add((MobEffect)effect.value());
                continue;
            }
            if (!activeEffects.remove(effect.value()) || effectInstance == null || effectInstance.getDuration() > 210 || effectInstance.getAmplifier() != 0) continue;
            player.removeEffect(effect);
        }
    }

    private void applyBraceletToMob(Mob mob, AbstractBraceletItem bracelet) {
        Holder<MobEffect> effect = bracelet.getMobEffect();
        MobEffectInstance effectInstance = mob.getEffect(effect);
        if (effectInstance == null || effectInstance.getAmplifier() == 0) {
            mob.addEffect(new MobEffectInstance(effect, 70), (Entity)mob);
        }
    }

    private void onLevelTick(ServerLevel level) {
        for (Entity entity : level.getAllEntities()) {
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            for (ItemStack stack : mob.getHandSlots()) {
                Item item = stack.getItem();
                if (!(item instanceof AbstractBraceletItem)) continue;
                this.applyBraceletToMob(mob, (AbstractBraceletItem)item);
            }
        }
    }
}

